/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import b.a.lb;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryAppearanceServiceImpl
extends OrderEntryAppearanceService {
    private static final String a;
    private static final long b;

    @NotNull
    public CellAppearanceEx forOrderEntry(Project project2, @NotNull OrderEntry orderEntry, boolean selected) {
        if (orderEntry == null) {
            OrderEntryAppearanceServiceImpl.a(0);
        }
        if (orderEntry instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
            Sdk sdk = jdkOrderEntry.getJdk();
            if (!orderEntry.isValid()) {
                String string = jdkOrderEntry.getJdkName();
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(string != null ? string : a);
                if (cellAppearanceEx == null) {
                    OrderEntryAppearanceServiceImpl.a(1);
                }
                return cellAppearanceEx;
            }
            CellAppearanceEx cellAppearanceEx = this.forJdk(sdk, false, selected, true);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(2);
            }
            return cellAppearanceEx;
        }
        if (!orderEntry.isValid()) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(3);
            }
            return cellAppearanceEx;
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (!libraryOrderEntry.isValid()) {
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
                if (cellAppearanceEx == null) {
                    OrderEntryAppearanceServiceImpl.a(4);
                }
                return cellAppearanceEx;
            }
            Library library = libraryOrderEntry.getLibrary();
            assert (library != null) : libraryOrderEntry;
            CellAppearanceEx cellAppearanceEx = this.forLibrary(project2, library, !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(5);
            }
            return cellAppearanceEx;
        }
        if (orderEntry.isSynthetic()) {
            String string = orderEntry.getPresentableName();
            Icon icon = orderEntry instanceof ModuleSourceOrderEntry ? OrderEntryAppearanceServiceImpl.a(false) : null;
            SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(string, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.a(6);
            }
            return simpleTextCellAppearance;
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Icon icon = ModuleType.get((Module)((ModuleOrderEntry)orderEntry).getModule()).getIcon();
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)orderEntry.getPresentableName(), (Icon)icon);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.a(7);
            }
            return simpleTextCellAppearance;
        }
        CompositeAppearance compositeAppearance = CompositeAppearance.single((String)orderEntry.getPresentableName());
        if (compositeAppearance == null) {
            OrderEntryAppearanceServiceImpl.a(8);
        }
        return compositeAppearance;
    }

    @NotNull
    public CellAppearanceEx forLibrary(Project project2, @NotNull Library library, boolean hasInvalidRoots) {
        long l2 = b ^ 0x610944675F3DL;
        if (library == null) {
            OrderEntryAppearanceServiceImpl.a(9);
        }
        StructureConfigurableContext structureConfigurableContext = ProjectStructureConfigurable.getInstance(project2).getContext();
        Icon icon = LibraryPresentationManager.getInstance().getCustomIcon(library, structureConfigurableContext);
        String string = library.getName();
        if (string != null) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.a(string, icon != null ? icon : PlatformIcons.LIBRARY_ICON, hasInvalidRoots);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(10);
            }
            return cellAppearanceEx;
        }
        String[] stringArray = library.getUrls(OrderRootType.CLASSES);
        if (stringArray.length == 0) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]), (Icon)PlatformIcons.LIBRARY_ICON);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.a(11);
            }
            return simpleTextCellAppearance;
        }
        if (stringArray.length == 1) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.a(new LightFilePointer(stringArray[0]));
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(12);
            }
            return cellAppearanceEx;
        }
        String string2 = StringUtil.trimEnd((String)stringArray[0], (String)"!/");
        String string3 = ProjectBundle.message((String)"library.unnamed.text", (Object[])new Object[]{PathUtil.getFileName((String)string2), stringArray.length - 1});
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)string3, (Icon)PlatformIcons.LIBRARY_ICON);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.a(13);
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    public CellAppearanceEx forJdk(@Nullable Sdk jdk, boolean isInComboBox, boolean selected, boolean showVersion) {
        String string;
        if (jdk == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(a);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(14);
            }
            return cellAppearanceEx;
        }
        String string2 = jdk.getName();
        CompositeAppearance compositeAppearance = new CompositeAppearance();
        SdkType sdkType = (SdkType)jdk.getSdkType();
        compositeAppearance.setIcon(sdkType.getIcon());
        SimpleTextAttributes simpleTextAttributes = OrderEntryAppearanceServiceImpl.a(sdkType.sdkHasValidPath(jdk), selected);
        CompositeAppearance.DequeEnd dequeEnd = compositeAppearance.getEnding();
        dequeEnd.addText(string2, simpleTextAttributes);
        if (showVersion && (string = jdk.getVersionString()) != null && !string.equals(string2)) {
            SimpleTextAttributes simpleTextAttributes2 = isInComboBox && !selected ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, Color.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            dequeEnd.addComment(string, simpleTextAttributes2);
        }
        CompositeAppearance compositeAppearance2 = dequeEnd.getAppearance();
        if (compositeAppearance2 == null) {
            OrderEntryAppearanceServiceImpl.a(15);
        }
        return compositeAppearance2;
    }

    private static SimpleTextAttributes a(boolean bl2, boolean bl3) {
        long l2 = b ^ 0x3D8F52F02F91L;
        if (!bl2) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!bl3 || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    @NotNull
    public CellAppearanceEx forContentFolder(@NotNull ContentFolder folder) {
        if (folder == null) {
            OrderEntryAppearanceServiceImpl.a(16);
        }
        if (folder instanceof SourceFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.a(folder, PlatformIcons.FOLDER_ICON);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(17);
            }
            return cellAppearanceEx;
        }
        if (folder instanceof ExcludeFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.a(folder, IconLoader.getDisabledIcon((Icon)PlatformIcons.FOLDER_ICON));
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(18);
            }
            return cellAppearanceEx;
        }
        throw new RuntimeException(folder.getClass().getName());
    }

    @NotNull
    public CellAppearanceEx forModule(@NotNull Module module2) {
        if (module2 == null) {
            OrderEntryAppearanceServiceImpl.a(19);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)module2.getName(), (Icon)ModuleType.get((Module)module2).getIcon());
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.a(20);
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static Icon a(boolean bl2) {
        Icon icon = bl2 ? PlatformIcons.TEST_SOURCE_FOLDER : PlatformIcons.SOURCE_FOLDERS_ICON;
        if (icon == null) {
            OrderEntryAppearanceServiceImpl.a(21);
        }
        return icon;
    }

    @NotNull
    private static CellAppearanceEx a(@NotNull String string, @Nullable Icon icon, boolean bl2) {
        if (string == null) {
            OrderEntryAppearanceServiceImpl.a(22);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = bl2 ? new SimpleTextCellAppearance(string, icon, new SimpleTextAttributes(8, null, (Color)JBColor.RED)) : SimpleTextCellAppearance.regular((String)string, (Icon)icon);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.a(23);
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static CellAppearanceEx a(@NotNull LightFilePointer lightFilePointer) {
        VirtualFile virtualFile;
        if (lightFilePointer == null) {
            OrderEntryAppearanceServiceImpl.a(24);
        }
        CellAppearanceEx cellAppearanceEx = (virtualFile = lightFilePointer.getFile()) != null ? FileAppearanceService.getInstance().forVirtualFile(virtualFile) : FileAppearanceService.getInstance().forInvalidUrl(lightFilePointer.getPresentableUrl());
        if (cellAppearanceEx == null) {
            OrderEntryAppearanceServiceImpl.a(25);
        }
        return cellAppearanceEx;
    }

    @NotNull
    private static CellAppearanceEx a(@NotNull ContentFolder contentFolder, @NotNull Icon icon) {
        SimpleTextAttributes simpleTextAttributes;
        String string;
        if (contentFolder == null) {
            OrderEntryAppearanceServiceImpl.a(26);
        }
        if (icon == null) {
            OrderEntryAppearanceServiceImpl.a(27);
        }
        LightFilePointer lightFilePointer = new LightFilePointer(contentFolder.getUrl());
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(contentFolder.getContentEntry().getUrl());
        if (virtualFile == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(lightFilePointer.getPresentableUrl());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.a(28);
            }
            return cellAppearanceEx;
        }
        String string2 = virtualFile.getPath();
        VirtualFile virtualFile2 = lightFilePointer.getFile();
        if (virtualFile2 == null) {
            String string3 = lightFilePointer.getPresentableUrl();
            string = string3.startsWith(string2) ? string3.substring(string2.length()) : string3;
            simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        } else {
            string = VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (char)File.separatorChar);
            simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        string = StringUtil.isEmpty((String)string) ? "." + File.separatorChar : string;
        SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(string, icon, simpleTextAttributes);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.a(29);
        }
        return simpleTextCellAppearance;
    }

    static {
        b = lb.a(7398741641356686075L, 6357291464665279197L, MethodHandles.lookup().lookupClass()).a(177487740825401L);
        long l2 = b ^ 0x2638D41B733L;
        a = ProjectBundle.message((String)"jdk.missing.item", (Object[])new Object[0]);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x3FFB5C305B31L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forOrderEntry";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forLibrary";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forJdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "forContentFolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "forModule";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFolderIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "normalOrRedWaved";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "forVirtualFilePointer";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRelativePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forOrderEntry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forLibrary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forContentFolder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forModule";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "normalOrRedWaved";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forVirtualFilePointer";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

