/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import b.a.lb;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.projectRoots.ui.a;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger l;
    private static final String q = "sdkTab";
    private Sdk f;
    private final Map<OrderRootType, SdkPathEditor> g = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton o;
    private final Map<SdkType, List<AdditionalDataConfigurable>> n = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> s = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel p;
    private final SdkModificator j = new EditedSdkModificator(null);
    private JPanel a;
    private TabbedPaneWrapper e;
    private final Project r;
    private final SdkModel b;
    private JLabel c;
    private String k;
    private String d;
    private String i;
    private final History m;
    private final Disposable h = Disposer.newDisposable();
    private static final long t;

    public SdkEditor(Project project2, SdkModel sdkModel, History history, ProjectJdkImpl sdk) {
        this.r = project2;
        this.b = sdkModel;
        this.m = history;
        this.f = sdk;
        this.c();
        this.a((Sdk)sdk);
    }

    private void a(Sdk sdk) {
        this.f = sdk;
        if (this.f != null) {
            this.d = this.f.getName();
            this.i = this.f.getHomePath();
        } else {
            this.d = "";
            this.i = "";
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.a != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        long l2 = t ^ 0x505D526273B8L;
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.a;
    }

    private void c() {
        this.a = new JPanel(new GridBagLayout());
        this.e = new TabbedPaneWrapper(this.h);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            SdkPathEditor sdkPathEditor;
            if (this.f != null && !this.showTabForType(orderRootType) || (sdkPathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)orderRootType)).createPathEditor(this.f)) == null) continue;
            sdkPathEditor.setAddBaseDir(this.f.getHomeDirectory());
            this.e.addTab(sdkPathEditor.getDisplayName(), sdkPathEditor.createComponent());
            this.g.put(orderRootType, sdkPathEditor);
        }
        this.e.addChangeListener(changeEvent -> this.m.pushQueryPlace());
        this.o = this.createHomeComponent();
        this.o.getTextField().setEditable(false);
        this.c = new JLabel(this.g());
        this.a.add((Component)this.c, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.a.add((Component)this.o, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.p = new JPanel(new BorderLayout());
        this.a.add((Component)this.p, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.a.add((Component)this.e.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(actionEvent -> this.f());
    }

    protected boolean showTabForType(@NotNull OrderRootType type) {
        if (type == null) {
            SdkEditor.a(0);
        }
        return ((SdkType)this.f.getSdkType()).isRootTypeApplicable(type);
    }

    private String g() {
        long l2 = t ^ 0x3EFBB9600951L;
        return this.f != null ? ((SdkType)this.f.getSdkType()).getHomeFieldLabel() : ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean bl2 = !Comparing.equal((String)(this.f == null ? null : this.f.getName()), (String)this.d);
        bl2 = bl2 || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.a()), (String)FileUtil.toSystemIndependentName((String)this.i));
        for (PathEditor pathEditor : this.g.values()) {
            bl2 = bl2 || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            bl2 = bl2 || additionalDataConfigurable.isModified();
        }
        return bl2;
    }

    public void apply() throws ConfigurationException {
        long l2 = t ^ 0x2DD71B73C92L;
        if (!Comparing.equal((String)this.d, (String)(this.f == null ? "" : this.f.getName())) && (this.f == null || this.f.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.f != null) {
            this.d = this.f.getName();
            this.i = this.f.getHomePath();
            SdkModificator sdkModificator = this.f.getSdkModificator();
            sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)this.a()));
            for (SdkPathEditor sdkPathEditor : this.g.values()) {
                sdkPathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
                if (additionalDataConfigurable == null) continue;
                additionalDataConfigurable.apply();
            }
        }
    }

    public void reset() {
        if (this.f == null) {
            this.a("");
            for (SdkPathEditor sdkPathEditor : this.g.values()) {
                sdkPathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.f.getSdkModificator();
            for (OrderRootType orderRootType : this.g.keySet()) {
                this.g.get(orderRootType).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.a(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.f.getHomePath(), (Object)""))));
        }
        this.k = null;
        this.c.setText(this.g());
        this.b();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            additionalDataConfigurable.reset();
        }
        this.o.setEnabled(this.f != null);
        for (int i10 = 0; i10 < this.e.getTabCount(); ++i10) {
            this.e.setEnabledAt(i10, this.f != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.n.keySet()) {
            for (AdditionalDataConfigurable additionalDataConfigurable : this.n.get(sdkType)) {
                additionalDataConfigurable.disposeUIResources();
            }
        }
        this.n.clear();
        this.s.clear();
        Disposer.dispose((Disposable)this.h);
    }

    private String a() {
        return this.o.getText().trim();
    }

    private void d() {
        for (PathEditor pathEditor : this.g.values()) {
            pathEditor.clearList();
        }
    }

    private void a(String string) {
        Color color;
        this.o.setText(string);
        if (string != null && !string.isEmpty() && this.f != null && this.f.getSdkType().isLocalSdk(this.f)) {
            File file = new File(string);
            boolean bl2 = ((SdkType)this.f.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            color = file.exists() && file.isDirectory() == bl2 ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            color = UIUtil.getFieldForegroundColor();
        }
        this.o.getTextField().setForeground(color);
    }

    private void f() {
        SdkType sdkType = (SdkType)this.f.getSdkType();
        SdkConfigurationUtil.selectSdkHome((SdkType)sdkType, string -> this.a((String)string, sdkType));
    }

    private void a(String string, SdkType sdkType) {
        long l2 = t ^ 0x55A875A53896L;
        if (string == null) {
            return;
        }
        this.a(string.replace('/', File.separatorChar));
        String string2 = this.b(string);
        ((ProjectJdkImpl)this.f).setName(string2);
        try {
            Sdk sdk = (Sdk)this.f.clone();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.setHomePath(string);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(sdk, this.b);
            this.d();
            this.k = sdk.getVersionString();
            if (this.k == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = sdk.getSdkModificator();
            for (OrderRootType orderRootType : this.g.keySet()) {
                SdkPathEditor sdkPathEditor = this.g.get(orderRootType);
                sdkPathEditor.setAddBaseDir(sdk.getHomeDirectory());
                sdkPathEditor.addPaths(sdkModificator.getRoots(orderRootType));
            }
            this.b.getMulticaster().sdkHomeSelected(sdk, string);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            l.error((Throwable)cloneNotSupportedException);
        }
    }

    private String b(String string) {
        Sdk[] sdkArray;
        String string2;
        long l2 = t ^ 0x756D9A481D8L;
        String string3 = this.f.getName();
        if (Comparing.equal((String)string3, (String)(string2 = ((SdkType)this.f.getSdkType()).suggestSdkName(string3, string)))) {
            return string3;
        }
        String string4 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Sdk sdk : sdkArray = this.b.getSdks()) {
            hashSet.add(sdk.getName());
        }
        int n2 = 0;
        while (hashSet.contains(string4)) {
            string4 = string2 + " (" + ++n2 + ")";
        }
        return string4;
    }

    private void b() {
        long l2 = t ^ 0xD0B47754990L;
        this.p.removeAll();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            JComponent jComponent = this.s.get(additionalDataConfigurable);
            if (jComponent == null) {
                jComponent = additionalDataConfigurable.createComponent();
                this.s.put(additionalDataConfigurable, jComponent);
            }
            if (jComponent == null) continue;
            if (additionalDataConfigurable.getTabName() != null) {
                for (int i10 = 0; i10 < this.e.getTabCount(); ++i10) {
                    if (!additionalDataConfigurable.getTabName().equals(this.e.getTitleAt(i10))) continue;
                    this.e.removeTabAt(i10);
                }
                this.e.addTab(additionalDataConfigurable.getTabName(), jComponent);
                continue;
            }
            this.p.add((Component)jComponent, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> e() {
        if (this.f == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                SdkEditor.a(1);
            }
            return list2;
        }
        List<AdditionalDataConfigurable> list3 = this.b(this.f);
        if (list3 == null) {
            SdkEditor.a(2);
        }
        return list3;
    }

    @NotNull
    private List<AdditionalDataConfigurable> b(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        ArrayList arrayList = this.n.get(sdkType);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            this.n.put(sdkType, arrayList);
            AdditionalDataConfigurable additionalDataConfigurable = sdkType.createAdditionalDataConfigurable(this.b, this.j);
            if (additionalDataConfigurable != null) {
                arrayList.add(additionalDataConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider sdkEditorAdditionalOptionsProvider : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.f.getSdkType())) {
                AdditionalDataConfigurable additionalDataConfigurable2 = sdkEditorAdditionalOptionsProvider.createOptions(this.r, this.f);
                if (additionalDataConfigurable2 == null) continue;
                arrayList.add(additionalDataConfigurable2);
            }
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            SdkEditor.a(3);
        }
        return arrayList2;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        long l2 = t ^ 0x1247B9004472L;
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.e.setSelectedTitle((String)place.getPath(q));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        long l2 = t ^ 0x6B4626F4E577L;
        if (place == null) {
            SdkEditor.a(4);
        }
        place.putPath(q, (Object)this.e.getSelectedTitle());
    }

    static {
        t = lb.a(-3254578086153570007L, -5264442067613535280L, MethodHandles.lookup().lookupClass()).a(21426474023143L);
        long l2 = t ^ 0x21A0A797404CL;
        l = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = t ^ 0x62F1BE8D6A27L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private static final long a = lb.a(-5226698167884735856L, -3871240738998436330L, MethodHandles.lookup().lookupClass()).a(195477016603612L);

        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.f.getName();
        }

        public void setName(String name2) {
            ((ProjectJdkImpl)SdkEditor.this.f).setName(name2);
        }

        public String getHomePath() {
            return SdkEditor.this.a();
        }

        public void setHomePath(String path) {
            SdkEditor.this.a(path, (SdkType)SdkEditor.this.f.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.k != null ? SdkEditor.this.k : SdkEditor.this.f.getVersionString();
        }

        public void setVersionString(String versionString) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.f.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData data) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
            PathEditor pathEditor;
            long l2 = a ^ 0x1AE236C191CAL;
            if (rootType == null) {
                EditedSdkModificator.a(0);
            }
            if ((pathEditor = (PathEditor)SdkEditor.this.g.get(rootType)) == null) {
                throw new IllegalStateException("no editor for root type " + rootType);
            }
            VirtualFile[] virtualFileArray = pathEditor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.a(1);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile root2, @NotNull OrderRootType rootType) {
            if (root2 == null) {
                EditedSdkModificator.a(2);
            }
            if (rootType == null) {
                EditedSdkModificator.a(3);
            }
            ((SdkPathEditor)SdkEditor.this.g.get(rootType)).addPaths(new VirtualFile[]{root2});
        }

        public void removeRoot(@NotNull VirtualFile root2, @NotNull OrderRootType rootType) {
            if (root2 == null) {
                EditedSdkModificator.a(4);
            }
            if (rootType == null) {
                EditedSdkModificator.a(5);
            }
            ((SdkPathEditor)SdkEditor.this.g.get(rootType)).removePaths(new VirtualFile[]{root2});
        }

        public void removeRoots(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                EditedSdkModificator.a(6);
            }
            ((SdkPathEditor)SdkEditor.this.g.get(rootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor pathEditor : SdkEditor.this.g.values()) {
                pathEditor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        /* synthetic */ EditedSdkModificator(a x1) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x3B83BE270AEEL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRoots";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

