/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import b.a.lb;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
public abstract class AbstractDependencyDataService<E extends AbstractDependencyData<?>, I extends ExportableOrderEntry>
extends AbstractProjectDataService<E, I> {
    private static final Logger a;
    private static final long d;

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        long l2 = d ^ 0xEB7D7B11238L;
        if (toImport == null) {
            AbstractDependencyDataService.a(0);
        }
        if (project2 == null) {
            AbstractDependencyDataService.a(1);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.a(2);
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap multiMap = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : multiMap.entrySet()) {
            DataNode dataNode = (DataNode)entry.getKey();
            Module module2 = modelsProvider.findIdeModule((ModuleData)dataNode.getData());
            if (module2 == null) {
                a.warn(String.format("Can't import dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), dataNode));
                continue;
            }
            Map<OrderEntry, OrderAware> map2 = this.importData((Collection)entry.getValue(), module2, modelsProvider);
            Map map3 = (Map)dataNode.getUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY);
            if (map3 != null) {
                map3.putAll(map2);
                continue;
            }
            dataNode.putUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY, map2);
        }
    }

    protected abstract Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<E>> var1, @NotNull Module var2, @NotNull IdeModifiableModelsProvider var3);

    @NotNull
    public Computable<Collection<I>> computeOrphanData(@NotNull Collection<DataNode<E>> toImport, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractDependencyDataService.a(3);
        }
        if (projectData == null) {
            AbstractDependencyDataService.a(4);
        }
        if (project2 == null) {
            AbstractDependencyDataService.a(5);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.a(6);
        }
        Computable computable = () -> {
            Object object2;
            if (toImport == null) {
                AbstractDependencyDataService.a(20);
            }
            if (modelsProvider == null) {
                AbstractDependencyDataService.a(21);
            }
            if (projectData == null) {
                AbstractDependencyDataService.a(22);
            }
            MultiMap multiMap = MultiMap.create();
            for (Object object2 : toImport) {
                String string;
                Module[] moduleArray = (Module[])object2.getData();
                Module module2 = modelsProvider.findIdeModule(moduleArray.getOwnerModule());
                if (module2 == null && modelsProvider.getUnloadedModuleDescription(moduleArray.getOwnerModule()) != null) continue;
                assert (module2 != null);
                if (moduleArray instanceof ModuleDependencyData) {
                    Module module3 = modelsProvider.findIdeModule((ModuleData)((ModuleDependencyData)moduleArray).getTarget());
                    if (module3 == null && modelsProvider.getUnloadedModuleDescription((ModuleData)((ModuleDependencyData)moduleArray).getTarget()) != null) continue;
                    assert (module3 != null);
                    string = module3.getName();
                } else {
                    string = AbstractDependencyDataService.a((AbstractDependencyData)moduleArray);
                }
                multiMap.putValue((Object)module2.getName(), (Object)string);
            }
            ModifiableModuleModel modifiableModuleModel = modelsProvider.getModifiableModuleModel();
            object2 = ContainerUtil.newSmartList();
            for (Module module3 : modelsProvider.getModules(projectData)) {
                for (OrderEntry orderEntry : modelsProvider.getOrderEntries(module3)) {
                    String string;
                    if (orderEntry instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry).getLibraryName() == null && orderEntry.getUrls(OrderRootType.CLASSES).length == 0 || !this.getOrderEntryType().isInstance(orderEntry) || multiMap.get((Object)(string = modifiableModuleModel.getActualName(orderEntry.getOwnerModule()))).contains(this.getOrderEntryName(modelsProvider, (ExportableOrderEntry)orderEntry))) continue;
                    object2.add((ExportableOrderEntry)orderEntry);
                }
            }
            return object2;
        };
        if (computable == null) {
            AbstractDependencyDataService.a(7);
        }
        return computable;
    }

    @NotNull
    protected abstract Class<I> getOrderEntryType();

    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull I orderEntry) {
        if (modelsProvider == null) {
            AbstractDependencyDataService.a(8);
        }
        if (orderEntry == null) {
            AbstractDependencyDataService.a(9);
        }
        return orderEntry.getPresentableName();
    }

    public void removeData(@NotNull Computable<Collection<I>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemoveComputable == null) {
            AbstractDependencyDataService.a(10);
        }
        if (toIgnore == null) {
            AbstractDependencyDataService.a(11);
        }
        if (projectData == null) {
            AbstractDependencyDataService.a(12);
        }
        if (project2 == null) {
            AbstractDependencyDataService.a(13);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.a(14);
        }
        Map<Module, Collection<ExportableOrderEntry>> map2 = AbstractDependencyDataService.a((Collection)toRemoveComputable.compute());
        for (Map.Entry<Module, Collection<ExportableOrderEntry>> entry : map2.entrySet()) {
            this.removeData(entry.getValue(), entry.getKey(), modelsProvider);
        }
    }

    @NotNull
    private static Map<Module, Collection<ExportableOrderEntry>> a(@NotNull Collection<? extends ExportableOrderEntry> collection) {
        if (collection == null) {
            AbstractDependencyDataService.a(15);
        }
        HashMap hashMap = ContainerUtilRt.newHashMap();
        for (ExportableOrderEntry exportableOrderEntry : collection) {
            Collection collection2 = (Collection)hashMap.get(exportableOrderEntry.getOwnerModule());
            if (collection2 == null) {
                collection2 = ContainerUtilRt.newArrayList();
                hashMap.put(exportableOrderEntry.getOwnerModule(), collection2);
            }
            collection2.add(exportableOrderEntry);
        }
        HashMap hashMap2 = hashMap;
        if (hashMap2 == null) {
            AbstractDependencyDataService.a(16);
        }
        return hashMap2;
    }

    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            AbstractDependencyDataService.a(17);
        }
        if (module2 == null) {
            AbstractDependencyDataService.a(18);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.a(19);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        for (ExportableOrderEntry exportableOrderEntry : toRemove) {
            modifiableRootModel.removeOrderEntry((OrderEntry)exportableOrderEntry);
        }
    }

    private static String a(AbstractDependencyData abstractDependencyData) {
        long l2 = d ^ 0x76387305DD0BL;
        if (abstractDependencyData instanceof LibraryDependencyData) {
            String string = abstractDependencyData.getInternalName();
            if (StringUtil.isNotEmpty((String)string)) {
                return string;
            }
            Set set = ((LibraryData)((LibraryDependencyData)abstractDependencyData).getTarget()).getPaths(LibraryPathType.BINARY);
            if (!set.isEmpty()) {
                String string2 = (String)set.iterator().next();
                return PathUtil.toPresentableUrl((String)string2);
            }
            return ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
        }
        return abstractDependencyData.getInternalName();
    }

    static {
        d = lb.a(327040427985806272L, -1097216551435527747L, MethodHandles.lookup().lookupClass()).a(130498833058225L);
        a = Logger.getInstance((String)AbstractDependencyDataService.class.getName());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x293BCFBA8714L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveComputable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByModule";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 7: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "groupByModule";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeOrphanData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

