/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import b.a.lb;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger b;
    private final AtomicReference<ExternalSystemTaskState> f;
    private final AtomicReference<Throwable> a;
    @NotNull
    private final transient Project d;
    @NotNull
    private final ExternalSystemTaskId e;
    @NotNull
    private final ProjectSystemId g;
    @NotNull
    private final String c;
    private static final long n;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id2, @NotNull ExternalSystemTaskType type, @NotNull Project project2, @NotNull String externalProjectPath) {
        if (id2 == null) {
            AbstractExternalSystemTask.a(0);
        }
        if (type == null) {
            AbstractExternalSystemTask.a(1);
        }
        if (project2 == null) {
            AbstractExternalSystemTask.a(2);
        }
        if (externalProjectPath == null) {
            AbstractExternalSystemTask.a(3);
        }
        this.f = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
        this.a = new AtomicReference();
        this.g = id2;
        this.d = project2;
        this.e = ExternalSystemTaskId.create((ProjectSystemId)id2, (ExternalSystemTaskType)type, (Project)this.d);
        this.c = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.g;
        if (projectSystemId == null) {
            AbstractExternalSystemTask.a(4);
        }
        return projectSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.e;
        if (externalSystemTaskId == null) {
            AbstractExternalSystemTask.a(5);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        ExternalSystemTaskState externalSystemTaskState = this.f.get();
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.a(6);
        }
        return externalSystemTaskState;
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            AbstractExternalSystemTask.a(7);
        }
        this.f.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update) {
        if (expect == null) {
            AbstractExternalSystemTask.a(8);
        }
        if (update == null) {
            AbstractExternalSystemTask.a(9);
        }
        return this.f.compareAndSet(expect, update);
    }

    public Throwable getError() {
        return this.a.get();
    }

    @NotNull
    public Project getIdeProject() {
        Project project2 = this.d;
        if (project2 == null) {
            AbstractExternalSystemTask.a(10);
        }
        return project2;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.c;
        if (string == null) {
            AbstractExternalSystemTask.a(11);
        }
        return string;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager externalSystemFacadeManager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade remoteExternalSystemFacade = externalSystemFacadeManager.getFacade(this.d, this.c, this.g);
                this.setState(remoteExternalSystemFacade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable throwable) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.a.set(throwable);
                if (this.d.isDisposed()) break block3;
                b.warn(throwable);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.a(12);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.a(13);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){
            private static final long a = lb.a(-2198588598917866921L, 2212596024397112910L, MethodHandles.lookup().lookupClass()).a(122138300743892L);

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                long l2 = a ^ 0x393A2F40E490L;
                if (event == null) {
                    1.a(0);
                }
                if (event instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemStatusEvent) {
                    String string;
                    ExternalSystemStatusEvent externalSystemStatusEvent = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
                    if (externalSystemStatusEvent.getTotal() <= 0L) {
                        indicator.setIndeterminate(true);
                        string = "bytes".equals(externalSystemStatusEvent.getUnit()) ? StringUtil.formatFileSize((long)externalSystemStatusEvent.getProgress()) + " / ?" : "";
                    } else {
                        indicator.setIndeterminate(false);
                        indicator.setFraction((double)externalSystemStatusEvent.getProgress() / (double)externalSystemStatusEvent.getTotal());
                        string = "bytes".equals(externalSystemStatusEvent.getUnit()) ? StringUtil.formatFileSize((long)externalSystemStatusEvent.getProgress()) + " / " + StringUtil.formatFileSize((long)externalSystemStatusEvent.getTotal()) : "";
                    }
                    String string2 = event.getDescription();
                    indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(string2) + (string.isEmpty() ? "" : "  (" + string + ')'));
                } else {
                    indicator.setIndeterminate(true);
                    indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x70642CB00565L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$1", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] externalSystemTaskNotificationListenerArray = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)externalSystemTaskNotificationListenerAdapter) : new ExternalSystemTaskNotificationListener[]{externalSystemTaskNotificationListenerAdapter};
        this.execute(externalSystemTaskNotificationListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (listeners == null) {
            AbstractExternalSystemTask.a(14);
        }
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : listeners) {
            externalSystemProgressNotificationManager.addNotificationListener(this.getId(), externalSystemTaskNotificationListener);
        }
        ExternalSystemProcessingManager externalSystemProcessingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        try {
            externalSystemProcessingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Throwable throwable) {
            this.setState(ExternalSystemTaskState.FAILED);
            this.a.set(throwable);
            b.warn(throwable);
        }
        finally {
            for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : listeners) {
                externalSystemProgressNotificationManager.removeNotificationListener(externalSystemTaskNotificationListener);
            }
            externalSystemProcessingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.a(15);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.a(16);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){
            private static final long a = lb.a(-8998723573305156615L, 5360274465656213514L, MethodHandles.lookup().lookupClass()).a(47374618528115L);

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    2.a(0);
                }
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1168A07016B9L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$2", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] externalSystemTaskNotificationListenerArray = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)externalSystemTaskNotificationListenerAdapter) : new ExternalSystemTaskNotificationListener[]{externalSystemTaskNotificationListenerAdapter};
        return this.cancel(externalSystemTaskNotificationListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState externalSystemTaskState;
        long l2 = n ^ 0x83192FAD6C5L;
        if (listeners == null) {
            AbstractExternalSystemTask.a(17);
        }
        if ((externalSystemTaskState = this.getState()).isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : listeners) {
            externalSystemProgressNotificationManager.addNotificationListener(this.getId(), externalSystemTaskNotificationListener);
        }
        if (!this.compareAndSetState(externalSystemTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        int n2 = 0;
        try {
            int n3 = n2 = this.doCancel();
            return n3 != 0;
        }
        catch (NotSupportedException notSupportedException) {
            NotificationData notificationData = new NotificationData("Cancellation failed", notSupportedException.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notificationData);
        }
        catch (Throwable throwable) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.a.set(throwable);
            b.warn(throwable);
        }
        finally {
            for (ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener : listeners) {
                externalSystemProgressNotificationManager.removeNotificationListener(externalSystemTaskNotificationListener);
            }
        }
        return n2 != 0;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    protected String wrapProgressText(@NotNull String text2) {
        long l2 = n ^ 0x8C07853B087L;
        if (text2 == null) {
            AbstractExternalSystemTask.a(18);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), text2});
        if (string == null) {
            AbstractExternalSystemTask.a(19);
        }
        return string;
    }

    public int hashCode() {
        return this.e.hashCode() + this.g.hashCode();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        AbstractExternalSystemTask abstractExternalSystemTask = (AbstractExternalSystemTask)((Object)o2);
        return this.e.equals((Object)abstractExternalSystemTask.e) && this.g.equals((Object)abstractExternalSystemTask.g);
    }

    public String toString() {
        long l2 = n ^ 0x62A6C8B6636EL;
        return String.format("%s task %s: %s", this.g.getReadableName(), this.e, this.f);
    }

    static {
        n = lb.a(7374944555031178972L, 2787432703058717886L, MethodHandles.lookup().lookupClass()).a(69751642181141L);
        b = Logger.getInstance(AbstractExternalSystemTask.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x4F45705146F4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

