/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import b.a.lb;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.jarRepository.settings.RepositoryLibrariesReloaderKt;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoriesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel i;
    private JBList<String> b;
    private JButton n;
    private JButton j;
    private JButton l;
    private JButton m;
    private JBList<RemoteRepositoryDescription> k;
    private JButton o;
    private JButton h;
    private JButton c;
    private JButton a;
    private JButton g;
    private final Project e;
    private final CollectionListModel<String> f;
    private final CollectionListModel<RemoteRepositoryDescription> d;
    private static final long p = lb.a(7939858557047512787L, -3613767185771977842L, MethodHandles.lookup().lookupClass()).a(166804525105072L);

    public RemoteRepositoriesConfigurable(Project project2) {
        Object[] objectArray = new String[]{};
        this.d();
        this.f = new CollectionListModel(objectArray);
        this.d = new CollectionListModel((Object[])new RemoteRepositoryDescription[0]);
        this.e = project2;
        this.a();
    }

    public boolean isModified() {
        return this.c() || this.b();
    }

    private boolean c() {
        return !this.f.getItems().equals(MavenRepositoryServicesManager.getInstance((Project)this.e).getUrls());
    }

    private boolean b() {
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)this.e).getRepositories();
        return !this.d.getItems().equals(list2);
    }

    private void a() {
        long l2 = p ^ 0x377471BCEF97L;
        RemoteRepositoriesConfigurable.a(this.b, this.f, this.n, this.j, this.l, "Artifactory, Nexus or Bintray Service URLs", "Service URL", "No services", DataAdapter.STRING_ADAPTER);
        RemoteRepositoriesConfigurable.a(this.k, this.d, this.o, this.h, this.c, "Maven Repository URL", "maven Repository URL", "No remote repositories", DataAdapter.REPOSITORY_DESCRIPTION_ADAPTER);
        ListUtil.disableWhenNoSelection((JButton)this.m, this.b);
        this.m.addActionListener(new ActionListener(){
            private static final long a = lb.a(4892908866504161218L, 8799413447687286057L, MethodHandles.lookup().lookupClass()).a(218701451440613L);

            @Override
            public void actionPerformed(ActionEvent e10) {
                String string = (String)RemoteRepositoriesConfigurable.this.b.getSelectedValue();
                if (!StringUtil.isEmpty((String)string)) {
                    RemoteRepositoriesConfigurable.this.m.setEnabled(false);
                    JarRepositoryManager.searchRepositories(RemoteRepositoriesConfigurable.this.e, Collections.singletonList(string), (Processor<? super Collection<RemoteRepositoryDescription>>)((Processor)collection -> {
                        long l2 = a ^ 0x15F06416D347L;
                        RemoteRepositoriesConfigurable.this.m.setEnabled(true);
                        if (collection.isEmpty()) {
                            Messages.showMessageDialog((String)"No repositories found", (String)"Service Connection Failed", (Icon)Messages.getWarningIcon());
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(collection.size()).append(" ").append(StringUtil.pluralize((String)"repository", (int)collection.size())).append(" found");
                            Messages.showMessageDialog((String)stringBuilder.toString(), (String)"Service Connection Successful", (Icon)Messages.getInformationIcon());
                        }
                        return true;
                    }));
                }
            }
        });
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                RemoteRepositoriesConfigurable.this.b(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                RemoteRepositoriesConfigurable.this.a(MavenRepositoryServicesManager.DEFAULT_SERVICES);
            }
        });
    }

    private static <T> void a(final JBList<T> jBList, final CollectionListModel<T> collectionListModel, JButton jButton, JButton jButton2, JButton jButton3, final String string, final String string2, String string3, final DataAdapter<T, String> dataAdapter) {
        jBList.setModel(collectionListModel);
        jBList.setSelectionMode(0);
        jBList.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<T>(){

            public void customize(JList list2, T value, int index, boolean selected, boolean hasFocus) {
                this.setText((String)dataAdapter.toPresentation(value));
            }
        });
        jButton.addActionListener(new ActionListener(){
            private static final long a = lb.a(6925386704842195293L, -1762723097592429288L, MethodHandles.lookup().lookupClass()).a(210909300656749L);

            @Override
            public void actionPerformed(ActionEvent e10) {
                long l2 = a ^ 0x2254C95A3A45L;
                Object object = jBList.getSelectedValue();
                String string3 = Messages.showInputDialog((String)string, (String)("Add " + string2), (Icon)Messages.getQuestionIcon(), (String)(object == null ? "https://" : (String)dataAdapter.toPresentation(object)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)string3)) {
                    collectionListModel.add(dataAdapter.create(string3));
                    jBList.setSelectedValue((Object)string3, true);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){
            private static final long a = lb.a(-1189763375769466820L, -2225570060059505659L, MethodHandles.lookup().lookupClass()).a(85435799024497L);

            @Override
            public void actionPerformed(ActionEvent e10) {
                long l2 = a ^ 0x5E71039637B0L;
                int n2 = jBList.getSelectedIndex();
                Object object = collectionListModel.getElementAt(n2);
                String string3 = Messages.showInputDialog((String)string, (String)("Edit " + string2), (Icon)Messages.getQuestionIcon(), (String)((String)dataAdapter.toPresentation(object)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)string3)) {
                    collectionListModel.setElementAt(dataAdapter.change(object, string3), n2);
                }
            }
        });
        ListUtil.addRemoveListener((JButton)jButton3, jBList);
        ListUtil.disableWhenNoSelection((JButton)jButton2, jBList);
        jBList.getEmptyText().setText(string3);
    }

    public String getDisplayName() {
        long l2 = p ^ 0xEB0890C8CABL;
        return "Remote Jar Repositories";
    }

    public String getHelpTopic() {
        long l2 = p ^ 0x50C4F411572EL;
        return "reference.jar.repositories";
    }

    @NotNull
    public String getId() {
        String string = this.getClass().getName();
        if (string == null) {
            RemoteRepositoriesConfigurable.a(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.i;
    }

    public void apply() throws ConfigurationException {
        List list2 = ContainerUtil.map((Collection)this.d.getItems(), RemoteRepositoryDescription::getUrl);
        List list3 = ContainerUtil.map((Collection)RemoteRepositoriesConfiguration.getInstance((Project)this.e).getRepositories(), RemoteRepositoryDescription::getUrl);
        MavenRepositoryServicesManager.getInstance((Project)this.e).setUrls(this.f.getItems());
        RemoteRepositoriesConfiguration.getInstance((Project)this.e).setRepositories(this.d.getItems());
        if (!list2.containsAll(list3)) {
            RepositoryLibrariesReloaderKt.reloadAllRepositoryLibraries(this.e);
        }
    }

    public void reset() {
        this.a(MavenRepositoryServicesManager.getInstance((Project)this.e).getUrls());
        this.b(RemoteRepositoriesConfiguration.getInstance((Project)this.e).getRepositories());
    }

    private void a(List<String> list2) {
        this.f.removeAll();
        this.f.add(list2);
    }

    private void b(List<RemoteRepositoryDescription> list2) {
        this.d.replaceAll(list2);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = p ^ 0x1945D32C946L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/settings/RemoteRepositoriesConfigurable", "getId"));
    }

    private /* synthetic */ void d() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBList jBList;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JBList jBList2;
        JPanel jPanel;
        long l2 = p ^ 0x511407FEC5AAL;
        this.i = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Maven Jar Repositories", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.k = jBList2 = new JBList();
        jBScrollPane.setViewportView((Component)jBList2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.o = jButton9 = new JButton();
        jButton9.setFocusable(false);
        jButton9.setText("Add");
        jButton9.setMnemonic('D');
        jButton9.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jButton9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.h = jButton8 = new JButton();
        jButton8.setText("Edit");
        jPanel3.add((Component)jButton8, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.c = jButton7 = new JButton();
        jButton7.setText("Remove");
        jPanel3.add((Component)jButton7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.a = jButton6 = new JButton();
        jButton6.setText("Reset Defaults");
        jPanel3.add((Component)jButton6, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Artifactory, Nexus or Bintray Service URLs:", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 0, null, new Dimension(406, 128), null));
        this.b = jBList = new JBList();
        jBList.setLayoutOrientation(0);
        jBScrollPane2.setViewportView((Component)jBList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.n = jButton5 = new JButton();
        jButton5.setFocusable(false);
        jButton5.setText("Add");
        jButton5.setMnemonic('A');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.l = jButton4 = new JButton();
        jButton4.setText("Remove");
        jButton4.setMnemonic('R');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.m = jButton3 = new JButton();
        jButton3.setText("Test");
        jButton3.setMnemonic('T');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton3, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.j = jButton2 = new JButton();
        jButton2.setText("Edit");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.g = jButton = new JButton();
        jButton.setText("Reset Defaults");
        jPanel5.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.i;
    }

    private static final class URLInputVaslidator
    implements InputValidator {
        private URLInputVaslidator() {
        }

        public boolean checkInput(String inputString) {
            try {
                return StringUtil.isNotEmpty((String)new URL(inputString).getHost());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }

    private static interface DataAdapter<Data, Presentation> {
        public static final DataAdapter<String, String> STRING_ADAPTER = new DataAdapter<String, String>(){

            @Override
            public String toPresentation(String s2) {
                return s2;
            }

            @Override
            public String create(String s2) {
                return s2;
            }

            @Override
            public String change(String current, String changes) {
                return changes;
            }
        };
        public static final DataAdapter<RemoteRepositoryDescription, String> REPOSITORY_DESCRIPTION_ADAPTER = new DataAdapter<RemoteRepositoryDescription, String>(){

            @Override
            public String toPresentation(RemoteRepositoryDescription description) {
                return description.getUrl();
            }

            @Override
            public RemoteRepositoryDescription create(String url) {
                UUID uUID = UUID.randomUUID();
                return new RemoteRepositoryDescription(uUID.toString(), uUID.toString(), url);
            }

            @Override
            public RemoteRepositoryDescription change(RemoteRepositoryDescription current, String url) {
                return new RemoteRepositoryDescription(current.getId(), current.getName(), url);
            }
        };

        public Presentation toPresentation(Data var1);

        public Data create(Presentation var1);

        public Data change(Data var1, Presentation var2);
    }
}

