/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourcePathsStep
extends AbstractStepWithProgress<List<JavaModuleSourceRoot>> {
    private static final Logger l;
    private String k;
    @NonNls
    private static final String r = "create_source";
    @NonNls
    private static final String i = "choose_source";
    private final SourcePathsBuilder q;
    private final Icon p;
    private final String v;
    private ElementsChooser<JavaModuleSourceRoot> o;
    private String n;
    private JRadioButton s;
    private JRadioButton u;
    private JTextField j;
    private JTextField t;
    private JPanel m;
    private static final long w;

    public SourcePathsStep(SourcePathsBuilder builder, Icon icon, @NonNls String helpId) {
        long l2 = w ^ 0x631677AC51FAL;
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.q = builder;
        this.p = icon;
        this.v = helpId;
    }

    @Override
    protected JComponent createResultsPanel() {
        long l2 = w ^ 0x43E8F6E1C1C3L;
        this.m = new JPanel(new CardLayout());
        this.m.add((Component)this.e(), r);
        this.m.add((Component)this.c(), i);
        return this.m;
    }

    private JComponent e() {
        long l2 = w ^ 0x3C4EDCA66E1BL;
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = IdeBundle.message((String)"prompt.please.specify.java.sources.directory", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.s = new JRadioButton(IdeBundle.message((String)"radio.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.s, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.j = new JTextField(this.suggestSourceDirectoryName());
        JLabel jLabel2 = new JLabel(IdeBundle.message((String)"prompt.enter.relative.path.to.module.content.root", (Object[])new Object[]{File.separator}));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)0), 0, 0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.withTreeRootVisible(true);
        FieldPanel fieldPanel = SourcePathsStep.createFieldPanel((JTextField)this.j, null, (BrowseFilesListener)new BrowsePathListener(this, this.j, fileChooserDescriptor));
        jPanel.add((Component)fieldPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)10), 0, 0));
        this.u = new JRadioButton(IdeBundle.message((String)"radio.do.not.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.u, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        JLabel jLabel3 = new JLabel(IdeBundle.message((String)"label.source.directory", (Object[])new Object[0]));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.t = new JTextField();
        this.t.setEditable(false);
        this.t.setOpaque(false);
        Insets insets = this.t.getBorder().getBorderInsets(this.t);
        this.t.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        jPanel.add((Component)this.t, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.s);
        buttonGroup.add(this.u);
        this.j.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = lb.a(-6281344211843061965L, 3878022859079682261L, MethodHandles.lookup().lookupClass()).a(54295708614708L);

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.a(0);
                }
                SourcePathsStep.this.f();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2DD3F08115CDL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/newProjectWizard/SourcePathsStep$1", "textChanged"));
            }
        });
        this.s.addItemListener(itemEvent -> {
            boolean bl2 = itemEvent.getStateChange() == 1;
            jLabel2.setEnabled(bl2);
            fieldPanel.setEnabled(bl2);
            jLabel3.setVisible(bl2);
            this.t.setVisible(bl2);
            if (bl2) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.j, true));
            }
        });
        return jPanel;
    }

    @NonNls
    protected String suggestSourceDirectoryName() {
        long l2 = w ^ 0x72C128685212L;
        return "src";
    }

    private void f() {
        String string = this.d();
        if (string != null) {
            this.t.setText(string.replace('/', File.separatorChar));
        } else {
            this.t.setText("");
        }
    }

    private JComponent c() {
        long l2 = w ^ 0x4E80177D0992L;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.o = new ElementsChooser<JavaModuleSourceRoot>(true){
            private static final long a = lb.a(-8280235132925094621L, 6362094260527243775L, MethodHandles.lookup().lookupClass()).a(44443808545354L);

            public String getItemText(@NotNull JavaModuleSourceRoot sourceRoot) {
                long l2 = a ^ 0x5787AE8B83AAL;
                if (sourceRoot == null) {
                    2.a(0);
                }
                String string = sourceRoot.getPackagePrefix();
                return sourceRoot.getDirectory().getAbsolutePath() + (string.isEmpty() ? "" : " (" + string + ")") + " [" + sourceRoot.getRootTypeName() + "]";
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x24595F634BA3L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/ide/util/newProjectWizard/SourcePathsStep$2", "getItemText"));
            }
        };
        String string = IdeBundle.message((String)"label.java.source.files.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.o, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(actionEvent -> this.o.setAllElementsMarked(true));
        jButton2.addActionListener(actionEvent -> this.o.setAllElementsMarked(false));
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.s.isSelected() ? this.j : this.o.getComponent();
    }

    public void updateDataModel() {
        String string;
        long l2 = w ^ 0x199C187D6284L;
        List<Object> list2 = null;
        if (i.equals(this.k)) {
            List list3 = this.o.getMarkedElements();
            if (!list3.isEmpty()) {
                list2 = new ArrayList(list3.size());
                for (JavaModuleSourceRoot javaModuleSourceRoot : list3) {
                    list2.add(Pair.create((Object)FileUtil.toSystemIndependentName((String)javaModuleSourceRoot.getDirectory().getAbsolutePath()), (Object)javaModuleSourceRoot.getPackagePrefix()));
                }
            }
        } else if (this.s.isSelected() && (string = this.d()) != null) {
            list2 = Collections.singletonList(Pair.create((Object)string, (Object)""));
        }
        this.q.setContentEntryPath(this.a());
        if (list2 != null) {
            this.q.setSourcePaths(list2);
        } else {
            this.q.setSourcePaths(new ArrayList());
        }
    }

    @Override
    public boolean validate() throws ConfigurationException {
        long l2 = w ^ 0x76B918E39224L;
        if (!super.validate()) {
            return false;
        }
        if (r.equals(this.k) && this.s.isSelected()) {
            Object object;
            String string = this.d();
            String string2 = this.j.getText().trim();
            if (string2.isEmpty()) {
                object = IdeBundle.message((String)"prompt.relative.path.to.sources.empty", (Object[])new Object[]{FileUtil.toSystemDependentName((String)string)});
                int n2 = Messages.showYesNoCancelDialog((Component)this.j, (String)object, (String)IdeBundle.message((String)"title.mark.source.directory", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.mark", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.do.not.mark", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (n2 == 2) {
                    return false;
                }
                if (n2 == 1) {
                    this.u.doClick();
                }
            }
            if (string != null) {
                File file;
                object = new File(this.a());
                if (!FileUtil.isAncestor((File)object, (File)(file = new File(string)), (boolean)false)) {
                    Messages.showErrorDialog((Component)this.j, (String)IdeBundle.message((String)"error.source.directory.should.be.under.module.content.root.directory", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
                    return false;
                }
                try {
                    VfsUtil.createDirectories((String)file.getPath());
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(iOException.getMessage());
                }
            }
        }
        return true;
    }

    @Nullable
    private String d() {
        String string = this.a();
        if (string != null) {
            String string2 = this.j.getText().trim().replace(File.separatorChar, '/');
            return !string2.isEmpty() ? string + "/" + string2 : string;
        }
        return null;
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.g();
    }

    @Override
    protected void onFinished(List<JavaModuleSourceRoot> foundPaths, boolean canceled) {
        long l2 = w ^ 0x13F3795B4CECL;
        if (!foundPaths.isEmpty()) {
            this.k = i;
            this.o.setElements(foundPaths, true);
        } else {
            this.k = r;
            this.f();
        }
        this.b(canceled ? null : this.a());
        if (i.equals(this.k)) {
            this.o.selectElements(foundPaths.subList(0, 1));
        } else if (r.equals(this.k)) {
            this.j.selectAll();
        }
    }

    private void b(String string) {
        this.n = string;
        ((CardLayout)this.m.getLayout()).show(this.m, this.k);
        this.m.revalidate();
    }

    private boolean g() {
        String string = this.a();
        return this.n == null ? string != null : !this.n.equals(string);
    }

    @Override
    protected List<JavaModuleSourceRoot> calculate() {
        return new ArrayList<JavaModuleSourceRoot>(SourcePathsStep.calculateSourceRoots(this.a()));
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> calculateSourceRoots(String contentRootPath) {
        if (contentRootPath == null) {
            List<JavaModuleSourceRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                SourcePathsStep.a(0);
            }
            return list2;
        }
        Collection<JavaModuleSourceRoot> collection = JavaSourceRootDetectionUtil.suggestRoots(new File(contentRootPath));
        if (collection == null) {
            SourcePathsStep.a(1);
        }
        return collection;
    }

    @Nullable
    private String a() {
        return this.q.getContentEntryPath();
    }

    @Override
    protected String getProgressText() {
        long l2 = w ^ 0x194104C87D8CL;
        String string = this.a();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.p;
    }

    public String getHelpId() {
        return this.v;
    }

    public String getName() {
        long l2 = w ^ 0x7F009A90A17BL;
        return "Path to Sources";
    }

    static {
        w = lb.a(6179896241194337937L, -2096152284222278784L, MethodHandles.lookup().lookupClass()).a(8282019415897L);
        long l2 = w ^ 0x30DDB064D42DL;
        l = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.SourcePathsStep");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = w ^ 0x6990EFE25776L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SourcePathsStep", "calculateSourceRoots"));
    }

    private class BrowsePathListener
    extends BrowseFilesListener {
        private final FileChooserDescriptor b;
        private final JTextField a;
        final /* synthetic */ SourcePathsStep this$0;
        private static final long c = lb.a(1467857233203727407L, 917831756648427027L, MethodHandles.lookup().lookupClass()).a(160124883311982L);

        BrowsePathListener(SourcePathsStep sourcePathsStep, JTextField textField, FileChooserDescriptor chooserDescriptor) {
            long l2 = c ^ 0x5A860A9DC222L;
            this.this$0 = sourcePathsStep;
            super(textField, IdeBundle.message((String)"prompt.select.source.directory", (Object[])new Object[0]), "", chooserDescriptor);
            this.b = chooserDescriptor;
            this.a = textField;
        }

        @Nullable
        private VirtualFile a() {
            String string = this.this$0.a();
            if (string != null) {
                return (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(string));
            }
            return null;
        }

        public void actionPerformed(ActionEvent e10) {
            VirtualFile virtualFile = this.a();
            if (virtualFile != null) {
                this.b.setRoots(new VirtualFile[]{virtualFile});
                String string = this.a.getText().trim();
                super.actionPerformed(e10);
                if (!string.equals(this.a.getText().trim())) {
                    String string2 = this.a.getText().trim().replace(File.separatorChar, '/');
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string2);
                    l.assertTrue(virtualFile2 != null);
                    this.a.setText(VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (char)File.separatorChar));
                }
            }
        }
    }
}

