/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.DetectedRootsChooser;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RootsDetectionStep
extends AbstractStepWithProgress<List<DetectedRootData>> {
    private static final String r = "roots_found";
    private static final String k = "roots_not_found";
    private final ProjectFromSourcesBuilderImpl j;
    private final WizardContext n;
    private final StepSequence l;
    private final Icon q;
    private final String i;
    private DetectedRootsChooser p;
    private String m;
    private JPanel o;
    private static final long s = lb.a(4092732595748791487L, -6113467521554508083L, MethodHandles.lookup().lookupClass()).a(46717366202043L);

    public RootsDetectionStep(ProjectFromSourcesBuilderImpl builder, WizardContext context, StepSequence sequence, Icon icon, @NonNls String helpId) {
        long l2 = s ^ 0x4ECD169A46C2L;
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.j = builder;
        this.n = context;
        this.l = sequence;
        this.q = icon;
        this.i = helpId;
    }

    @Override
    protected JComponent createResultsPanel() {
        long l2 = s ^ 0x33B46D744D6FL;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.p = new DetectedRootsChooser();
        this.p.addSelectionListener(() -> this.c());
        String string = IdeBundle.message((String)"label.project.roots.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.p.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(actionEvent -> this.p.setAllElementsMarked(true));
        jButton2.addActionListener(actionEvent -> this.p.setAllElementsMarked(false));
        this.o = new JPanel(new CardLayout());
        this.o.add(r, jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(JBUI.Borders.empty((int)5));
        jPanel2.add("North", (Component)new MultiLineLabel(IdeBundle.message((String)"label.project.roots.not.found", (Object[])new Object[0])));
        this.o.add(k, jPanel2);
        return this.o;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.p.getComponent();
    }

    public void updateDataModel() {
        List<DetectedRootData> list2 = this.p.getMarkedElements();
        this.j.setupProjectStructure(RootDetectionProcessor.createRootsMap(list2));
        this.c();
    }

    private void c() {
        long l2 = s ^ 0x4D4EFC206AD4L;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("Existing Sources");
        for (DetectedRootData detectedRootData : this.p.getMarkedElements()) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                linkedHashSet.add(projectStructureDetector.getDetectorId());
            }
        }
        this.l.setTypes(linkedHashSet);
        this.n.requestWizardButtonsUpdate();
    }

    @Override
    protected boolean shouldRunProgress() {
        String string = this.b();
        return this.m == null ? string != null : !this.m.equals(string);
    }

    @Override
    protected void onFinished(List<DetectedRootData> foundRoots, boolean canceled) {
        long l2 = s ^ 0x2881B1EF710EL;
        CardLayout cardLayout = (CardLayout)this.o.getLayout();
        if (!foundRoots.isEmpty() && !canceled) {
            this.m = this.b();
            this.p.setElements(foundRoots);
            this.c();
            cardLayout.show(this.o, r);
        } else {
            this.m = null;
            cardLayout.show(this.o, k);
        }
        this.o.revalidate();
    }

    @Override
    protected List<DetectedRootData> calculate() {
        String string = this.b();
        if (string == null) {
            return Collections.emptyList();
        }
        return RootDetectionProcessor.detectRoots(new File(string));
    }

    @Nullable
    private String b() {
        return this.j.getBaseProjectPath();
    }

    @Override
    protected String getProgressText() {
        long l2 = s ^ 0x691D9F5DF120L;
        String string = this.b();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.q;
    }

    public String getHelpId() {
        return this.i;
    }
}

