/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RootDetectionProcessor {
    private static final Logger b;
    private final File d;
    private final ProjectStructureDetector[] c;
    private final List<DetectedProjectRoot>[] e;
    private final FileTypeManager f;
    private final ProgressIndicator a;
    private static final long g;

    @NotNull
    public static List<DetectedRootData> detectRoots(@NotNull File baseProjectFile) {
        if (baseProjectFile == null) {
            RootDetectionProcessor.a(0);
        }
        List<DetectedRootData> list2 = new RootDetectionProcessor(baseProjectFile, (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()).a();
        if (list2 == null) {
            RootDetectionProcessor.a(1);
        }
        return list2;
    }

    public RootDetectionProcessor(File baseDir, ProjectStructureDetector[] detectors) {
        this.d = RootDetectionProcessor.a(baseDir);
        this.c = detectors;
        this.e = new List[this.c.length];
        this.f = FileTypeManager.getInstance();
        this.a = ProgressManager.getInstance().getProgressIndicator();
    }

    private static File a(File file) {
        try {
            return new File(FileUtil.resolveShortWindowsName((String)file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
            return file;
        }
    }

    public static MultiMap<ProjectStructureDetector, DetectedProjectRoot> createRootsMap(List<? extends DetectedRootData> list2) {
        MultiMap multiMap = new MultiMap();
        for (DetectedRootData detectedRootData : list2) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                multiMap.putValue((Object)projectStructureDetector, (Object)detectedRootData.getSelectedRoot());
            }
        }
        return multiMap;
    }

    public Map<ProjectStructureDetector, List<DetectedProjectRoot>> runDetectors() {
        if (!this.d.isDirectory()) {
            return Collections.emptyMap();
        }
        BitSet bitSet = new BitSet(this.c.length);
        bitSet.set(0, this.c.length);
        for (int i10 = 0; i10 < this.c.length; ++i10) {
            this.e[i10] = new ArrayList<DetectedProjectRoot>();
        }
        THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (File file = this.d.getParentFile(); file != null; file = file.getParentFile()) {
            tHashSet.add(file);
        }
        this.a(this.d, bitSet, (Set<File>)tHashSet);
        LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>> linkedHashMap = new LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>>();
        for (int i11 = 0; i11 < this.c.length; ++i11) {
            if (this.e[i11].isEmpty()) continue;
            linkedHashMap.put(this.c[i11], this.e[i11]);
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<File, Integer>> a(File file, BitSet bitSet, Set<File> set) {
        SmartList smartList = new SmartList();
        if (this.f.isFileIgnored(file.getName())) {
            return smartList;
        }
        if (this.a != null) {
            if (this.a.isCanceled()) {
                return smartList;
            }
            this.a.setText2(file.getPath());
        }
        if (FileSystemUtil.isSymLink((File)file)) {
            try {
                if (set.contains(file.getCanonicalFile())) {
                    return smartList;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            set.add(file);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                fileArray = ArrayUtil.EMPTY_FILE_ARRAY;
            }
            BitSet bitSet2 = bitSet;
            int n2 = this.c.length;
            for (int i10 = 0; i10 < n2; ++i10) {
                File file2;
                if (!bitSet.get(i10)) continue;
                ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = this.c[i10].detectRoots(file, fileArray, this.d, this.e[i10]);
                if (!directoryProcessingResult.isProcessChildren()) {
                    if (bitSet2 == bitSet) {
                        bitSet2 = new BitSet();
                        bitSet2.or(bitSet);
                    }
                    bitSet2.set(i10, false);
                }
                if ((file2 = directoryProcessingResult.getParentToSkip()) == null || FileUtil.filesEqual((File)file2, (File)file)) continue;
                smartList.add(Pair.create((Object)file2, (Object)i10));
            }
            if (!bitSet2.isEmpty()) {
                for (File file2 : fileArray) {
                    List<Pair<File, Integer>> list2;
                    if (!file2.isDirectory() || (list2 = this.a(file2, bitSet2, set)).isEmpty()) continue;
                    if (bitSet2 == bitSet) {
                        bitSet2 = new BitSet();
                        bitSet2.or(bitSet);
                    }
                    for (Pair<File, Integer> pair2 : list2) {
                        bitSet2.set((int)((Integer)pair2.getSecond()), false);
                        if (FileUtil.filesEqual((File)((File)pair2.getFirst()), (File)file)) continue;
                        smartList.add(pair2);
                    }
                    if (bitSet2.isEmpty()) break;
                }
            }
            SmartList smartList2 = smartList;
            return smartList2;
        }
        finally {
            set.remove(file);
        }
    }

    private static void b(DetectedProjectRoot detectedProjectRoot, Map<File, DetectedRootData> map2) {
        DetectedRootData[] detectedRootDataArray;
        for (DetectedRootData detectedRootData : detectedRootDataArray = map2.values().toArray(new DetectedRootData[0])) {
            File file = detectedRootData.getDirectory();
            if (!FileUtil.isAncestor((File)detectedProjectRoot.getDirectory(), (File)file, (boolean)true)) continue;
            for (DetectedProjectRoot detectedProjectRoot2 : detectedRootData.getAllRoots()) {
                if (detectedProjectRoot.canContainRoot(detectedProjectRoot2)) continue;
                detectedRootData.removeRoot(detectedProjectRoot2);
            }
            if (!detectedRootData.isEmpty()) continue;
            map2.remove(file);
        }
    }

    private static boolean a(DetectedProjectRoot detectedProjectRoot, Map<File, DetectedRootData> map2) {
        for (File file = detectedProjectRoot.getDirectory().getParentFile(); file != null; file = file.getParentFile()) {
            DetectedRootData detectedRootData = map2.get(file);
            if (detectedRootData == null) continue;
            for (DetectedProjectRoot detectedProjectRoot2 : detectedRootData.getAllRoots()) {
                if (detectedProjectRoot2.canContainRoot(detectedProjectRoot)) continue;
                return true;
            }
        }
        return false;
    }

    private List<DetectedRootData> a() {
        long l2 = g ^ 0x21C5A4AE16B0L;
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> map2 = this.runDetectors();
        if (this.a != null) {
            this.a.setText2("Processing " + map2.values().size() + " project roots...");
        }
        LinkedHashMap<File, DetectedRootData> linkedHashMap = new LinkedHashMap<File, DetectedRootData>();
        for (ProjectStructureDetector projectStructureDetector : map2.keySet()) {
            for (DetectedProjectRoot detectedProjectRoot : map2.get(projectStructureDetector)) {
                if (RootDetectionProcessor.a(detectedProjectRoot, linkedHashMap)) continue;
                DetectedRootData detectedRootData = (DetectedRootData)linkedHashMap.get(detectedProjectRoot.getDirectory());
                if (detectedRootData == null) {
                    linkedHashMap.put(detectedProjectRoot.getDirectory(), new DetectedRootData(projectStructureDetector, detectedProjectRoot));
                } else {
                    detectedProjectRoot = detectedRootData.addRoot(projectStructureDetector, detectedProjectRoot);
                }
                RootDetectionProcessor.b(detectedProjectRoot, linkedHashMap);
            }
        }
        List<DetectedRootData> list2 = this.a(linkedHashMap);
        if (this.a != null) {
            this.a.setText2("");
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private List<DetectedRootData> a(Map<File, DetectedRootData> map2) {
        long l2 = g ^ 0x5093755FE76DL;
        b.debug(map2.size() + " roots found, merging content roots");
        boolean bl2 = false;
        HashSet hashSet = new HashSet();
        HashSet<ModuleType> hashSet2 = new HashSet<ModuleType>();
        block0: for (DetectedRootData object : map2.values()) {
            for (DetectedProjectRoot detectedProjectRoot : object.getAllRoots()) {
                if (detectedProjectRoot instanceof DetectedContentRoot) {
                    Collections.addAll(hashSet, ((DetectedContentRoot)detectedProjectRoot).getTypesToReplace());
                    hashSet2.add(((DetectedContentRoot)detectedProjectRoot).getModuleType());
                    continue;
                }
                if (!(detectedProjectRoot instanceof DetectedSourceRoot)) continue;
                b.debug("Source root found: " + detectedProjectRoot.getDirectory() + ", content roots will be ignored");
                bl2 = true;
                continue block0;
            }
        }
        hashSet2.removeAll(hashSet);
        if (bl2 || hashSet2.size() <= 1) {
            void var9_13;
            void var8_9;
            Iterator<DetectedRootData> iterator = map2.values().iterator();
            Object var8_8 = null;
            Object var9_12 = null;
            while (iterator.hasNext()) {
                DetectedRootData detectedRootData = iterator.next();
                for (DetectedProjectRoot detectedProjectRoot : detectedRootData.getAllRoots()) {
                    if (!(detectedProjectRoot instanceof DetectedContentRoot)) continue;
                    b.debug("Removed detected " + detectedProjectRoot.getRootTypeName() + " content root: " + detectedProjectRoot.getDirectory());
                    Collection<ProjectStructureDetector> collection = detectedRootData.removeRoot(detectedProjectRoot);
                    if (var8_9 != null && var9_13 != null || !hashSet2.contains(((DetectedContentRoot)detectedProjectRoot).getModuleType())) continue;
                    DetectedContentRoot detectedContentRoot = (DetectedContentRoot)detectedProjectRoot;
                    ProjectStructureDetector projectStructureDetector = (ProjectStructureDetector)ContainerUtil.getFirstItem(collection);
                }
                if (!detectedRootData.isEmpty()) continue;
                iterator.remove();
            }
            if (!bl2 && var8_9 != null && var9_13 != null) {
                DetectedContentRoot detectedContentRoot = new DetectedContentRoot(this.d, var8_9.getRootTypeName(), var8_9.getModuleType(), new ModuleType[0]);
                DetectedRootData detectedRootData = map2.get(this.d);
                if (detectedRootData == null) {
                    map2.put(this.d, new DetectedRootData((ProjectStructureDetector)var9_13, detectedContentRoot));
                } else {
                    detectedRootData.addRoot((ProjectStructureDetector)var9_13, detectedContentRoot);
                }
                b.debug("Added " + var8_9.getRootTypeName() + " content root for " + this.d);
            }
        }
        return new ArrayList<DetectedRootData>(map2.values());
    }

    static {
        g = lb.a(-2076979976057867861L, 5629186405773254243L, MethodHandles.lookup().lookupClass()).a(198764694371499L);
        long l2 = g ^ 0x7730DF85D748L;
        b = Logger.getInstance((String)"#com.intellij.ide.util.importProject.RootDetectionProcessor");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x2569A90EF96FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProjectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

