/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectLayoutPanel<T>
extends JPanel {
    private final ElementsChooser<T> b;
    private final JList c;
    private final ModuleInsight a;
    private final Comparator<T> d;
    private static final long g = lb.a(8680007693075231036L, -2386838375603227342L, MethodHandles.lookup().lookupClass()).a(137452434739315L);

    ProjectLayoutPanel(ModuleInsight insight) {
        long l2 = g ^ 0x5D7B999DF543L;
        super(new BorderLayout());
        this.d = (object, object2) -> {
            int n2;
            int n3 = this.getWeight(object);
            if (n3 != (n2 = this.getWeight(object2))) {
                return n3 - n2;
            }
            return ProjectLayoutPanel.getElementText(object).compareToIgnoreCase(ProjectLayoutPanel.getElementText(object2));
        };
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.a = insight;
        this.b = new ElementsChooser<T>(true){
            private static final long a = lb.a(1843938435593276978L, -8698517805860929825L, MethodHandles.lookup().lookupClass()).a(3641747228968L);

            public String getItemText(@NotNull T element) {
                if (element == null) {
                    1.a(0);
                }
                return ProjectLayoutPanel.getElementText(element);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x6909677A4321L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/importProject/ProjectLayoutPanel$1", "getItemText"));
            }
        };
        this.c = this.b();
        Splitter splitter = new Splitter(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.b, "Center");
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)StringUtil.capitalize((String)StringUtil.pluralize((String)this.getElementTypeName())), (boolean)false));
        splitter.setFirstComponent((JComponent)jPanel);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.c);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getDependenciesTitle(), (boolean)false));
        splitter.setSecondComponent((JComponent)jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.a().getComponent(), "North");
        jPanel3.add((Component)splitter, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        MultiLineLabel multiLineLabel = new MultiLineLabel(this.getStepDescriptionText());
        this.add((Component)multiLineLabel, "North");
        this.add((Component)jPanel3, "Center");
        this.b.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                List list2 = ProjectLayoutPanel.this.getSelectedEntries();
                Collection collection = ProjectLayoutPanel.this.getDependencies(list2);
                DefaultListModel defaultListModel = (DefaultListModel)ProjectLayoutPanel.this.c.getModel();
                defaultListModel.clear();
                for (Object e11 : ProjectLayoutPanel.this.a(new ArrayList(collection))) {
                    defaultListModel.addElement(e11);
                }
            }
        });
    }

    private ActionToolbar a() {
        long l2 = g ^ 0x7A8AE1750A7CL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        RenameAction renameAction = new RenameAction(this);
        renameAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(117, 64)), this);
        defaultActionGroup.add((AnAction)renameAction);
        MergeAction mergeAction = new MergeAction(this);
        mergeAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(114, 0)), this);
        defaultActionGroup.add((AnAction)mergeAction);
        SplitAction splitAction = new SplitAction(this);
        splitAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this);
        defaultActionGroup.add((AnAction)splitAction);
        return ActionManager.getInstance().createActionToolbar("ProjectLayoutPanel.Entries", (ActionGroup)defaultActionGroup, true);
    }

    public final ModuleInsight getInsight() {
        return this.a;
    }

    private JList b() {
        JBList jBList = new JBList(new DefaultListModel());
        jBList.getSelectionModel().setSelectionMode(2);
        jBList.setCellRenderer(new MyListCellRenderer());
        return jBList;
    }

    public final Collection getDependencies(List<? extends T> entries) {
        HashSet hashSet = new HashSet();
        for (T t2 : entries) {
            hashSet.addAll(this.getDependencies(t2));
        }
        return hashSet;
    }

    @NotNull
    public List<T> getSelectedEntries() {
        List list2 = this.b.getSelectedElements();
        if (list2 == null) {
            ProjectLayoutPanel.a(0);
        }
        return list2;
    }

    @NotNull
    public List<T> getChosenEntries() {
        List list2 = this.b.getMarkedElements();
        if (list2 == null) {
            ProjectLayoutPanel.a(1);
        }
        return list2;
    }

    public void rebuild() {
        this.b.clear();
        for (T t2 : this.a(this.getEntries())) {
            this.b.addElement(t2, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(t2));
        }
        if (this.b.getElementCount() > 0) {
            this.b.selectElements(Collections.singleton(this.b.getElementAt(0)));
        }
    }

    private List<T> a(List<T> list2) {
        Collections.sort(list2, this.d);
        return list2;
    }

    @Nullable
    protected Icon getElementIcon(Object element) {
        if (element instanceof ModuleDescriptor) {
            return ((ModuleDescriptor)element).getModuleType().getIcon();
        }
        if (element instanceof LibraryDescriptor) {
            return PlatformIcons.LIBRARY_ICON;
        }
        if (element instanceof File) {
            File file = (File)element;
            return file.isDirectory() ? PlatformIcons.FOLDER_ICON : PlatformIcons.JAR_ICON;
        }
        return null;
    }

    protected int getWeight(Object element) {
        if (element instanceof File) {
            return 10;
        }
        if (element instanceof ModuleDescriptor) {
            return 20;
        }
        if (element instanceof LibraryDescriptor) {
            return ((LibraryDescriptor)element).getJars().size() > 1 ? 30 : 40;
        }
        return Integer.MAX_VALUE;
    }

    protected static String getElementText(Object element) {
        long l2 = g ^ 0x2D0B802E907CL;
        if (element instanceof LibraryDescriptor) {
            File file;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((LibraryDescriptor)element).getName());
            Collection<File> collection = ((LibraryDescriptor)element).getJars();
            if (collection.size() == 1 && (file = collection.iterator().next().getParentFile()) != null) {
                stringBuilder.append(" (");
                stringBuilder.append(file.getPath());
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }
        if (element instanceof File) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((File)element).getName());
            File file = ((File)element).getParentFile();
            if (file != null) {
                stringBuilder.append(" (");
                stringBuilder.append(file.getPath());
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }
        if (element instanceof ModuleDescriptor) {
            Collection<? extends DetectedProjectRoot> collection;
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)element;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(moduleDescriptor.getName());
            Set<File> set = moduleDescriptor.getContentRoots();
            int n2 = set.size();
            if (n2 > 0) {
                stringBuilder.append(" (");
                stringBuilder.append(set.iterator().next().getPath());
                if (n2 > 1) {
                    stringBuilder.append("...");
                }
                stringBuilder.append(")");
            }
            if ((collection = moduleDescriptor.getSourceRoots()).size() > 0) {
                stringBuilder.append(" [");
                Iterator<? extends DetectedProjectRoot> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DetectedProjectRoot detectedProjectRoot = iterator.next();
                    stringBuilder.append(detectedProjectRoot.getDirectory().getName());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    protected abstract List<T> getEntries();

    protected abstract Collection getDependencies(T var1);

    @Nullable
    protected abstract T merge(List<T> var1);

    @Nullable
    protected abstract T split(T var1, String var2, Collection<File> var3);

    protected abstract Collection<File> getContent(T var1);

    protected abstract String getElementName(T var1);

    protected abstract void setElementName(T var1, String var2);

    protected abstract String getSplitDialogChooseFilesPrompt();

    protected abstract String getNameAlreadyUsedMessage(String var1);

    protected abstract String getStepDescriptionText();

    protected abstract String getEntriesChooserTitle();

    protected abstract String getDependenciesTitle();

    protected abstract String getElementTypeName();

    private boolean a(String string) {
        HashSet hashSet = new HashSet(this.b.getSelectedElements());
        for (T t2 : this.getEntries()) {
            if (hashSet.contains(t2) || !string.equals(this.getElementName(t2))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = g ^ 0xA87967DFA8AL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEntries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenEntries";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EntryProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final T a;

        EntryProperties(T entry) {
            this.a = entry;
        }

        public Icon getIcon() {
            return ProjectLayoutPanel.this.getElementIcon(this.a);
        }
    }

    private class SplitDialog
    extends DialogWrapper {
        final JTextField myNameField;
        final ElementsChooser<File> myChooser;
        final /* synthetic */ ProjectLayoutPanel this$0;
        private static final long a = lb.a(6341617652062561216L, 6966759286794171574L, MethodHandles.lookup().lookupClass()).a(21090282642855L);

        private SplitDialog(final ProjectLayoutPanel projectLayoutPanel, Collection<File> files) {
            long l2 = a ^ 0x6FD66C823716L;
            this.this$0 = projectLayoutPanel;
            super((Component)projectLayoutPanel.b, true);
            this.setTitle("Split " + StringUtil.capitalize((String)projectLayoutPanel.getElementTypeName()));
            this.myNameField = new JTextField();
            this.myChooser = new ElementsChooser<File>(true){
                private static final long a = lb.a(3440953355443917538L, -6615013228311333837L, MethodHandles.lookup().lookupClass()).a(190775932003653L);

                protected String getItemText(@NotNull File value) {
                    if (value == null) {
                        1.a(0);
                    }
                    return ProjectLayoutPanel.getElementText(value);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x37313CB211E0L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$1", "getItemText"));
                }
            };
            for (final File file : files) {
                this.myChooser.addElement((Object)file, false, new MultiStateElementsChooser.ElementProperties(){

                    public Icon getIcon() {
                        return SplitDialog.this.this$0.getElementIcon(file);
                    }
                });
            }
            this.myChooser.selectElements((Collection)ContainerUtil.createMaybeSingletonList((Object)ContainerUtil.getFirstItem(files)));
            this.myChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<File>(){

                public void elementMarkChanged(File element, boolean isMarked) {
                    SplitDialog.this.a();
                }
            });
            this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
                private static final long a = lb.a(2946383974477601283L, 7948094102539582672L, MethodHandles.lookup().lookupClass()).a(53484963460130L);

                protected void textChanged(@NotNull DocumentEvent e10) {
                    if (e10 == null) {
                        4.a(0);
                    }
                    SplitDialog.this.a();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x7B1DE942F228L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$4", "textChanged"));
                }
            });
            this.init();
            this.a();
        }

        private void a() {
            this.setOKActionEnabled(!this.getName().isEmpty() && !this.getChosenFiles().isEmpty());
        }

        protected void doOKAction() {
            String string = this.getName();
            if (this.this$0.a(string)) {
                Messages.showErrorDialog((String)this.this$0.getNameAlreadyUsedMessage(string), (String)"");
                return;
            }
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            long l2 = a ^ 0x5B1733B4E3AL;
            FormBuilder formBuilder = FormBuilder.createFormBuilder().setVertical(true);
            formBuilder.addLabeledComponent("&Name:", (JComponent)this.myNameField);
            formBuilder.addLabeledComponent(this.this$0.getSplitDialogChooseFilesPrompt(), this.myChooser);
            this.myChooser.setPreferredSize((Dimension)JBUI.size((int)450, (int)300));
            return formBuilder.getPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public String getName() {
            return this.myNameField.getText().trim();
        }

        public Collection<File> getChosenFiles() {
            return this.myChooser.getMarkedElements();
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            this.setText(ProjectLayoutPanel.getElementText(value));
            this.setIcon(ProjectLayoutPanel.this.getElementIcon(value));
            return component;
        }
    }

    private class RenameAction
    extends AnAction {
        final /* synthetic */ ProjectLayoutPanel this$0;
        private static final long a = lb.a(8445586670527690881L, -9117435131628146089L, MethodHandles.lookup().lookupClass()).a(38647669177991L);

        private RenameAction(ProjectLayoutPanel projectLayoutPanel) {
            long l2 = a ^ 0x5CF9BA5749EEL;
            this.this$0 = projectLayoutPanel;
            super("Rename", "", IconUtil.getEditIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            List list2;
            long l2 = a ^ 0x552545D8201EL;
            if (e10 == null) {
                RenameAction.a(0);
            }
            if ((list2 = this.this$0.b.getSelectedElements()).size() == 1) {
                Object e11 = list2.get(0);
                String string = Messages.showInputDialog((Component)this.this$0, (String)("New name for " + this.this$0.getElementTypeName() + " '" + this.this$0.getElementName(e11) + "':"), (String)("Rename " + StringUtil.capitalize((String)this.this$0.getElementTypeName())), (Icon)Messages.getQuestionIcon(), (String)this.this$0.getElementName(e11), (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        if (RenameAction.this.this$0.a(inputString.trim())) {
                            Messages.showErrorDialog((String)RenameAction.this.this$0.getNameAlreadyUsedMessage(inputString), (String)"");
                            return false;
                        }
                        return true;
                    }
                });
                if (string != null) {
                    this.this$0.setElementName(e11, string);
                    this.this$0.b.sort(this.this$0.d);
                    this.this$0.b.selectElements(Collections.singleton(e11));
                }
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                RenameAction.a(1);
            }
            super.update(e10);
            e10.getPresentation().setEnabled(this.this$0.b.getSelectedElements().size() == 1);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x6C93E90866DL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$RenameAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SplitAction
    extends AnAction {
        final /* synthetic */ ProjectLayoutPanel this$0;
        private static final long a = lb.a(-4588747296048314703L, -3346132237142129855L, MethodHandles.lookup().lookupClass()).a(91691449617121L);

        private SplitAction(ProjectLayoutPanel projectLayoutPanel) {
            long l2 = a ^ 0x494396CD0128L;
            this.this$0 = projectLayoutPanel;
            super("Split", "", AllIcons.Modules.Split);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Collection<File> collection;
            String string;
            Object e11;
            Object e12;
            Collection<File> collection2;
            SplitDialog splitDialog;
            List list2;
            if (e10 == null) {
                SplitAction.a(0);
            }
            if ((list2 = this.this$0.b.getSelectedElements()).size() == 1 && (splitDialog = new SplitDialog(this.this$0, collection2 = this.this$0.getContent(e12 = list2.get(0)))).showAndGet() && (e11 = this.this$0.split(e12, string = splitDialog.getName(), collection = splitDialog.getChosenFiles())) != null) {
                if (!this.this$0.getEntries().contains(e12)) {
                    this.this$0.b.removeElement(e12);
                }
                this.this$0.b.addElement(e11, true, (MultiStateElementsChooser.ElementProperties)this.this$0.new EntryProperties(e11));
                this.this$0.b.sort(this.this$0.d);
                this.this$0.b.selectElements(Collections.singleton(e11));
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SplitAction.a(1);
            }
            List list2 = this.this$0.b.getSelectedElements();
            e10.getPresentation().setEnabled(list2.size() == 1 && this.this$0.getContent(list2.get(0)).size() > 1);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x41D002C893EBL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MergeAction
    extends AnAction {
        final /* synthetic */ ProjectLayoutPanel this$0;
        private static final long a = lb.a(-1090029450483057698L, 6780558288878898655L, MethodHandles.lookup().lookupClass()).a(39780104971377L);

        private MergeAction(ProjectLayoutPanel projectLayoutPanel) {
            long l2 = a ^ 0x5F459CD02492L;
            this.this$0 = projectLayoutPanel;
            super("Merge", "", AllIcons.Modules.Merge);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            String string;
            List list2;
            long l2 = a ^ 0x32E3CE420469L;
            if (e10 == null) {
                MergeAction.a(0);
            }
            if ((list2 = this.this$0.b.getSelectedElements()).size() > 1 && (string = Messages.showInputDialog((Component)this.this$0, (String)"Enter new name for merge result:", (String)"Merge", (Icon)Messages.getQuestionIcon(), (String)this.this$0.getElementName(list2.get(0)), (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return true;
                }

                public boolean canClose(String inputString) {
                    if (MergeAction.this.this$0.a(inputString.trim())) {
                        Messages.showErrorDialog((String)MergeAction.this.this$0.getNameAlreadyUsedMessage(inputString), (String)"");
                        return false;
                    }
                    return true;
                }
            })) != null) {
                Object t2 = this.this$0.merge(list2);
                this.this$0.setElementName(t2, string);
                for (Object e11 : list2) {
                    this.this$0.b.removeElement(e11);
                }
                this.this$0.b.addElement(t2, true, (MultiStateElementsChooser.ElementProperties)this.this$0.new EntryProperties(t2));
                this.this$0.b.sort(this.this$0.d);
                this.this$0.b.selectElements(Collections.singleton(t2));
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                MergeAction.a(1);
            }
            super.update(e10);
            e10.getPresentation().setEnabled(this.this$0.b.getSelectedElements().size() > 1);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x2C6B039B6EA6L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$MergeAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

