/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import b.a.lb;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.util.ui.UIUtil;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TestFailedLineInspection
extends LocalInspectionTool {
    private static final long a = lb.a(270190107849097715L, -4216097411850125740L, MethodHandles.lookup().lookupClass()).a(42747837806167L);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TestFailedLineInspection.a(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement psiElement = call.getMethodExpression().getReferenceNameElement();
                if (psiElement == null) {
                    return;
                }
                TestStateStorage.Record record = TestFailedLineManager.getInstance((Project)call.getProject()).getFailedLineState(call);
                if (record == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new DebugFailedTestFix((PsiElement)call, record.topStacktraceLine), new RunActionFix((PsiElement)call, DefaultRunExecutor.EXECUTOR_ID)};
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor(psiElement, record.errorMessage, isOnTheFly, localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                problemDescriptor.setTextAttributes(CodeInsightColors.RUNTIME_ERROR);
                holder.registerProblem(problemDescriptor);
            }
        };
        if (javaElementVisitor == null) {
            TestFailedLineInspection.a(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x34C12A5EEA77L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestFailedLineInspection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestFailedLineInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunActionFix
    implements LocalQuickFix,
    Iconable {
        private final ConfigurationContext c;
        private final Executor a;
        private final RunnerAndConfigurationSettings b;
        private static final long f = lb.a(-1729885010620934266L, 3799436821781167525L, MethodHandles.lookup().lookupClass()).a(174086781498250L);

        RunActionFix(PsiElement element, String executorId) {
            this.a = ExecutorRegistry.getInstance().getExecutorById(executorId);
            this.c = new ConfigurationContext(element);
            this.b = this.c.getConfiguration();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.a.getStartActionText(ProgramRunnerUtil.shortenName((String)this.b.getName(), (int)0));
            String string2 = UIUtil.removeMnemonic((String)string);
            if (string2 == null) {
                RunActionFix.a(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                RunActionFix.a(1);
            }
            if (descriptor2 == null) {
                RunActionFix.a(2);
            }
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)this.b, (Executor)this.a);
        }

        public Icon getIcon(int flags) {
            return this.a.getIcon();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = f ^ 0xA74CED6C7C3L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/TestFailedLineInspection$RunActionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/TestFailedLineInspection$RunActionFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DebugFailedTestFix
    extends RunActionFix {
        private final String d;
        private static final long e = lb.a(-8150482354348524370L, 1189179721985894216L, MethodHandles.lookup().lookupClass()).a(133279478045041L);

        DebugFailedTestFix(PsiElement element, String topStacktraceLine) {
            super(element, DefaultDebugExecutor.EXECUTOR_ID);
            this.d = topStacktraceLine;
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Document document;
            StackTraceLine stackTraceLine;
            Location<PsiMethod> location;
            if (project2 == null) {
                DebugFailedTestFix.b(0);
            }
            if (descriptor2 == null) {
                DebugFailedTestFix.b(1);
            }
            if ((location = (stackTraceLine = new StackTraceLine(project2, this.d)).getMethodLocation(project2)) != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(((PsiMethod)location.getPsiElement()).getContainingFile())) != null) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().addLineBreakpoint(document, stackTraceLine.getLineNumber());
            }
            super.applyFix(project2, descriptor2);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = e ^ 0x3D0D8C79588DL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/testframework/TestFailedLineInspection$DebugFailedTestFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

