/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import java.io.IOException;
import java.util.Collection;

class PersistentObjectSeq {
    private static final Logger a = Logger.getInstance(PersistentObjectSeq.class);
    private final Collection<PersistentObject> b = ContainerUtil.newConcurrentSet();

    PersistentObjectSeq() {
    }

    public void add(final InvertedIndex<?, ?, ?> index) {
        this.b.add(new PersistentObject(){

            @Override
            public void flush() throws Exception {
                index.flush();
            }

            @Override
            public void close() {
                index.dispose();
            }
        });
    }

    public void add(final PersistentEnumeratorDelegate<?> enumerator) {
        this.b.add(new PersistentObject(){

            @Override
            public void flush() {
                if (enumerator.isDirty()) {
                    enumerator.force();
                }
            }

            @Override
            public void close() throws IOException {
                enumerator.close();
            }
        });
    }

    public void close(boolean ignoreCloseProblem) {
        for (PersistentObject persistentObject : this.b) {
            try {
                persistentObject.close();
            }
            catch (Throwable throwable) {
                if (ignoreCloseProblem) continue;
                throw new RuntimeException(throwable);
            }
        }
    }

    public void flush() {
        for (PersistentObject persistentObject : this.b) {
            try {
                persistentObject.flush();
            }
            catch (Exception exception) {
                a.error((Throwable)exception);
            }
        }
    }

    public void clear() {
        this.b.clear();
    }

    static interface PersistentObject {
        public void flush() throws Exception;

        public void close() throws IOException;
    }
}

