/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import b.a.lb;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTree;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.ui.ActiveComponent;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.vcsUtil.VcsFileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class ShowAffectedTestsAction
extends AnAction {
    private static final String a = "Run All Affected Tests";
    private static final long b = lb.a(6780595545819297637L, -7420004258998503527L, MethodHandles.lookup().lookupClass()).a(225307476741970L);

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            ShowAffectedTestsAction.a(0);
        }
        e10.getPresentation().setEnabledAndVisible(ShowAffectedTestsAction.isEnabled(e10.getProject()) && (ShowAffectedTestsAction.a(e10) != null || ShowAffectedTestsAction.c(e10) != null || ShowAffectedTestsAction.e(e10) != null || e10.getData(VcsDataKeys.CHANGES) != null));
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            ShowAffectedTestsAction.a(1);
        }
        Project project2 = e10.getProject();
        assert (project2 != null);
        PsiMethod psiMethod = ShowAffectedTestsAction.a(e10);
        if (psiMethod != null) {
            ShowAffectedTestsAction.a(project2, psiMethod, e10);
            return;
        }
        PsiClass psiClass = ShowAffectedTestsAction.c(e10);
        if (psiClass != null) {
            ShowAffectedTestsAction.a(project2, psiClass, e10);
            return;
        }
        if (e10.getData(VcsDataKeys.CHANGES) != null) {
            ShowAffectedTestsAction.d(e10);
            return;
        }
        VirtualFile virtualFile = ShowAffectedTestsAction.e(e10);
        if (virtualFile != null) {
            ShowAffectedTestsAction.a(project2, virtualFile, e10);
        }
    }

    private static void a(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull AnActionEvent anActionEvent) {
        VirtualFile virtualFile2;
        long l2 = b ^ 0x444CC403792EL;
        if (project2 == null) {
            ShowAffectedTestsAction.a(2);
        }
        if (virtualFile == null) {
            ShowAffectedTestsAction.a(3);
        }
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(4);
        }
        if ((virtualFile2 = ShowAffectedTestsAction.a(project2)) == null) {
            return;
        }
        DiscoveredTestsTree discoveredTestsTree = ShowAffectedTestsAction.a(project2, anActionEvent.getDataContext(), virtualFile.getName());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String string;
            if (virtualFile == null) {
                ShowAffectedTestsAction.a(88);
            }
            if (project2 == null) {
                ShowAffectedTestsAction.a(89);
            }
            if ((string = VcsFileUtil.getRelativeFilePath((VirtualFile)virtualFile, (VirtualFile)virtualFile2)) != null) {
                List<String> list2 = Collections.singletonList("/" + string);
                ShowAffectedTestsAction.processMethodsAsync(project2, PsiMethod.EMPTY_ARRAY, list2, ShowAffectedTestsAction.f(discoveredTestsTree), () -> discoveredTestsTree.setPaintBusy(false));
            }
        });
    }

    private static void a(@NotNull Project project2, @NotNull PsiClass psiClass, @NotNull AnActionEvent anActionEvent) {
        long l2 = b ^ 0x58CA70060271L;
        if (project2 == null) {
            ShowAffectedTestsAction.a(5);
        }
        if (psiClass == null) {
            ShowAffectedTestsAction.a(6);
        }
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(7);
        }
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)anActionEvent.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String string = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)1);
        DiscoveredTestsTree discoveredTestsTree = ShowAffectedTestsAction.a(project2, dataContext, string);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(85);
            }
            if (psiClass == null) {
                ShowAffectedTestsAction.a(86);
            }
            if (DumbService.isDumb((Project)project2)) {
                return;
            }
            String string = (String)ReadAction.compute(() -> {
                if (psiClass == null) {
                    ShowAffectedTestsAction.a(87);
                }
                return ShowAffectedTestsAction.a(psiClass);
            });
            if (string == null) {
                return;
            }
            List list2 = ContainerUtil.newSmartList((Object)Couple.of((Object)string, null));
            ShowAffectedTestsAction.a(project2, ShowAffectedTestsAction.f(discoveredTestsTree), list2, Collections.emptyList());
            EdtInvocationManager.getInstance().invokeLater(() -> discoveredTestsTree.setPaintBusy(false));
        });
    }

    private static void a(@NotNull Project project2, @NotNull PsiMethod psiMethod, @NotNull AnActionEvent anActionEvent) {
        Couple<String> couple;
        long l2 = b ^ 0x2024C1670329L;
        if (project2 == null) {
            ShowAffectedTestsAction.a(8);
        }
        if (psiMethod == null) {
            ShowAffectedTestsAction.a(9);
        }
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(10);
        }
        if ((couple = ShowAffectedTestsAction.b(psiMethod)) == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)anActionEvent.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String string = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        DiscoveredTestsTree discoveredTestsTree = ShowAffectedTestsAction.a(project2, dataContext, string);
        ShowAffectedTestsAction.processMethodsAsync(project2, new PsiMethod[]{psiMethod}, Collections.emptyList(), ShowAffectedTestsAction.f(discoveredTestsTree), () -> discoveredTestsTree.setPaintBusy(false));
    }

    @NotNull
    private static TestDiscoveryProducer.PsiTestProcessor f(@NotNull DiscoveredTestsTree discoveredTestsTree) {
        if (discoveredTestsTree == null) {
            ShowAffectedTestsAction.a(11);
        }
        TestDiscoveryProducer.PsiTestProcessor psiTestProcessor = (psiClass, psiMethod, string) -> {
            if (discoveredTestsTree == null) {
                ShowAffectedTestsAction.a(84);
            }
            discoveredTestsTree.addTest(psiClass, psiMethod, string);
            return true;
        };
        if (psiTestProcessor == null) {
            ShowAffectedTestsAction.a(12);
        }
        return psiTestProcessor;
    }

    private static void d(@NotNull AnActionEvent anActionEvent) {
        long l2 = b ^ 0x69CCE6E41E66L;
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(13);
        }
        Change[] changeArray = (Change[])anActionEvent.getRequiredData(VcsDataKeys.CHANGES);
        Project project2 = anActionEvent.getProject();
        assert (project2 != null);
        ShowAffectedTestsAction.showDiscoveredTestsByChanges(project2, changeArray, "Selected Changes", anActionEvent.getDataContext());
    }

    public static void showDiscoveredTestsByChanges(@NotNull Project project2, @NotNull Change[] changes, @NotNull String title, @NotNull DataContext dataContext) {
        long l2 = b ^ 0x8F056402221L;
        if (project2 == null) {
            ShowAffectedTestsAction.a(14);
        }
        if (changes == null) {
            ShowAffectedTestsAction.a(15);
        }
        if (title == null) {
            ShowAffectedTestsAction.a(16);
        }
        if (dataContext == null) {
            ShowAffectedTestsAction.a(17);
        }
        DiscoveredTestsTree discoveredTestsTree = ShowAffectedTestsAction.a(project2, dataContext, title);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery.selected.changes");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(82);
            }
            if (changes == null) {
                ShowAffectedTestsAction.a(83);
            }
            PsiMethod[] psiMethodArray = ShowAffectedTestsAction.findMethods(project2, changes);
            List<String> list2 = ShowAffectedTestsAction.getRelativeAffectedPaths(project2, Arrays.asList(changes));
            ShowAffectedTestsAction.processMethodsAsync(project2, psiMethodArray, list2, ShowAffectedTestsAction.f(discoveredTestsTree), () -> discoveredTestsTree.setPaintBusy(false));
        });
    }

    @NotNull
    public static PsiMethod[] findMethods(@NotNull Project project2, Change ... changes) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(18);
        }
        if (changes == null) {
            ShowAffectedTestsAction.a(19);
        }
        UastMetaLanguage uastMetaLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);
        PsiMethod[] psiMethodArray = (PsiMethod[])PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(79);
            }
            if (changes == null) {
                ShowAffectedTestsAction.a(80);
            }
            return (PsiMethod[])FormatChangedTextUtil.getInstance().getChangedElements(project2, changes, virtualFile -> {
                if (project2 == null) {
                    ShowAffectedTestsAction.a(81);
                }
                if (DumbService.isDumb((Project)project2) || project2.isDisposed() || !virtualFile.isValid()) {
                    return null;
                }
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
                if (!projectFileIndex.isInSource(virtualFile)) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (psiFile == null || !uastMetaLanguage.matchesLanguage(psiFile.getLanguage())) {
                    return null;
                }
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                if (document == null) {
                    return null;
                }
                final List list2 = ContainerUtil.newSmartList();
                psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
                        if (uMethod != null) {
                            ContainerUtil.addAllNotNull((Collection)list2, (Object[])new PsiElement[]{uMethod.getSourcePsi()});
                        }
                        super.visitElement(element);
                    }
                });
                return list2;
            }).stream().map(psiElement -> UastContextKt.toUElement((PsiElement)psiElement)).filter(Objects::nonNull).map(uElement -> (PsiMethod)ObjectUtils.tryCast((Object)uElement.getJavaPsi(), PsiMethod.class)).filter(Objects::nonNull).toArray(arg_0 -> ((ArrayFactory)PsiMethod.ARRAY_FACTORY).create(arg_0));
        });
        if (psiMethodArray == null) {
            ShowAffectedTestsAction.a(20);
        }
        return psiMethodArray;
    }

    public static boolean isEnabled(@Nullable Project project2) {
        long l2 = b ^ 0x41F85F9640C1L;
        if (project2 == null || DumbService.isDumb((Project)project2)) {
            return false;
        }
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    @Nullable
    private static VirtualFile e(@NotNull AnActionEvent anActionEvent) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(21);
        }
        if ((virtualFile = (VirtualFile)anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE)) == null && (psiFile = (PsiFile)anActionEvent.getData(CommonDataKeys.PSI_FILE)) != null) {
            virtualFile = psiFile.getVirtualFile();
        }
        return virtualFile != null && virtualFile.isInLocalFileSystem() ? virtualFile : null;
    }

    @Nullable
    private static PsiMethod a(@NotNull AnActionEvent anActionEvent) {
        UMethod uMethod;
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(22);
        }
        return (uMethod = (UMethod)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.b(anActionEvent), UMethod.class)) == null ? null : (PsiMethod)ObjectUtils.tryCast((Object)uMethod.getJavaPsi(), PsiMethod.class);
    }

    @Nullable
    private static PsiClass c(@NotNull AnActionEvent anActionEvent) {
        UClass uClass;
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(23);
        }
        return (uClass = (UClass)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.b(anActionEvent), UClass.class)) == null ? null : (PsiClass)ObjectUtils.tryCast((Object)uClass.getJavaPsi(), PsiClass.class);
    }

    @Nullable
    private static PsiElement b(@NotNull AnActionEvent anActionEvent) {
        PsiElement psiElement;
        if (anActionEvent == null) {
            ShowAffectedTestsAction.a(24);
        }
        Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)anActionEvent.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || psiFile == null) {
            return null;
        }
        int n2 = editor.getCaretModel().getOffset();
        PsiElement psiElement2 = psiFile.findElementAt(n2);
        if (psiElement2 instanceof PsiWhiteSpace && n2 > 0 && !((psiElement = psiFile.findElementAt(n2 - 1)) instanceof PsiWhiteSpace)) {
            return psiElement;
        }
        return psiElement2;
    }

    @NotNull
    private static DiscoveredTestsTree a(final @NotNull Project project2, @NotNull DataContext dataContext, final @NotNull String string) {
        long l2 = b ^ 0x5EFCB57C0453L;
        if (project2 == null) {
            ShowAffectedTestsAction.a(25);
        }
        if (dataContext == null) {
            ShowAffectedTestsAction.a(26);
        }
        if (string == null) {
            ShowAffectedTestsAction.a(27);
        }
        final DiscoveredTestsTree discoveredTestsTree = new DiscoveredTestsTree(string);
        final String string2 = "Tests for " + string;
        final Ref ref = new Ref();
        final ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)dataContext);
        ActiveComponent activeComponent = ShowAffectedTestsAction.a(a, AllIcons.Actions.Execute, () -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(78);
            }
            ShowAffectedTestsAction.a(project2, discoveredTestsTree, (Ref<? extends JBPopup>)ref, configurationContext, string2);
        }, discoveredTestsTree);
        Runnable runnable = () -> {
            JBPopup jBPopup;
            UsageView usageView;
            long l2 = b ^ 0x533DEE2261BL;
            if (project2 == null) {
                ShowAffectedTestsAction.a(77);
            }
            if ((usageView = FindUtil.showInUsageView(null, (Object[])discoveredTestsTree.getTestMethods(), testMethodUsage -> testMethodUsage, (String)string2, usageViewPresentation -> {
                long l2 = b ^ 0x25599399FA10L;
                usageViewPresentation.setCodeUsages(false);
                usageViewPresentation.setUsagesWord("test");
                usageViewPresentation.setMergeDupLinesAvailable(false);
                usageViewPresentation.setUsageTypeFilteringAvailable(false);
                usageViewPresentation.setExcludeAvailable(false);
            }, (Project)project2)) != null) {
                usageView.addButtonToLowerPane((Action)new AbstractAction(a, AllIcons.Actions.Execute){

                    @Override
                    public void actionPerformed(ActionEvent e10) {
                        ShowAffectedTestsAction.a(project2, discoveredTestsTree, (Ref<? extends JBPopup>)ref, configurationContext, string2);
                    }
                });
            }
            if ((jBPopup = (JBPopup)ref.get()) != null) {
                jBPopup.cancel();
            }
        };
        KeyStroke keyStroke = ShowAffectedTestsAction.a();
        String string3 = "Open Find Usages Toolwindow" + (keyStroke == null ? "" : " " + KeymapUtil.getKeystrokeText((KeyStroke)keyStroke));
        ActiveComponent activeComponent2 = ShowAffectedTestsAction.a(string3, AllIcons.General.Pin_tab, runnable, discoveredTestsTree);
        PopupChooserBuilder popupChooserBuilder = new PopupChooserBuilder((JTree)((Object)discoveredTestsTree)).setTitle(string2).setMovable(true).setResizable(true).setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{activeComponent2})).setSettingButton((Component)new CompositeActiveComponent(new ActiveComponent[]{activeComponent}).getComponent()).setItemChoosenCallback(() -> PsiNavigateUtil.navigate((PsiElement)discoveredTestsTree.getSelectedElement())).registerKeyboardAction(keyStroke, actionEvent -> runnable.run()).setMinSize((Dimension)new JBDimension(500, 300)).setDimensionServiceKey(ShowAffectedTestsAction.class.getSimpleName());
        final JBPopup jBPopup = popupChooserBuilder.createPopup();
        ref.set((Object)jBPopup);
        TreeModel treeModel = discoveredTestsTree.getModel();
        if (treeModel instanceof Disposable) {
            Disposer.register((Disposable)jBPopup, (Disposable)((Disposable)treeModel));
        }
        treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            private static final long a = lb.a(-5791006924913783962L, 4951982299991489077L, MethodHandles.lookup().lookupClass()).a(262931918797761L);

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                long l2 = a ^ 0x56F872A14AEFL;
                if (event == null) {
                    3.a(0);
                }
                if (type == null) {
                    3.a(1);
                }
                int n2 = discoveredTestsTree.getTestCount();
                int n3 = discoveredTestsTree.getTestClassesCount();
                jBPopup.setCaption("Found " + n2 + " " + StringUtil.pluralize((String)"Test", (int)n2) + " in " + n3 + " " + StringUtil.pluralize((String)"Class", (int)n3) + " for " + string);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x847094686B9L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$3";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        jBPopup.showInBestPositionFor(dataContext);
        DiscoveredTestsTree discoveredTestsTree2 = discoveredTestsTree;
        if (discoveredTestsTree2 == null) {
            ShowAffectedTestsAction.a(28);
        }
        return discoveredTestsTree2;
    }

    public static void processMethodsAsync(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor, @Nullable Runnable doWhenDone) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(29);
        }
        if (methods == null) {
            ShowAffectedTestsAction.a(30);
        }
        if (filePaths == null) {
            ShowAffectedTestsAction.a(31);
        }
        if (processor == null) {
            ShowAffectedTestsAction.a(32);
        }
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(73);
            }
            if (methods == null) {
                ShowAffectedTestsAction.a(74);
            }
            if (filePaths == null) {
                ShowAffectedTestsAction.a(75);
            }
            if (processor == null) {
                ShowAffectedTestsAction.a(76);
            }
            ShowAffectedTestsAction.processMethods(project2, methods, filePaths, processor);
            if (doWhenDone != null) {
                EdtInvocationManager.getInstance().invokeLater(doWhenDone);
            }
        });
    }

    public static void processMethods(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(33);
        }
        if (methods == null) {
            ShowAffectedTestsAction.a(34);
        }
        if (filePaths == null) {
            ShowAffectedTestsAction.a(35);
        }
        if (processor == null) {
            ShowAffectedTestsAction.a(36);
        }
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (methods == null) {
                ShowAffectedTestsAction.a(72);
            }
            return Arrays.stream(methods).map(psiMethod -> ShowAffectedTestsAction.b(psiMethod)).filter(Objects::nonNull).collect(Collectors.toList());
        });
        ShowAffectedTestsAction.a(project2, processor, list2, filePaths);
    }

    private static void a(@NotNull Project project2, @NotNull TestDiscoveryProducer.PsiTestProcessor psiTestProcessor, @NotNull List<Couple<String>> list2, @NotNull List<String> list3) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(37);
        }
        if (psiTestProcessor == null) {
            ShowAffectedTestsAction.a(38);
        }
        if (list2 == null) {
            ShowAffectedTestsAction.a(39);
        }
        if (list3 == null) {
            ShowAffectedTestsAction.a(40);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
        for (TestDiscoveryConfigurationProducer testDiscoveryConfigurationProducer : ShowAffectedTestsAction.b(project2)) {
            byte by2 = ((JavaTestConfigurationWithDiscoverySupport)testDiscoveryConfigurationProducer.getConfigurationFactory().createTemplateConfiguration(project2)).getTestFrameworkId();
            TestDiscoveryProducer.consumeDiscoveredTests(project2, list2, by2, list3, (string, string2, string3) -> {
                if (project2 == null) {
                    ShowAffectedTestsAction.a(68);
                }
                if (psiTestProcessor == null) {
                    ShowAffectedTestsAction.a(69);
                }
                PsiClass[] psiClassArray = new PsiClass[]{null};
                PsiMethod[] psiMethodArray = new PsiMethod[]{null};
                ReadAction.run(() -> {
                    if (project2 == null) {
                        ShowAffectedTestsAction.a(70);
                    }
                    DumbService.getInstance((Project)project2).runWithAlternativeResolveEnabled(() -> {
                        boolean bl2;
                        if (project2 == null) {
                            ShowAffectedTestsAction.a(71);
                        }
                        psiClassArray[0] = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)string, null, (boolean)true, (GlobalSearchScope)globalSearchScope);
                        boolean bl3 = bl2 = string3 != null;
                        if (psiClassArray[0] != null) {
                            psiMethodArray[0] = (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClassArray[0].findMethodsByName(string2, bl2));
                        }
                    });
                });
                return psiMethodArray[0] == null || psiTestProcessor.process(psiClassArray[0], psiMethodArray[0], string3);
            });
        }
    }

    @NotNull
    private static ActiveComponent a(final @NotNull String string, final @NotNull Icon icon, final @NotNull Runnable runnable, final @NotNull DiscoveredTestsTree discoveredTestsTree) {
        if (string == null) {
            ShowAffectedTestsAction.a(41);
        }
        if (icon == null) {
            ShowAffectedTestsAction.a(42);
        }
        if (runnable == null) {
            ShowAffectedTestsAction.a(43);
        }
        if (discoveredTestsTree == null) {
            ShowAffectedTestsAction.a(44);
        }
        ActiveComponent.Adapter adapter2 = new ActiveComponent.Adapter(){
            private static final long a = lb.a(-5250549524942720342L, -551230986320077870L, MethodHandles.lookup().lookupClass()).a(157159739807101L);

            @NotNull
            public JComponent getComponent() {
                long l2 = a ^ 0x44F1ADC12B33L;
                final Presentation presentation = new Presentation();
                presentation.setText(string);
                presentation.setDescription(string);
                presentation.setIcon(icon);
                presentation.setEnabled(false);
                discoveredTestsTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
                    private static final long a = lb.a(-5436172822760461069L, -3488991989965384260L, MethodHandles.lookup().lookupClass()).a(218435350099297L);

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                        if (event == null) {
                            1.a(0);
                        }
                        if (type == null) {
                            1.a(1);
                        }
                        if (!presentation.isEnabled() && discoveredTestsTree.getTestCount() != 0) {
                            presentation.setEnabled(true);
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        long l2 = a ^ 0x1CE3D5F64BDEL;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "type";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$4$1";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                ActionButton actionButton = new ActionButton(new AnAction(){
                    private static final long a = lb.a(3033682172068922769L, 4363617077759509349L, MethodHandles.lookup().lookupClass()).a(31754146621804L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            2.a(0);
                        }
                        runnable.run();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x1AB891C49640L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$4$2", "actionPerformed"));
                    }
                }, presentation, "ShowDiscoveredTestsToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
                if (actionButton == null) {
                    4.a(0);
                }
                return actionButton;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x16B111EA3E36L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$4", "getComponent"));
            }
        };
        if (adapter2 == null) {
            ShowAffectedTestsAction.a(45);
        }
        return adapter2;
    }

    private static void a(@NotNull Project project2, @NotNull DiscoveredTestsTree discoveredTestsTree, @NotNull Ref<? extends JBPopup> ref, @NotNull ConfigurationContext configurationContext, @NotNull String string) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(46);
        }
        if (discoveredTestsTree == null) {
            ShowAffectedTestsAction.a(47);
        }
        if (ref == null) {
            ShowAffectedTestsAction.a(48);
        }
        if (configurationContext == null) {
            ShowAffectedTestsAction.a(49);
        }
        if (string == null) {
            ShowAffectedTestsAction.a(50);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Module module2 = TestDiscoveryConfigurationProducer.detectTargetModule(discoveredTestsTree.getContainingModules(), project2);
        List list2 = Arrays.stream(discoveredTestsTree.getTestMethods()).map(TestMethodUsage::calculateLocation).filter(Objects::nonNull).collect(Collectors.toList());
        ShowAffectedTestsAction.b(project2).stream().map(testDiscoveryConfigurationProducer -> Pair.pair((Object)testDiscoveryConfigurationProducer, (Object)ContainerUtil.filter((Collection)list2, testDiscoveryConfigurationProducer::isApplicable))).max(Comparator.comparingInt(pair2 -> ((List)pair2.second).size())).map(pair2 -> {
            if (configurationContext == null) {
                ShowAffectedTestsAction.a(66);
            }
            if (string == null) {
                ShowAffectedTestsAction.a(67);
            }
            Location[] locationArray = ((List)pair2.second).toArray(new Location[0]);
            return ((TestDiscoveryConfigurationProducer)((Object)((Object)pair2.first))).createProfile(locationArray, module2, configurationContext, string);
        }).ifPresent(runProfile -> {
            if (project2 == null) {
                ShowAffectedTestsAction.a(63);
            }
            if (string == null) {
                ShowAffectedTestsAction.a(64);
            }
            if (ref == null) {
                ShowAffectedTestsAction.a(65);
            }
            try {
                ExecutionEnvironmentBuilder.create((Project)project2, (Executor)executor, (RunProfile)runProfile).buildAndExecute();
            }
            catch (ExecutionException executionException) {
                ExecutionUtil.handleExecutionError((Project)project2, (String)executor.getToolWindowId(), (String)string, (Throwable)executionException);
            }
            JBPopup jBPopup = (JBPopup)ref.get();
            if (jBPopup != null) {
                jBPopup.cancel();
            }
        });
    }

    @Nullable
    private static Couple<String> b(@NotNull PsiMethod psiMethod) {
        PsiClass psiClass;
        if (psiMethod == null) {
            ShowAffectedTestsAction.a(51);
        }
        String string = (psiClass = psiMethod.getContainingClass()) != null ? ShowAffectedTestsAction.a(psiClass) : null;
        return string == null ? null : Couple.of((Object)string, (Object)ShowAffectedTestsAction.a(psiMethod));
    }

    @NotNull
    private static String a(@NotNull PsiMethod psiMethod) {
        long l2 = b ^ 0x2F6627DD1203L;
        if (psiMethod == null) {
            ShowAffectedTestsAction.a(52);
        }
        String string = "/" + ClassUtil.getAsmMethodSignature((PsiMethod)psiMethod);
        String string2 = (psiMethod.isConstructor() ? "<init>" : psiMethod.getName()) + string;
        if (string2 == null) {
            ShowAffectedTestsAction.a(53);
        }
        return string2;
    }

    @Nullable
    private static String a(@NotNull PsiClass psiClass) {
        PsiClass psiClass2;
        if (psiClass == null) {
            ShowAffectedTestsAction.a(54);
        }
        if (psiClass instanceof PsiAnonymousClass && (psiClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            return ClassUtil.getJVMClassName((PsiClass)psiClass2) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        return ClassUtil.getJVMClassName((PsiClass)psiClass);
    }

    @Nullable
    private static KeyStroke a() {
        long l2 = b ^ 0x28DD66CC3E86L;
        AnAction anAction = ActionManager.getInstance().getAction("FindUsages");
        ShortcutSet shortcutSet = anAction == null ? null : anAction.getShortcutSet();
        return shortcutSet == null ? null : KeymapUtil.getKeyStroke((ShortcutSet)shortcutSet);
    }

    @NotNull
    private static List<TestDiscoveryConfigurationProducer> b(@NotNull Project project2) {
        if (project2 == null) {
            ShowAffectedTestsAction.a(55);
        }
        List<TestDiscoveryConfigurationProducer> list2 = RunConfigurationProducer.getProducers((Project)project2).stream().filter(runConfigurationProducer -> runConfigurationProducer instanceof TestDiscoveryConfigurationProducer).map(runConfigurationProducer -> (TestDiscoveryConfigurationProducer)((Object)runConfigurationProducer)).collect(Collectors.toList());
        if (list2 == null) {
            ShowAffectedTestsAction.a(56);
        }
        return list2;
    }

    @NotNull
    public static List<String> getRelativeAffectedPaths(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
        VirtualFile virtualFile;
        if (project2 == null) {
            ShowAffectedTestsAction.a(57);
        }
        if (changes == null) {
            ShowAffectedTestsAction.a(58);
        }
        List<String> list2 = (virtualFile = ShowAffectedTestsAction.a(project2)) == null ? Collections.emptyList() : changes.stream().map(change -> ShowAffectedTestsAction.a(virtualFile, change)).filter(Objects::nonNull).map(string -> "/" + string).collect(Collectors.toList());
        if (list2 == null) {
            ShowAffectedTestsAction.a(59);
        }
        return list2;
    }

    @Nullable
    private static VirtualFile a(@NotNull Project project2) {
        String string;
        if (project2 == null) {
            ShowAffectedTestsAction.a(60);
        }
        return (string = project2.getBasePath()) == null ? null : LocalFileSystem.getInstance().findFileByPath(string);
    }

    @Nullable
    private static String a(@NotNull VirtualFile virtualFile, @NotNull Change change) {
        ContentRevision contentRevision;
        VirtualFile virtualFile2;
        if (virtualFile == null) {
            ShowAffectedTestsAction.a(61);
        }
        if (change == null) {
            ShowAffectedTestsAction.a(62);
        }
        if ((virtualFile2 = change.getVirtualFile()) == null && (contentRevision = change.getBeforeRevision()) != null) {
            return VcsFileUtil.relativePath((VirtualFile)virtualFile, (FilePath)contentRevision.getFile());
        }
        return virtualFile2 == null ? null : VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x6E702A2F5555L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 20: 
            case 28: 
            case 45: 
            case 53: 
            case 56: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: 
            case 20: 
            case 28: 
            case 45: 
            case 53: 
            case 56: 
            case 59: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 18: 
            case 25: 
            case 29: 
            case 33: 
            case 37: 
            case 46: 
            case 55: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 44: 
            case 47: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 12: 
            case 20: 
            case 28: 
            case 45: 
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction";
                break;
            }
            case 15: 
            case 19: 
            case 58: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: 
            case 27: 
            case 50: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 30: 
            case 34: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 31: 
            case 35: 
            case 40: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 32: 
            case 36: 
            case 38: 
            case 69: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesAndMethods";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 48: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 49: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeProcessor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "showTree";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createButton";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "methodSignature";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationProducers";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeAffectedPaths";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByPsiClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByPsiMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTreeProcessor";
                break;
            }
            case 12: 
            case 20: 
            case 28: 
            case 45: 
            case 53: 
            case 56: 
            case 59: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByChanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFileInContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findMethodAtCaret";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClassAtCaret";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtCaret";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showTree";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsAsync";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processTestDiscovery";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createButton";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runAllDiscoveredTests";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getMethodKey";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationProducers";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeAffectedPaths";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getBasePathAsVirtualFile";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAllDiscoveredTests$28";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAllDiscoveredTests$27";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTestDiscovery$24";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$23";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$22";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethods$21";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethodsAsync$19";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showTree$16";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showTree$13";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethods$12";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiscoveredTestsByChanges$8";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTreeProcessor$6";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiscoveredTestsByPsiClass$4";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiscoveredTestsByFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 20: 
            case 28: 
            case 45: 
            case 53: 
            case 56: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

