/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import b.a.lb;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TestClassCollector {
    private static final Logger a;
    private static final long b;

    public static String[] collectClassFQNames(final String packageName, @Nullable Path rootPath, JavaTestConfigurationBase configuration, Function<? super ClassLoader, ? extends Predicate<Class<?>>> predicateProducer) {
        long l2 = b ^ 0x17951A42A4DAL;
        Module module2 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        final ClassLoader classLoader = TestClassCollector.createUsersClassLoader(configuration);
        final HashSet hashSet = new HashSet();
        try {
            String string = packageName.replace('.', '/');
            Enumeration<URL> enumeration = classLoader.getResources(string);
            final Predicate<Class<?>> predicate = predicateProducer.apply(classLoader);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if ("jar".equals(uRL.getProtocol())) continue;
                final Path path = Paths.get(uRL.toURI());
                if (rootPath != null && !path.startsWith(rootPath)) continue;
                final String string2 = path.getFileSystem().getSeparator();
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    private static final long a = lb.a(-6908362465414631453L, -325890572944787096L, MethodHandles.lookup().lookupClass()).a(117850322069835L);

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        long l2 = a ^ 0x5C28A9846372L;
                        ProgressManager.checkCanceled();
                        FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                        File file2 = file.toFile();
                        String string = file2.getName();
                        if (string.endsWith(".class")) {
                            try {
                                Path path2 = path.relativize(file.getParent());
                                String string22 = StringUtil.getQualifiedName((String)path2.toString().replace(string2, "."), (String)FileUtil.getNameWithoutExtension((String)string));
                                String string3 = StringUtil.getQualifiedName((String)packageName, (String)string22);
                                Class<?> clazz = Class.forName(string3, false, classLoader);
                                int n2 = clazz.getModifiers();
                                if (Modifier.isAbstract(n2) || !Modifier.isPublic(n2) || clazz.isMemberClass() && !Modifier.isStatic(n2)) {
                                    return fileVisitResult;
                                }
                                if (predicate.test(clazz)) {
                                    hashSet.add(string3);
                                }
                            }
                            catch (Throwable throwable) {
                                a.info("error processing: " + string + " of " + path.toString(), throwable);
                            }
                        }
                        return fileVisitResult;
                    }
                });
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Throwable throwable) {
            a.error(throwable);
        }
        return ArrayUtil.toStringArray(hashSet);
    }

    public static ClassLoader createUsersClassLoader(JavaTestConfigurationBase configuration) {
        Module module2 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        PathsList pathsList = (PathsList)ReadAction.compute(() -> (module2 == null || configuration.getTestSearchScope() == TestSearchScope.WHOLE_PROJECT ? OrderEnumerator.orderEntries((Project)configuration.getProject()) : OrderEnumerator.orderEntries((Module)module2)).runtimeOnly().recursively().getPathsList());
        for (VirtualFile virtualFile : pathsList.getVirtualFiles()) {
            try {
                arrayList.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                a.info((Throwable)malformedURLException);
            }
        }
        return UrlClassLoader.build().allowLock().useCache().urls(arrayList).get();
    }

    @Nullable
    public static VirtualFile[] getRootPath(Module module2, boolean chooseSingleModule) {
        if (chooseSingleModule) {
            return OrderEnumerator.orderEntries((Module)module2).withoutSdk().withoutLibraries().withoutDepModules().classes().getRoots();
        }
        return null;
    }

    static {
        b = lb.a(854310545409419344L, 682685477151736612L, MethodHandles.lookup().lookupClass()).a(4223246163624L);
        a = Logger.getInstance(TestClassCollector.class);
    }
}

