/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspector;

import b.a.lb;
import com.intellij.designer.inspector.AbstractProperty;
import com.intellij.designer.inspector.DefaultPresentationManager;
import com.intellij.designer.inspector.PresentationManager;
import com.intellij.designer.inspector.Property;
import com.intellij.designer.inspector.PropertyEditor;
import com.intellij.designer.inspector.PropertyRenderer;
import com.intellij.designer.inspector.PropertyValidator;
import com.intellij.designer.inspector.impl.InspectorSpeedSearch;
import com.intellij.designer.inspector.impl.NameRendererAdapter;
import com.intellij.designer.inspector.impl.ValueEditorAdapter;
import com.intellij.designer.inspector.impl.ValueRendererAdapter;
import com.intellij.designer.inspector.impl.actions.CollapseAllAction;
import com.intellij.designer.inspector.impl.actions.ExpandAllAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyInspector
extends TreeTable
implements DataProvider {
    @NonNls
    public static final String INSPECTOR_KEY = "propertyInspector";
    @NonNls
    public static final String STOP_EDITING_ACTION_KEY = "stpEditingOnEnter";
    private PresentationManager d;
    private boolean f = true;
    private boolean b = true;
    private final Map<Class, PropertyRenderer> e = new HashMap<Class, PropertyRenderer>();
    private final Map<Class, PropertyRenderer> a = new HashMap<Class, PropertyRenderer>();
    private final Map<Class, PropertyEditor> c = new HashMap<Class, PropertyEditor>();
    private static final long g = lb.a(-8459069223170368712L, 4651617529291087580L, MethodHandles.lookup().lookupClass()).a(256217687238761L);

    public PropertyInspector() {
        super(PropertyInspector.b());
        this.setRowMargin(0);
        new InspectorSpeedSearch(this);
        this.d = new DefaultPresentationManager<PropertyInspector>(this);
        this.addPropertyChangeListener(new PropertyChangeListener(){
            private static final long a = lb.a(-449569160380141721L, 7666737635284856576L, MethodHandles.lookup().lookupClass()).a(240649821727297L);

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object object;
                long l2 = a ^ 0x3AD496990B2BL;
                if ("tableCellEditor".equals(evt.getPropertyName()) && evt.getNewValue() == null && evt.getOldValue() != null && (object = evt.getOldValue()) instanceof ValueEditorAdapter) {
                    ((ValueEditorAdapter)object).cancelCellEditing();
                    PropertyInspector.this.requestFocusInWindow();
                }
            }
        });
        this.setDragEnabled(false);
    }

    public <P extends Property> void setNameRenderer(Class<P> clazz, @NotNull PropertyRenderer<P> renderer) {
        if (renderer == null) {
            PropertyInspector.a(0);
        }
        this.e.put(clazz, renderer);
    }

    public <P extends Property> PropertyRenderer<P> getNameRenderer(P p2) {
        return PropertyInspector.a(this.e, p2);
    }

    public <P extends Property> void setValueRenderer(Class<P> clazz, @NotNull PropertyRenderer<P> renderer) {
        if (renderer == null) {
            PropertyInspector.a(1);
        }
        this.a.put(clazz, renderer);
    }

    public <P extends Property> PropertyRenderer<P> getValueRenderer(P p2) {
        return PropertyInspector.a(this.a, p2);
    }

    public <P extends Property> void setValueEditor(Class<P> clazz, @NotNull PropertyEditor<P> editor) {
        if (editor == null) {
            PropertyInspector.a(2);
        }
        this.c.put(clazz, editor);
    }

    public <P extends Property> PropertyEditor<P> getValueEditor(@NotNull P p2) {
        if (p2 == null) {
            PropertyInspector.a(3);
        }
        return PropertyInspector.a(this.c, p2);
    }

    private static <P extends Property, T extends PropertyValidator<P>> T a(@NotNull Map<Class, T> map2, @NotNull P p2) {
        Class<?> clazz;
        PropertyValidator propertyValidator;
        if (map2 == null) {
            PropertyInspector.a(4);
        }
        if (p2 == null) {
            PropertyInspector.a(5);
        }
        if ((propertyValidator = (PropertyValidator)map2.get(clazz = p2.getClass())) != null) {
            return (T)propertyValidator;
        }
        for (Class clazz2 : map2.keySet()) {
            PropertyValidator propertyValidator2 = (PropertyValidator)map2.get(clazz2);
            if (!clazz2.isAssignableFrom(clazz) || !propertyValidator2.accepts(p2)) continue;
            map2.put(clazz, propertyValidator2);
            return (T)propertyValidator2;
        }
        return (T)propertyValidator;
    }

    protected String getNameColumnTitle() {
        long l2 = g ^ 0x60E93BDAF986L;
        return "name";
    }

    protected String getValueColumnTitle() {
        long l2 = g ^ 0x1B2082F43531L;
        return "value";
    }

    protected ColumnInfo[] getColumnInfo() {
        return new ColumnInfo[]{new TreeColumnInfo(this.getNameColumnTitle()), new ColumnInfo<Property, Object>(this.getValueColumnTitle()){

            public Object valueOf(Property item) {
                return item;
            }

            public boolean isCellEditable(Property item) {
                PropertyEditor<Property> propertyEditor = PropertyInspector.this.getValueEditor(item);
                return propertyEditor != null && propertyEditor.canEdit(item);
            }
        }};
    }

    protected void setStopEditingOnEnter(boolean b10) {
        this.f = b10;
    }

    protected void setStartEditingOnEnter(boolean b10) {
        this.b = b10;
    }

    public void setRoot(Property root2) {
        int n2 = this.getSelectedRow();
        this.setModel((TreeTableModel)new ListTreeTableModel((TreeNode)root2, this.getColumnInfo()));
        if (this.getRowCount() > n2) {
            this.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    @Nullable
    public Property getRoot() {
        return (Property)this.getTableModel().getRoot();
    }

    public boolean editCellAt(int row, int column, EventObject e10) {
        TableCellEditor tableCellEditor;
        if (!this.isEditing() && (tableCellEditor = this.getCellEditor(row, column)) != null && this.isCellEditable(row, column)) {
            Component component = tableCellEditor.getTableCellEditorComponent((JTable)((Object)this), this.getRowValue(row), this.isRowSelected(row), row, column);
            this.add(component);
        }
        return super.editCellAt(row, column, e10);
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Rectangle getCellRect(@NotNull Property p2) {
        if (p2 == null) {
            PropertyInspector.a(6);
        }
        int n2 = this.getPropertyIndex(p2);
        return this.getCellRect(n2, 0, false);
    }

    protected void processMouseEvent(MouseEvent e10) {
        if (e10.isPopupTrigger()) {
            this.a(e10);
        }
        super.processMouseEvent(e10);
    }

    private void a(MouseEvent mouseEvent) {
        long l2 = g ^ 0x416559D05900L;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup("???", true);
        this.addActions(defaultActionGroup);
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("TodoViewPopup", (ActionGroup)defaultActionGroup);
        actionPopupMenu.getComponent().show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    protected void addActions(DefaultActionGroup group2) {
        long l2 = g ^ 0x4E71C76761D6L;
        group2.add(ActionManager.getInstance().getAction("PropertyInspectorActions.CommonActions"));
    }

    public void setModel(TreeTableModel treeTableModel) {
        TreeTableModel treeTableModel2 = treeTableModel == null ? PropertyInspector.b() : treeTableModel;
        super.setModel(treeTableModel2);
        this.a();
        this.setRootVisible(false);
        if (treeTableModel2 != null && treeTableModel2.getRoot() instanceof Property) {
            this.expandAll();
        }
    }

    private void a() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setDragEnabled(false);
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        TreeTableTree treeTableTree = this.getTree();
        treeTableTree.setShowsRootHandles(false);
        treeTableTree.getSelectionModel().setSelectionMode(1);
        treeTableTree.setCellRenderer((TreeCellRenderer)new NameRendererAdapter(this, treeTableTree.getCellRenderer()));
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel.getColumnCount() == 2) {
            TableColumn tableColumn = tableColumnModel.getColumn(1);
            tableColumn.setCellRenderer(new ValueRendererAdapter(this, this.getDefaultRenderer(Object.class)));
            tableColumn.setCellEditor(new ValueEditorAdapter(this));
        }
    }

    private static TreeTableModel b() {
        long l2 = g ^ 0x48712D3C0FE9L;
        return new ListTreeTableModel((TreeNode)new AbstractProperty<String, String>("dummy", "dummy"){}, ColumnInfo.EMPTY_ARRAY);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        long l2 = g ^ 0x3ECFC82A063FL;
        if (dataId == null) {
            PropertyInspector.a(7);
        }
        if (INSPECTOR_KEY.equals(dataId)) {
            return this;
        }
        return null;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)this.getTree());
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.getTree(), (int)1);
    }

    public void firePropertyAdded(Property added, Property parent, int index) {
        ((AbstractTableModel)this.getModel()).fireTableRowsInserted(index, index);
    }

    public void firePropertyRemoved(Property property, Property parent, int index) {
        ((AbstractTableModel)this.getModel()).fireTableRowsDeleted(index, index);
    }

    @NotNull
    public AnAction getExpandAll() {
        ExpandAllAction expandAllAction = new ExpandAllAction(this);
        if (expandAllAction == null) {
            PropertyInspector.a(8);
        }
        return expandAllAction;
    }

    @NotNull
    public AnAction getCollapseAll() {
        CollapseAllAction collapseAllAction = new CollapseAllAction(this);
        if (collapseAllAction == null) {
            PropertyInspector.a(9);
        }
        return collapseAllAction;
    }

    @Nullable
    public Property getSelectedProperty() {
        int n2 = this.getSelectedRow();
        return this.getRowValue(n2);
    }

    protected Property getRowValue(int row) {
        return (Property)this.getModel().getValueAt(row, 1);
    }

    public int getSelectedPropertyIndex() {
        return this.getSelectedRow();
    }

    protected int getPropertyIndex(@NotNull Property p2) {
        if (p2 == null) {
            PropertyInspector.a(10);
        }
        TableModel tableModel = this.getModel();
        for (int i10 = 0; i10 < tableModel.getRowCount(); ++i10) {
            Object object = tableModel.getValueAt(i10, 1);
            if (object != p2) continue;
            return i10;
        }
        return -1;
    }

    public void setSelectedProperty(@NotNull Property p2) {
        if (p2 == null) {
            PropertyInspector.a(11);
        }
        int n2 = this.getPropertyIndex(p2);
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public PresentationManager getPresentationManager() {
        return this.d;
    }

    public void setPresentationManager(PresentationManager manager) {
        this.d = manager;
    }

    public TreePath getPathForRow(int row) {
        return this.getTree().getPathForRow(row);
    }

    public void processEnter() {
        int n2;
        if (this.f && this.isEditing()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.requestFocusInWindow();
        } else if (this.b && this.isCellEditable(n2 = this.getSelectedRow(), 1)) {
            this.editCellAt(n2, 1, null);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x6A1904E47283L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2valueMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/inspector/PropertyInspector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/inspector/PropertyInspector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandAll";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapseAll";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNameRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setValueRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValueEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueFromMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCellRect";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

