/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspection;

import b.a.lb;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.QuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.RowIcon;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuickFixManager {
    protected DesignerEditorPanel myDesigner;
    protected final JComponent myComponent;
    private final JViewport f;
    private final Alarm a;
    private final Runnable b;
    private LightweightHint e;
    private Rectangle c;
    private static final Border g;
    private static final Border d;
    private static final Icon h;
    private static final long k;

    public AbstractQuickFixManager(@Nullable DesignerEditorPanel designer, JComponent component, JViewport viewPort) {
        long l2 = k ^ 0x36618030C3D4L;
        this.a = new Alarm();
        this.myDesigner = designer;
        this.myComponent = component;
        this.f = viewPort;
        this.b = () -> this.d();
        new VisibilityWatcher(){

            public void visibilityChanged() {
                if (AbstractQuickFixManager.this.myComponent.isShowing()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                } else {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        }.install((Component)component);
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e10) {
                if (!e10.isTemporary()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                }
            }

            @Override
            public void focusLost(FocusEvent e10) {
                if (!e10.isTemporary()) {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        });
        AnAction anAction = new AnAction(){
            private static final long a = lb.a(-6073957468836572265L, -6002857855899985027L, MethodHandles.lookup().lookupClass()).a(255460080676390L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                if (AbstractQuickFixManager.this.myDesigner != null) {
                    AbstractQuickFixManager.this.d();
                    AbstractQuickFixManager.this.a();
                }
            }

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    3.a(1);
                }
                e10.getPresentation().setEnabled(e10.getData(CommonDataKeys.EDITOR) == null);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x5EF5C61DA284L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/designer/inspection/AbstractQuickFixManager$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        anAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), component);
        viewPort.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e10) {
                AbstractQuickFixManager.this.c();
            }
        });
    }

    public void setDesigner(@Nullable DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    public void update() {
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
        } else if (this.e == null || !this.e.isVisible()) {
            this.updateHintVisibility();
        } else {
            Rectangle rectangle = this.getErrorBounds();
            if (!ErrorInfo.haveFixes(this.getErrorInfos()) || rectangle == null || !rectangle.equals(this.c)) {
                this.hideHint();
                this.updateHintVisibility();
            }
        }
    }

    private void d() {
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
            return;
        }
        this.hideHint();
        List<ErrorInfo> list2 = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(list2)) {
            this.hideHint();
            return;
        }
        boolean bl2 = false;
        Object object = list2.iterator();
        while (object.hasNext()) {
            ErrorInfo errorInfo = object.next();
            if (errorInfo.getLevel() != HighlightDisplayLevel.ERROR) continue;
            bl2 = true;
            break;
        }
        if ((object = this.getErrorBounds()) == null) {
            return;
        }
        this.e = new LightweightHint((JComponent)new InspectionHint(this, bl2 ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb));
        this.c = object;
        this.e.show(this.myComponent, ((Rectangle)object).x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, ((Rectangle)object).y, this.myComponent, new HintHint((Component)this.myComponent, ((Rectangle)object).getLocation()));
    }

    private void a() {
        if (this.e == null || !this.e.isVisible()) {
            return;
        }
        List<ErrorInfo> list2 = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(list2)) {
            return;
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new FirstStep(list2));
        listPopup.showUnderneathOf((Component)this.e.getComponent());
    }

    public final void hideHint() {
        this.a.cancelAllRequests();
        if (this.e != null && this.e.isVisible()) {
            this.e.hide();
            this.e = null;
            this.myComponent.paintImmediately(this.myComponent.getVisibleRect());
        }
    }

    protected final void updateHintVisibility() {
        this.a.cancelAllRequests();
        this.a.addRequest(this.b, 500);
    }

    private void c() {
        Rectangle rectangle;
        if (this.e != null && this.e.isVisible() && (rectangle = this.getErrorBounds()) != null) {
            this.c = rectangle;
            Rectangle rectangle2 = new Rectangle(rectangle.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, rectangle.y, AllIcons.Actions.IntentionBulb.getIconWidth() + 4, AllIcons.Actions.IntentionBulb.getIconHeight() + 4);
            if (this.getHintClipRect().contains(rectangle2)) {
                this.e.updateLocation(rectangle2.x, rectangle2.y);
            } else {
                this.e.hide();
            }
        }
    }

    protected Rectangle getHintClipRect() {
        return this.f.getViewRect();
    }

    @NotNull
    protected abstract List<ErrorInfo> getErrorInfos();

    @Nullable
    protected abstract Rectangle getErrorBounds();

    private Runnable c(QuickFix quickFix) {
        return () -> {
            long l2 = k ^ 0x12B3B0BD7BAL;
            this.myDesigner.getToolProvider().executeWithReparse((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runWriteAction((Runnable)quickFix)), "Run '" + quickFix.getName() + "' QuickFix");
        };
    }

    static {
        k = lb.a(3406931652167119123L, 6562426712432786925L, MethodHandles.lookup().lookupClass()).a(100018779957643L);
        g = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        d = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.orange, 2), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        h = EmptyIcon.create((Icon)AllIcons.General.ArrowDown);
    }

    private class InspectionHint
    extends JLabel {
        private final RowIcon b;
        private final RowIcon a;
        final /* synthetic */ AbstractQuickFixManager this$0;
        private static final long c = lb.a(-4569871112089136888L, -4704102629104768310L, MethodHandles.lookup().lookupClass()).a(166260333369618L);

        private InspectionHint(final AbstractQuickFixManager abstractQuickFixManager, Icon icon) {
            long l2 = c ^ 0x70AF6BA8CFACL;
            this.this$0 = abstractQuickFixManager;
            this.setOpaque(false);
            this.setBorder(g);
            this.a = new RowIcon(2);
            this.a.setIcon(icon, 0);
            this.a.setIcon(AllIcons.General.ArrowDown, 1);
            this.b = new RowIcon(2);
            this.b.setIcon(icon, 0);
            this.b.setIcon(h, 1);
            this.setIcon((Icon)this.b);
            String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (string.length() > 0) {
                this.setToolTipText(DesignerBundle.message("tooltip.press.accelerator", string));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e10) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.a);
                    InspectionHint.this.setBorder(d);
                }

                @Override
                public void mouseExited(MouseEvent e10) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.b);
                    InspectionHint.this.setBorder(g);
                }
            });
            new ClickListener(){
                private static final long a = lb.a(-1153982773912239489L, -6964954100802838834L, MethodHandles.lookup().lookupClass()).a(107219426520741L);

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    if (event == null) {
                        2.a(0);
                    }
                    InspectionHint.this.this$0.a();
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x2726E020E87AL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/designer/inspection/AbstractQuickFixManager$InspectionHint$2", "onClick"));
                }
            }.installOn((Component)this);
        }
    }

    private class SecondStep
    extends BaseListPopupStep<QuickFix> {
        private static final long a = lb.a(-8147826627244516584L, 8636291086315303448L, MethodHandles.lookup().lookupClass()).a(156096606691822L);

        SecondStep(List<? extends QuickFix> fixList) {
            super(null, fixList);
        }

        public Icon getIconFor(QuickFix value) {
            return value.getIcon();
        }

        @NotNull
        public String getTextFor(QuickFix value) {
            String string = value.getName();
            if (string == null) {
                SecondStep.a(0);
            }
            return string;
        }

        public PopupStep onChosen(QuickFix value, boolean finalChoice) {
            return this.doFinalStep(AbstractQuickFixManager.this.c(value));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x463342614BBFL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/inspection/AbstractQuickFixManager$SecondStep", "getTextFor"));
        }
    }

    private class FirstStep
    extends BaseListPopupStep<ErrorInfo> {
        private static final long a = lb.a(4560895983101982461L, -3877583008041747082L, MethodHandles.lookup().lookupClass()).a(205878358143434L);

        FirstStep(List<ErrorInfo> errorInfos) {
            super(null, errorInfos);
        }

        public Icon getIconFor(ErrorInfo value) {
            return AllIcons.Actions.RealIntentionBulb;
        }

        @NotNull
        public String getTextFor(ErrorInfo value) {
            String string = value.getName();
            if (string == null) {
                FirstStep.a(0);
            }
            return string;
        }

        public PopupStep onChosen(ErrorInfo value, boolean finalChoice) {
            List list2 = value.getQuickFixes();
            if (finalChoice) {
                return this.doFinalStep(AbstractQuickFixManager.this.c((QuickFix)list2.get(0)));
            }
            return new SecondStep(list2);
        }

        public boolean hasSubstep(ErrorInfo selectedValue) {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x3BD28BB6C985L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/inspection/AbstractQuickFixManager$FirstStep", "getTextFor"));
        }
    }
}

