/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import b.a.lb;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SelectionTool
extends InputTool {
    private InputTool f;
    private static final long g = lb.a(-4426826957327558649L, 6875235953016813492L, MethodHandles.lookup().lookupClass()).a(279153965783442L);

    @Override
    public void deactivate() {
        this.a();
        super.deactivate();
    }

    @Override
    public void refreshCursor() {
        if (this.f == null) {
            super.refreshCursor();
        }
    }

    @Override
    protected void handleButtonDown(int button) {
        if (this.myState == 1) {
            Object object;
            this.myState = 2;
            this.a();
            if (this.handleTracker()) {
                return;
            }
            if (!this.myArea.isTree() && (object = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY)) != null) {
                this.a((InputTool)object);
                if (object instanceof ResizeTracker) {
                    this.myArea.showSelection(false);
                }
                return;
            }
            object = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, null);
            if (object == null || ((RadComponent)((Object)object)).isBackground()) {
                if (!this.myArea.isTree()) {
                    MarqueeTracker marqueeTracker = new MarqueeTracker();
                    marqueeTracker.setSelectBackground(object != null && ((RadComponent)((Object)object)).isBackground());
                    this.a(marqueeTracker);
                }
            } else {
                Point point = ((RadComponent)((Object)object)).convertPoint(this.myArea.getNativeComponent(), this.myCurrentScreenX, this.myCurrentScreenY);
                this.a(((RadComponent)((Object)object)).getDragTracker(point, this.myInputEvent, this.myArea.isTree()));
            }
        }
    }

    protected boolean handleTracker() {
        if (!this.myArea.isTree() && this.myInputEvent.isAltDown()) {
            this.a(new MarqueeTracker());
            return true;
        }
        return false;
    }

    @Override
    protected void handleButtonUp(int button) {
        this.myState = 1;
        this.a(null);
        this.handleMove();
    }

    @Override
    protected void handlePopup() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu(this.myArea.getPopupPlace(), this.myArea.getPopupActions());
        MouseEvent mouseEvent = (MouseEvent)this.myInputEvent;
        actionPopupMenu.getComponent().show(this.myArea.getNativeComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    protected void handleDoubleClick(int button) {
        if (button == 1 && this.myToolProvider != null && !this.myArea.isTree()) {
            this.myToolProvider.startInplaceEditing(null);
        }
    }

    @Override
    protected void handleMove() {
        long l2 = g ^ 0x681C9F3B5B45L;
        if (this.myState == 1) {
            InputTool inputTool = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY);
            if (inputTool == null) {
                this.refreshCursor();
                if (ApplicationManager.getApplication().isInternal()) {
                    this.myArea.setDescription("Location (" + this.myCurrentScreenX + " x " + this.myCurrentScreenY + ")");
                } else {
                    this.myArea.setDescription(null);
                }
            } else {
                if (this.myInputEvent instanceof MouseEvent) {
                    try {
                        inputTool.mouseMove((MouseEvent)this.myInputEvent, this.myArea);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.myArea.setCursor(inputTool.getDefaultCursor());
                this.myArea.setDescription(inputTool.getDescription());
            }
        }
    }

    private void a(@Nullable InputTool inputTool) {
        if (this.f != inputTool) {
            this.a();
            this.f = inputTool;
            this.refreshCursor();
            if (this.f != null) {
                this.myToolProvider.hideInspections();
                this.f.setToolProvider(this.myToolProvider);
                this.f.setArea(this.myArea);
                this.f.myModifiers = this.myModifiers;
                this.f.activate();
            }
        }
    }

    private void a() {
        if (this.f != null) {
            this.f.deactivate();
            this.f = null;
            if (this.myArea != null) {
                this.myArea.showSelection(true);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, EditableArea area) throws Exception {
        super.mouseDown(event, area);
        if (this.f != null) {
            this.f.mouseDown(event, area);
        }
    }

    @Override
    public void mouseUp(MouseEvent event, EditableArea area) throws Exception {
        if (this.f != null) {
            this.f.mouseUp(event, area);
        }
        super.mouseUp(event, area);
    }

    @Override
    public void mouseMove(MouseEvent event, EditableArea area) throws Exception {
        if (this.f != null) {
            this.f.mouseMove(event, area);
        }
        super.mouseMove(event, area);
    }

    @Override
    public void mouseDrag(MouseEvent event, EditableArea area) throws Exception {
        if (this.f != null) {
            this.f.mouseDrag(event, area);
        }
        super.mouseDrag(event, area);
    }

    @Override
    public void mousePopup(MouseEvent event, EditableArea area) throws Exception {
        if (this.f != null) {
            this.f.mousePopup(event, area);
        }
        super.mousePopup(event, area);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event, EditableArea area) throws Exception {
        super.mouseDoubleClick(event, area);
        if (this.f != null) {
            this.f.mouseDoubleClick(event, area);
        }
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        RadComponent radComponent;
        List<RadComponent> list2;
        super.keyTyped(event, area);
        if (this.f != null) {
            this.f.keyPressed(event, area);
        } else if (event.getKeyCode() == 27 && !(list2 = area.getSelection()).isEmpty() && (radComponent = list2.get(0).getParent()) != null) {
            area.select(radComponent);
        }
    }

    @Override
    public void keyTyped(KeyEvent event, EditableArea area) throws Exception {
        super.keyTyped(event, area);
        if (this.f != null) {
            this.f.keyTyped(event, area);
        } else if (this.myToolProvider != null && !area.isTree()) {
            this.handleKeyTyped(event);
        }
    }

    protected void handleKeyTyped(KeyEvent event) {
        char c10 = event.getKeyChar();
        switch (c10) {
            case '+': 
            case '-': 
            case '0': 
            case '1': {
                ZoomType zoomType = c10 == '-' ? ZoomType.OUT : (c10 == '+' ? ZoomType.IN : (c10 == '0' ? ZoomType.FIT : ZoomType.ACTUAL));
                if (!this.myToolProvider.isZoomSupported()) break;
                this.myToolProvider.zoom(zoomType);
                event.consume();
                return;
            }
        }
        if (Character.isLetterOrDigit(c10) && (event.getModifiers() & 0xE) == 0) {
            this.myToolProvider.startInplaceEditing(new InplaceContext(c10));
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        super.keyReleased(event, area);
        if (this.f != null) {
            this.f.keyReleased(event, area);
        }
    }
}

