/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.feedbacks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class LineFeedback
extends JComponent {
    protected final Color myColor;
    private final int a;
    protected boolean myHorizontal;

    public LineFeedback(Color color, int line, boolean horizontal) {
        this.myColor = color;
        this.a = line;
        this.myHorizontal = horizontal;
    }

    public void size(int width2, int height) {
        if (this.myHorizontal) {
            this.setSize(width2, this.a);
        } else {
            this.setSize(this.a, height);
        }
    }

    public void horizontal(int x2, int y2, int width2) {
        this.myHorizontal = true;
        this.setBounds(x2, y2, width2, this.a);
        this.setVisible(true);
    }

    public void vertical(int x2, int y2, int height) {
        this.myHorizontal = false;
        this.setBounds(x2, y2, this.a, height);
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g10) {
        super.paintComponent(g10);
        g10.setColor(this.myColor);
        this.paintLines(g10);
    }

    protected void paintLines(Graphics g10) {
        Dimension dimension = this.getSize();
        if (this.myHorizontal) {
            this.paintHorizontal(g10, dimension);
        } else {
            this.paintVertical(g10, dimension);
        }
    }

    protected void paintHorizontal(Graphics g10, Dimension size) {
        for (int i10 = 0; i10 < this.a; ++i10) {
            g10.drawLine(0, i10, size.width, i10);
        }
    }

    protected void paintVertical(Graphics g10, Dimension size) {
        for (int i10 = 0; i10 < this.a; ++i10) {
            g10.drawLine(i10, 0, i10, size.height);
        }
    }
}

