/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.AbstractEditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineInsertFeedback;
import com.intellij.designer.designSurface.feedbacks.RectangleFeedback;
import com.intellij.designer.model.RadComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlowBaseOperation
extends AbstractEditOperation {
    protected final boolean myHorizontal;
    protected RectangleFeedback myFirstInsertFeedback;
    protected LineInsertFeedback myInsertFeedback;
    protected Rectangle myBounds;
    protected RadComponent myChildTarget;
    protected boolean myInsertBefore;

    public AbstractFlowBaseOperation(RadComponent container, OperationContext context, boolean horizontal) {
        super(container, context);
        this.myHorizontal = horizontal;
    }

    protected void createFeedback() {
        if (this.myFirstInsertFeedback == null) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            this.myBounds = this.myContainer.getBounds(feedbackLayer);
            this.createFirstInsertFeedback();
            this.createInsertFeedback();
            if (this.getChildren().isEmpty()) {
                feedbackLayer.add(this.myFirstInsertFeedback);
            } else {
                feedbackLayer.add(this.myInsertFeedback);
            }
            feedbackLayer.repaint();
        }
    }

    protected List<RadComponent> getChildren() {
        return this.myContainer.getChildren();
    }

    protected abstract void createInsertFeedback();

    protected abstract void createFirstInsertFeedback();

    @Override
    public void showFeedback() {
        this.createFeedback();
        List<RadComponent> list2 = this.getChildren();
        if (!list2.isEmpty()) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            Point point = this.myContext.getLocation();
            this.myChildTarget = null;
            if (this.myHorizontal) {
                this.handleHorizontal(list2, feedbackLayer, point);
            } else {
                this.handleVertical(list2, feedbackLayer, point);
            }
            if (this.myChildTarget == null) {
                this.myChildTarget = this.a();
            }
            Rectangle rectangle = this.getBounds(this.myChildTarget, feedbackLayer);
            this.myInsertBefore = this.myHorizontal ? (double)point.x < rectangle.getCenterX() : (double)point.y < rectangle.getCenterY();
            this.setInsertFeedbackBounds(rectangle);
            feedbackLayer.repaint();
        }
    }

    protected void handleHorizontal(List<RadComponent> children2, FeedbackLayer layer, Point location) {
        for (RadComponent radComponent : children2) {
            Rectangle rectangle = this.getBounds(radComponent, layer);
            if (rectangle.x > location.x || !((double)location.x <= rectangle.getMaxX())) continue;
            this.myChildTarget = radComponent;
            break;
        }
    }

    protected void handleVertical(List<RadComponent> children2, FeedbackLayer layer, Point location) {
        for (RadComponent radComponent : children2) {
            Rectangle rectangle = this.getBounds(radComponent, layer);
            if (rectangle.y > location.y || !((double)location.y <= rectangle.getMaxY())) continue;
            this.myChildTarget = radComponent;
            break;
        }
    }

    protected void setInsertFeedbackBounds(Rectangle targetBounds) {
        if (this.myHorizontal) {
            if (this.myInsertBefore) {
                this.myInsertFeedback.setLocation(targetBounds.x, this.myBounds.y);
            } else {
                this.myInsertFeedback.setLocation(targetBounds.x + targetBounds.width, this.myBounds.y);
            }
        } else if (this.myInsertBefore) {
            this.myInsertFeedback.setLocation(this.myBounds.x, targetBounds.y);
        } else {
            this.myInsertFeedback.setLocation(this.myBounds.x, targetBounds.y + targetBounds.height);
        }
    }

    protected Rectangle getBounds(RadComponent component, FeedbackLayer layer) {
        return component.getBounds(layer);
    }

    private RadComponent a() {
        Point point = this.myContext.getLocation();
        List<RadComponent> list2 = this.getChildren();
        RadComponent radComponent = list2.get(list2.size() - 1);
        Rectangle rectangle = radComponent.getBounds(this.myContext.getArea().getFeedbackLayer());
        if (this.myHorizontal) {
            if ((double)point.x >= rectangle.getMaxX()) {
                return radComponent;
            }
            return list2.get(0);
        }
        if ((double)point.y >= rectangle.getMaxY()) {
            return radComponent;
        }
        return list2.get(0);
    }

    @Override
    public void eraseFeedback() {
        if (this.myFirstInsertFeedback != null) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            feedbackLayer.remove(this.myFirstInsertFeedback);
            feedbackLayer.remove(this.myInsertFeedback);
            feedbackLayer.repaint();
            this.myFirstInsertFeedback = null;
            this.myInsertFeedback = null;
        }
    }

    @Override
    public boolean canExecute() {
        if (this.myContext.isMove()) {
            if (this.myComponents.contains((Object)this.myChildTarget)) {
                return false;
            }
            List<RadComponent> list2 = this.getChildren();
            int n2 = list2.indexOf((Object)this.myChildTarget) + (this.myInsertBefore ? -1 : 1);
            if (0 <= n2 && n2 < list2.size()) {
                return !this.myComponents.contains((Object)list2.get(n2));
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        if (this.myChildTarget == null || this.myInsertBefore) {
            this.execute(this.myChildTarget);
        } else {
            List<RadComponent> list2 = this.getChildren();
            int n2 = list2.indexOf((Object)this.myChildTarget) + 1;
            if (n2 < list2.size()) {
                this.execute(list2.get(n2));
            } else {
                this.execute(null);
            }
        }
    }

    protected abstract void execute(@Nullable RadComponent var1) throws Exception;
}

