/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.designSurface.AbstractEditOperation;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.util.ArrayUtil;
import java.awt.Point;
import org.jetbrains.annotations.Nullable;

public abstract class TreeEditOperation
extends AbstractEditOperation {
    protected RadComponent myTarget;
    protected boolean myInsertBefore;

    public TreeEditOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    public static boolean isTarget(RadComponent container, OperationContext context) {
        Point point = context.getLocation();
        RadComponent radComponent = context.getArea().findTarget(point.x, point.y, null);
        if (radComponent == container) {
            FeedbackTreeLayer feedbackTreeLayer = context.getArea().getFeedbackTreeLayer();
            return !feedbackTreeLayer.isBeforeLocation(radComponent, point.x, point.y) && !feedbackTreeLayer.isAfterLocation(radComponent, point.x, point.y);
        }
        return true;
    }

    protected Object[] getChildren() {
        return this.myContainer.getTreeChildren();
    }

    @Override
    public void showFeedback() {
        Point point = this.myContext.getLocation();
        FeedbackTreeLayer feedbackTreeLayer = this.myContext.getArea().getFeedbackTreeLayer();
        this.myTarget = this.myContext.getArea().findTarget(point.x, point.y, null);
        if (this.myContainer == this.myTarget) {
            feedbackTreeLayer.mark(this.myTarget, 2);
        } else if (this.myTarget != null && this.isChildren(this.myTarget)) {
            this.myInsertBefore = feedbackTreeLayer.isBeforeLocation(this.myTarget, point.x, point.y);
            feedbackTreeLayer.mark(this.myTarget, this.myInsertBefore ? 0 : 1);
        } else {
            this.myTarget = null;
            this.eraseFeedback();
        }
    }

    protected final boolean isChildren(RadComponent component) {
        return ArrayUtil.indexOf((Object[])this.getChildren(), (Object)((Object)component)) != -1;
    }

    @Override
    public void eraseFeedback() {
        this.myContext.getArea().getFeedbackTreeLayer().unmark();
    }

    @Override
    public boolean canExecute() {
        if (this.myTarget == null) {
            return false;
        }
        if (this.myContext.isMove() && this.myTarget != this.myContainer) {
            if (this.myComponents.contains((Object)this.myTarget)) {
                return false;
            }
            Object[] objectArray = this.getChildren();
            int n2 = ArrayUtil.indexOf((Object[])objectArray, (Object)((Object)this.myTarget)) + (this.myInsertBefore ? -1 : 1);
            if (0 <= n2 && n2 < objectArray.length) {
                return !this.myComponents.contains(objectArray[n2]);
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        if (this.myTarget == this.myContainer) {
            this.execute(null);
        } else if (this.myInsertBefore) {
            this.execute(this.myTarget);
        } else {
            Object[] objectArray = this.getChildren();
            int n2 = ArrayUtil.indexOf((Object[])objectArray, (Object)((Object)this.myTarget)) + 1;
            if (n2 < objectArray.length) {
                this.execute((RadComponent)((Object)objectArray[n2]));
            } else {
                this.execute(null);
            }
        }
    }

    protected abstract void execute(@Nullable RadComponent var1) throws Exception;
}

