/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import b.a.lb;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.actions.SelectAllAction;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.componentTree.QuickFixManager;
import com.intellij.designer.componentTree.TreeNodeDescriptor;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentTree
extends Tree
implements DataProvider {
    private final StartInplaceEditing b;
    private QuickFixManager a;
    private DesignerEditorPanel f;
    private EditableArea d;
    private RadComponent c;
    private int e;
    private static final long g = lb.a(8029865082462966994L, -7872138331626761916L, MethodHandles.lookup().lookupClass()).a(160705380087608L);

    public ComponentTree() {
        this.newModel();
        this.setScrollsOnExpand(true);
        this.a();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.b = DesignerActionPanel.createInplaceEditingAction((JComponent)((Object)this));
    }

    public void setUI(TreeUI ui) {
        long l2 = g ^ 0x75029D877EEBL;
        super.setUI(ui);
        this.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                if (ComponentTree.this.f != null) {
                    ((SelectAllAction)ComponentTree.this.f.getActionPanel().createSelectAllAction(ComponentTree.this.f.getSurfaceArea())).perform();
                }
            }
        });
    }

    public void newModel() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    public void initQuickFixManager(JViewport viewPort) {
        this.a = new QuickFixManager((JComponent)((Object)this), viewPort);
    }

    public void updateInspections() {
        this.a.update();
    }

    public void setDesignerPanel(@Nullable DesignerEditorPanel designer) {
        this.f = designer;
        this.c = null;
        this.d = null;
        this.b.setDesignerPanel(designer);
        this.a.setDesigner(designer);
    }

    public void setArea(@Nullable EditableArea area) {
        this.d = area;
        this.a.setEditableArea(area);
    }

    public void mark(RadComponent component, int feedback) {
        this.c = component;
        this.e = feedback;
        this.repaint();
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ComponentTree.a(0);
        }
        if (EditableArea.DATA_KEY.is(dataId)) {
            return this.d;
        }
        if (this.f != null) {
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.f.getEditor();
            }
            return this.f.getActionPanel().getData(dataId);
        }
        return null;
    }

    @Nullable
    public RadComponent extractComponent(Object value) {
        TreeNodeDescriptor treeNodeDescriptor;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (this.f != null && object2 instanceof TreeNodeDescriptor && (object = (treeNodeDescriptor = (TreeNodeDescriptor)((Object)object2)).getElement()) instanceof RadComponent) {
            return (RadComponent)((Object)object);
        }
        return null;
    }

    public int getEdgeSize() {
        return Math.max(5, ((JComponent)((Object)this.getCellRenderer())).getPreferredSize().height / 2 - 3);
    }

    public String getToolTipText(MouseEvent event) {
        List<ErrorInfo> list2;
        RadComponent radComponent;
        TreePath treePath = this.getPathForLocation(event.getX(), event.getY());
        if (treePath != null && (radComponent = this.extractComponent(treePath.getLastPathComponent())) != null && !(list2 = RadComponent.getError(radComponent)).isEmpty()) {
            return list2.get(0).getName();
        }
        return super.getToolTipText(event);
    }

    @Nullable
    private static HighlightDisplayLevel a(Project project2, RadComponent radComponent) {
        HighlightDisplayLevel highlightDisplayLevel = null;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar((Project)project2);
        for (ErrorInfo errorInfo : RadComponent.getError(radComponent)) {
            if (highlightDisplayLevel != null && severityRegistrar.compare(errorInfo.getLevel().getSeverity(), highlightDisplayLevel.getSeverity()) <= 0) continue;
            highlightDisplayLevel = errorInfo.getLevel();
        }
        return highlightDisplayLevel;
    }

    private AttributeWrapper a(RadComponent radComponent) {
        AttributeWrapper attributeWrapper = AttributeWrapper.DEFAULT;
        HighlightDisplayLevel highlightDisplayLevel = ComponentTree.a(this.f.getProject(), radComponent);
        if (highlightDisplayLevel != null) {
            TextAttributesKey textAttributesKey = SeverityRegistrar.getSeverityRegistrar((Project)this.f.getProject()).getHighlightInfoTypeBySeverity(highlightDisplayLevel.getSeverity()).getAttributesKey();
            final TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributesKey);
            attributeWrapper = new AttributeWrapper(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SimpleTextAttributes getAttribute(SimpleTextAttributes attributes) {
                    Color color = textAttributes.getBackgroundColor();
                    try {
                        textAttributes.setBackgroundColor(null);
                        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)TextAttributes.merge((TextAttributes)attributes.toTextAttributes(), (TextAttributes)textAttributes));
                        return simpleTextAttributes;
                    }
                    finally {
                        textAttributes.setBackgroundColor(color);
                    }
                }
            };
        }
        return attributeWrapper;
    }

    private void a() {
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){
            private static final long a = lb.a(-7101943507364215777L, -4851382921525909170L, MethodHandles.lookup().lookupClass()).a(262993271064133L);

            public void customizeCellRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                long l2 = a ^ 0x5EF62C4457E2L;
                try {
                    RadComponent radComponent = ComponentTree.this.extractComponent(value);
                    if (radComponent != null) {
                        ComponentTree.this.f.getTreeDecorator().decorate(radComponent, (SimpleColoredComponent)this, ComponentTree.this.a(radComponent), true);
                        if (ComponentTree.this.c == radComponent) {
                            if (ComponentTree.this.e == 2) {
                                this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
                            } else {
                                this.setBorder(new InsertBorder(ComponentTree.this.e));
                            }
                        } else {
                            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (ComponentTree.this.f == null) {
                        throw runtimeException;
                    }
                    ComponentTree.this.f.showError("Tree paint operation", runtimeException);
                }
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = g ^ 0x47DFC3564EA0L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/designer/componentTree/ComponentTree", "getData"));
    }

    private static class InsertBorder
    extends LineBorder {
        private final int a;

        InsertBorder(int mode) {
            super(Color.BLACK, 2);
            this.a = mode;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.a == 0 ? this.thickness : 0;
            insets.left = insets.right = this.thickness;
            insets.bottom = this.a == 1 ? this.thickness : 0;
            return insets;
        }

        @Override
        public void paintBorder(Component c10, Graphics g10, int x2, int y2, int width2, int height) {
            Color color = g10.getColor();
            g10.setColor(this.getLineColor());
            if (this.a == 0) {
                g10.fillRect(x2, y2, width2, this.thickness);
                g10.fillRect(x2, y2, this.thickness, 2 * this.thickness);
                g10.fillRect(x2 + width2 - this.thickness, y2, this.thickness, 2 * this.thickness);
            } else {
                g10.fillRect(x2, y2 + height - this.thickness, width2, this.thickness);
                g10.fillRect(x2, y2 + height - 2 * this.thickness, this.thickness, 2 * this.thickness);
                g10.fillRect(x2 + width2 - this.thickness, y2 + height - 2 * this.thickness, this.thickness, 2 * this.thickness);
            }
            g10.setColor(color);
        }
    }
}

