/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger e;
    private static final long f;

    ImageObjectRenderer(NodeRendererSettings rendererSettings) {
        long l2 = f ^ 0x6B6F96F400E9L;
        super(rendererSettings, "Image", null, null);
        this.setClassName("java.awt.Image");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        long l2 = f ^ 0x302561E54AB9L;
        return new IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext){
            private static final long c = lb.a(8790286513730942476L, 8383492569607930904L, MethodHandles.lookup().lookupClass()).a(153643876384161L);

            @Override
            protected Icon getData() {
                long l2 = c ^ 0x78E32CAE4764L;
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptor.getValue(), "imageToBytes");
            }
        };
    }

    static JComponent createIconViewer(@Nullable Icon icon) {
        long l2 = f ^ 0x43B937E13937L;
        if (icon == null) {
            return new JLabel("No data", 0);
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n2, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)bufferedImage);
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value obj, String methodName) {
        long l2 = f ^ 0x4E00CF63E714L;
        try {
            Value value = ImageObjectRenderer.a(evaluationContext, obj, methodName);
            byte[] byArray = ImageObjectRenderer.a(value);
            if (byArray != null) {
                return new ImageIcon(byArray);
            }
        }
        catch (Exception exception) {
            e.info("Exception while getting image data", (Throwable)exception);
        }
        return null;
    }

    private static Value a(EvaluationContext evaluationContext, Value value, String string) throws EvaluateException {
        List<Method> list2;
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
        ClassType classType = ClassLoadingUtils.getHelperClass(ImageSerializer.class, evaluationContext2);
        if (classType != null && !(list2 = classType.methodsByName(string)).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext2, classType, list2.get(0), Collections.singletonList(value));
        }
        return null;
    }

    private static byte[] a(Value value) {
        if (value instanceof ArrayReference) {
            List<Value> list2 = ((ArrayReference)value).getValues();
            byte[] byArray = new byte[list2.size()];
            int n2 = 0;
            for (Value value2 : list2) {
                if (value2 instanceof ByteValue) {
                    byArray[n2++] = ((ByteValue)value2).value();
                    continue;
                }
                return null;
            }
            return byArray;
        }
        return null;
    }

    static {
        f = lb.a(-8081562239234165142L, 1002933032365297235L, MethodHandles.lookup().lookupClass()).a(57176877918168L);
        e = Logger.getInstance(ImageObjectRenderer.class);
    }

    static abstract class IconPopupEvaluator
    extends CustomPopupFullValueEvaluator<Icon> {
        private static final long d = lb.a(-6087902254049530295L, -8271078374593450097L, MethodHandles.lookup().lookupClass()).a(122664573943315L);

        IconPopupEvaluator(@NotNull String linkText, @NotNull EvaluationContextImpl evaluationContext) {
            if (linkText == null) {
                IconPopupEvaluator.c(0);
            }
            if (evaluationContext == null) {
                IconPopupEvaluator.c(1);
            }
            super(linkText, evaluationContext);
        }

        @Override
        protected JComponent createComponent(Icon data) {
            return ImageObjectRenderer.createIconViewer(data);
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            long l2 = d ^ 0x774C9BAF3871L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluationContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/tree/render/ImageObjectRenderer$IconPopupEvaluator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

