/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HexRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "HexRenderer";
    private static final Logger b;
    private static final long c;

    public HexRenderer() {
        long l2 = c ^ 0x4A3CD80662F7L;
        super("unnamed", false);
    }

    @Override
    public String getUniqueId() {
        long l2 = c ^ 0x37C82B04B6C5L;
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        long l2 = c ^ 0xDCB56E4A1CEL;
        return "Hex";
    }

    @Override
    public void setName(String name2) {
    }

    @Override
    public HexRenderer clone() {
        return (HexRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        long l2 = c ^ 0x14E9423283DEL;
        Value value = valueDescriptor.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (value == null) {
            return "null";
        }
        if (value instanceof CharValue) {
            PrimitiveRenderer.appendCharValue((CharValue)value, stringBuilder);
            stringBuilder.append(' ');
            HexRenderer.appendHexValue((PrimitiveValue)value, stringBuilder);
            return stringBuilder.toString();
        }
        HexRenderer.appendHexValue((PrimitiveValue)value, stringBuilder);
        return stringBuilder.toString();
    }

    static void appendHexValue(@NotNull PrimitiveValue value, StringBuilder buf) {
        long l2 = c ^ 0x6DBFB91E1D3CL;
        if (value == null) {
            HexRenderer.b(0);
        }
        if (value instanceof CharValue) {
            long l3 = value.longValue();
            buf.append("0x").append(Long.toHexString(l3).toUpperCase());
        } else if (value instanceof ByteValue) {
            String string = Integer.toHexString(value.byteValue()).toUpperCase();
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            buf.append("0x").append(string);
        } else if (value instanceof ShortValue) {
            String string = Integer.toHexString(value.shortValue()).toUpperCase();
            if (string.length() > 4) {
                string = string.substring(string.length() - 4);
            }
            buf.append("0x").append(string);
        } else if (value instanceof IntegerValue) {
            buf.append("0x").append(Integer.toHexString(value.intValue()).toUpperCase());
        } else if (value instanceof LongValue) {
            buf.append("0x").append(Long.toHexString(value.longValue()).toUpperCase());
        } else {
            b.assertTrue(false);
        }
    }

    @Override
    public boolean isApplicable(Type t2) {
        if (t2 == null) {
            return false;
        }
        return t2 instanceof CharType || t2 instanceof ByteType || t2 instanceof ShortType || t2 instanceof IntegerType || t2 instanceof LongType;
    }

    static {
        c = lb.a(-109827965264218105L, 6717248004791385881L, MethodHandles.lookup().lookupClass()).a(244114116255357L);
        long l2 = c ^ 0x686E5BF1EF80L;
        b = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.HexRenderer");
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = c ^ 0x60FBB701773FL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/ui/tree/render/HexRenderer", "appendHexValue"));
    }
}

