/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;

public class BinaryRenderer
extends NodeRendererImpl {
    private static final Logger b;
    private static final long c;

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) {
        int n2;
        long l2 = c ^ 0x5EC692769A39L;
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("0b");
        int n3 = stringBuilder.length();
        String string = "";
        if (value instanceof ByteValue) {
            string = Integer.toBinaryString(0xFF & ((ByteValue)value).byteValue());
        } else if (value instanceof ShortValue) {
            string = Integer.toBinaryString(0xFFFF & ((ShortValue)value).shortValue());
        } else if (value instanceof IntegerValue) {
            string = Integer.toBinaryString(((PrimitiveValue)value).intValue());
        } else if (value instanceof LongValue) {
            string = Long.toBinaryString(((LongValue)value).longValue());
        } else {
            b.error("Unsupported value " + value);
        }
        int n4 = string.length() % 8;
        if (n4 != 0) {
            for (n2 = 0; n2 < 8 - n4; ++n2) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(string);
        for (n2 = stringBuilder.length() - 8; n2 > n3; n2 -= 8) {
            stringBuilder.insert(n2, '_');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        long l2 = c ^ 0x47E486A0B829L;
        return "Binary";
    }

    @Override
    public String getUniqueId() {
        long l2 = c ^ 0x7DE7FB40AF22L;
        return "BinaryRenderer";
    }

    @Override
    public boolean isApplicable(Type t2) {
        if (t2 == null) {
            return false;
        }
        return t2 instanceof ByteType || t2 instanceof ShortType || t2 instanceof IntegerType || t2 instanceof LongType;
    }

    static {
        c = lb.a(6679383853900079775L, -597582592940173893L, MethodHandles.lookup().lookupClass()).a(208441174468218L);
        b = Logger.getInstance(BinaryRenderer.class);
    }
}

