/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import b.a.lb;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeExpression {
    private static final Logger a;
    public static final Key<Set<String>> ADDITIONAL_IMPORTS_KEY;
    private static final long b;

    private static boolean a(PsiMethod psiMethod, PsiMethod psiMethod2) {
        PsiMethod[] psiMethodArray;
        for (PsiMethod psiMethod3 : psiMethodArray = psiMethod2.findSuperMethods()) {
            if (psiMethod3 != psiMethod && !DebuggerTreeNodeExpression.a(psiMethod, psiMethod3)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiExpression substituteThis(@Nullable PsiElement expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue) throws EvaluateException {
        PsiClass psiClass;
        PsiType psiType;
        long l2 = b ^ 0x540FA2988F11L;
        if (!(expressionWithThis instanceof PsiExpression)) {
            return null;
        }
        PsiExpression psiExpression = (PsiExpression)expressionWithThis.copy();
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiExpression, PsiClass.class, (boolean)true);
        boolean bl2 = true;
        if (psiClass2 != null && (psiType = howToEvaluateThis.getType()) != null) {
            if (psiType instanceof PsiClassType) {
                psiClass = ((PsiClassType)psiType).resolve();
                if (psiClass != null && (psiClass == psiClass2 || psiClass.isInheritor(psiClass2, true))) {
                    bl2 = false;
                }
            } else if (psiType instanceof PsiArrayType) {
                psiClass = PsiUtil.getLanguageLevel((PsiElement)expressionWithThis);
                if (psiClass2 == JavaPsiFacade.getElementFactory((Project)expressionWithThis.getProject()).getArrayClass((LanguageLevel)psiClass)) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            howToEvaluateThis = DebuggerTreeNodeExpression.castToRuntimeType(howToEvaluateThis, howToEvaluateThisValue);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)psiExpression, (boolean)false);
        try {
            psiType = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)psiExpression, (PsiClass)psiClass2, (PsiExpression)howToEvaluateThis);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.this.expression", (Object[])new Object[]{psiExpression.getText(), howToEvaluateThis.getText()}), null);
        }
        try {
            psiClass = JavaPsiFacade.getElementFactory((Project)howToEvaluateThis.getProject()).createExpressionFromText(psiType.getText(), howToEvaluateThis.getContext());
            psiClass.putUserData(ADDITIONAL_IMPORTS_KEY, howToEvaluateThis.getUserData(ADDITIONAL_IMPORTS_KEY));
            return psiClass;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(incorrectOperationException.getMessage(), (Throwable)incorrectOperationException);
        }
    }

    public static PsiExpression castToRuntimeType(PsiExpression expression, Value value) throws EvaluateException {
        long l2 = b ^ 0x444ECCB94CD1L;
        if (!(value instanceof ObjectReference)) {
            return expression;
        }
        ReferenceType referenceType = ((ObjectReference)value).referenceType();
        if (referenceType == null) {
            return expression;
        }
        Project project2 = expression.getProject();
        PsiType psiType = RuntimeTypeEvaluator.getCastableRuntimeType(project2, value);
        if (psiType == null) {
            return expression;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String string = psiType.getCanonicalText();
        try {
            PsiParenthesizedExpression psiParenthesizedExpression = (PsiParenthesizedExpression)psiElementFactory.createExpressionFromText("((" + string + ")expression)", null);
            ((PsiTypeCastExpression)psiParenthesizedExpression.getExpression()).getOperand().replace((PsiElement)expression);
            Set set = (Set)expression.getUserData(ADDITIONAL_IMPORTS_KEY);
            if (set == null) {
                set = new SmartHashSet();
            }
            set.add(string);
            psiParenthesizedExpression.putUserData(ADDITIONAL_IMPORTS_KEY, (Object)set);
            return psiParenthesizedExpression;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.type.name", (Object[])new Object[]{string}), (Throwable)incorrectOperationException);
        }
    }

    public static String normalize(String qualifiedName, PsiElement contextElement, Project project2) {
        if (contextElement == null) {
            return qualifiedName;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass psiClass = javaPsiFacade.findClass(qualifiedName, GlobalSearchScope.allScope((Project)project2));
        if (psiClass != null) {
            return DebuggerTreeNodeExpression.a(psiClass, contextElement, javaPsiFacade.getResolveHelper());
        }
        return qualifiedName;
    }

    private static String a(PsiClass psiClass, PsiElement psiElement, PsiResolveHelper psiResolveHelper) {
        String string = psiClass.getName();
        PsiClass psiClass2 = psiResolveHelper.resolveReferencedClass(string, psiElement);
        if (psiClass.equals(psiClass2)) {
            return string;
        }
        PsiClass psiClass3 = psiClass.getContainingClass();
        if (psiClass3 != null) {
            return DebuggerTreeNodeExpression.a(psiClass3, psiElement, psiResolveHelper) + "." + string;
        }
        return psiClass.getQualifiedName();
    }

    public static PsiExpression getEvaluationExpression(DebuggerTreeNodeImpl node, DebuggerContextImpl context) throws EvaluateException {
        long l2 = b ^ 0x450BB548D755L;
        if (node.getDescriptor() instanceof ValueDescriptorImpl) {
            throw new IllegalStateException("Not supported any more");
        }
        a.error(node.getDescriptor() != null ? node.getDescriptor().getClass().getName() : "null");
        return null;
    }

    public static TextWithImports createEvaluationText(DebuggerTreeNodeImpl node, DebuggerContextImpl context) throws EvaluateException {
        EvaluateException[] evaluateExceptionArray = new EvaluateException[]{null};
        TextWithImports textWithImports = (TextWithImports)PsiDocumentManager.getInstance((Project)context.getProject()).commitAndRunReadAction(() -> {
            try {
                PsiExpression psiExpression = DebuggerTreeNodeExpression.getEvaluationExpression(node, context);
                if (psiExpression != null) {
                    return new TextWithImportsImpl((PsiElement)psiExpression);
                }
            }
            catch (EvaluateException evaluateException) {
                evaluateExceptionArray[0] = evaluateException;
            }
            return null;
        });
        if (evaluateExceptionArray[0] != null) {
            throw evaluateExceptionArray[0];
        }
        return textWithImports;
    }

    static {
        b = lb.a(-272395061349505487L, 3319329879252641444L, MethodHandles.lookup().lookupClass()).a(56220065457282L);
        long l2 = b ^ 0x6B6E8E7401F6L;
        a = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression");
        ADDITIONAL_IMPORTS_KEY = Key.create((String)"ADDITIONAL_IMPORTS");
    }

    private static class IncorrectOperationRuntimeException
    extends RuntimeException {
        private final IncorrectOperationException a;

        IncorrectOperationRuntimeException(IncorrectOperationException exception) {
            this.a = exception;
        }

        public IncorrectOperationException getException() {
            return this.a;
        }
    }
}

