/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import b.a.lb;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThrownExceptionValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes c;
    private static final SimpleTextAttributes b;
    private static final SimpleTextAttributes a;
    private static final long d;

    public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (tree2 == null) {
            DebuggerTreeRenderer.a(0);
        }
        if ((debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)value) != null) {
            SimpleColoredText simpleColoredText = debuggerTreeNodeImpl.getText();
            if (simpleColoredText != null) {
                simpleColoredText.appendToComponent((ColoredTextContainer)this);
            }
            this.setIcon(debuggerTreeNodeImpl.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptor descriptor2) {
        Icon icon = null;
        if (descriptor2 instanceof ThreadGroupDescriptorImpl) {
            icon = ((ThreadGroupDescriptorImpl)descriptor2).isCurrent() ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup;
        } else if (descriptor2 instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)descriptor2;
            icon = threadDescriptorImpl.getIcon();
        } else if (descriptor2 instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackFrameDescriptorImpl = (StackFrameDescriptorImpl)descriptor2;
            icon = stackFrameDescriptorImpl.getIcon();
        } else if (descriptor2 instanceof ValueDescriptorImpl) {
            icon = DebuggerTreeRenderer.getValueIcon((ValueDescriptorImpl)descriptor2, null);
        } else if (descriptor2 instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)descriptor2;
            if (messageDescriptor.getKind() == 0) {
                icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 2) {
                icon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 3) {
                icon = null;
            }
        } else if (descriptor2 instanceof StaticDescriptorImpl) {
            icon = AllIcons.Nodes.Static;
        }
        return icon;
    }

    public static Icon getValueIcon(ValueDescriptorImpl valueDescriptor, @Nullable ValueDescriptorImpl parentDescriptor) {
        Value value;
        Icon icon;
        Object object;
        if (valueDescriptor instanceof FieldDescriptorImpl) {
            object = (FieldDescriptorImpl)valueDescriptor;
            icon = PlatformIcons.FIELD_ICON;
            if (parentDescriptor != null && (value = valueDescriptor.getValue()) instanceof ObjectReference && value.equals(parentDescriptor.getValue())) {
                icon = AllIcons.Debugger.Selfreference;
            }
            if (((FieldDescriptorImpl)object).getField().isFinal()) {
                icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.FinalMark});
            }
            if (((FieldDescriptorImpl)object).isStatic()) {
                icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.StaticMark});
            }
        } else {
            icon = valueDescriptor instanceof ThrownExceptionValueDescriptorImpl ? AllIcons.Nodes.ExceptionClass : (valueDescriptor instanceof MethodReturnValueDescriptorImpl ? AllIcons.Debugger.WatchLastReturnValue : (DebuggerTreeRenderer.a(valueDescriptor) ? PlatformIcons.PARAMETER_ICON : (valueDescriptor.isEnumConstant() ? PlatformIcons.ENUM_ICON : (valueDescriptor.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptor.isPrimitive() ? AllIcons.Debugger.Db_primitive : (valueDescriptor instanceof WatchItemDescriptor ? AllIcons.Debugger.Db_watch : AllIcons.Debugger.Value))))));
        }
        if (valueDescriptor instanceof UserExpressionDescriptorImpl && (object = EnumerationChildrenRenderer.getCurrent(((UserExpressionDescriptorImpl)valueDescriptor).getParentDescriptor())) != null && ((EnumerationChildrenRenderer)object).isAppendDefaultChildren()) {
            icon = AllIcons.Debugger.Db_watch;
        }
        if (valueDescriptor instanceof WatchItemDescriptor && icon != AllIcons.Debugger.Db_watch && (object = XDebuggerManager.getInstance((Project)valueDescriptor.getProject()).getCurrentSession()) != null && (value = ((XDebugSessionImpl)object).getSessionTab()) != null && value.isWatchesInVariables()) {
            icon = AllIcons.Debugger.Db_watch;
        }
        object = valueDescriptor.getValueIcon();
        if (icon != null && object != null) {
            icon = new RowIcon(new Icon[]{icon, object});
        }
        return icon;
    }

    private static boolean a(ValueDescriptorImpl valueDescriptorImpl) {
        if (valueDescriptorImpl instanceof LocalVariableDescriptorImpl) {
            try {
                return ((LocalVariableDescriptorImpl)valueDescriptorImpl).getLocalVariable().getVariable().isArgument();
            }
            catch (EvaluateException evaluateException) {
            }
        } else if (valueDescriptorImpl instanceof ArgumentValueDescriptorImpl) {
            return ((ArgumentValueDescriptorImpl)valueDescriptorImpl).isParameter();
        }
        return false;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2, EditorColorsScheme colorsScheme, boolean multiline) {
        return DebuggerTreeRenderer.a(debuggerContext, descriptor2, colorsScheme, multiline, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2, boolean multiline) {
        return DebuggerTreeRenderer.a(debuggerContext, descriptor2, DebuggerUIUtil.getColorScheme(null), multiline, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor2) {
        return DebuggerTreeRenderer.a(debuggerContext, descriptor2, DebuggerUIUtil.getColorScheme(null), false, false);
    }

    private static SimpleColoredText a(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, EditorColorsScheme editorColorsScheme, boolean bl2, boolean bl3) {
        String[] stringArray;
        String string;
        String string2;
        long l2 = d ^ 0x793C18C3670EL;
        SimpleColoredText simpleColoredText = new SimpleColoredText();
        if (nodeDescriptorImpl == null) {
            string2 = "";
            string = null;
        } else {
            string2 = nodeDescriptorImpl.getLabel();
            string = nodeDescriptorImpl.getName();
        }
        if (string2.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
            simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return simpleColoredText;
        }
        if (nodeDescriptorImpl instanceof ValueDescriptor && (stringArray = ((ValueDescriptor)((Object)nodeDescriptorImpl)).getMarkup(debuggerContextImpl.getDebugProcess())) != null) {
            simpleColoredText.append("[" + stringArray.getText() + "] ", new SimpleTextAttributes(1, stringArray.getColor()));
        }
        if ((stringArray = DebuggerTreeRenderer.a(string2, string))[0] != null) {
            if (nodeDescriptorImpl instanceof MessageDescriptor && ((MessageDescriptor)nodeDescriptorImpl).getKind() == 3) {
                simpleColoredText.append((String)stringArray[0], b);
            } else {
                simpleColoredText.append((String)stringArray[0], c);
            }
        }
        if (stringArray[1] != null) {
            simpleColoredText.append((String)stringArray[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (stringArray[2] != null) {
            if (nodeDescriptorImpl instanceof ValueDescriptorImpl) {
                ValueDescriptorImpl valueDescriptorImpl;
                String string3;
                if (bl2 && stringArray[2].indexOf(10) >= 0 && (stringArray = DebuggerTreeRenderer.a((String)stringArray[2], "="))[2] != null) {
                    stringArray[2] = stringArray[0] + stringArray[1] + "\n" + stringArray[2];
                }
                if ((stringArray = DebuggerTreeRenderer.a((String)stringArray[2], string3 = (valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptorImpl).getValueLabel()))[0] != null) {
                    simpleColoredText.append(stringArray[0], c);
                }
                if (bl3 && stringArray[1] != null) {
                    SimpleTextAttributes simpleTextAttributes;
                    Object object;
                    if (string3 != null && StringUtil.startsWithChar((CharSequence)string3, (char)'{') && string3.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)string3, (char)'}')) {
                        int n2 = string3.indexOf(125);
                        object = string3.substring(0, n2 + 1);
                        string3 = string3.substring(n2 + 1);
                        simpleColoredText.append((String)object, a);
                    }
                    string3 = DebuggerUtilsEx.truncateString(string3);
                    if (valueDescriptorImpl.isDirty()) {
                        simpleTextAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                    } else {
                        object = null;
                        if (valueDescriptorImpl.isNull()) {
                            object = editorColorsScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                        } else if (valueDescriptorImpl.isString()) {
                            object = editorColorsScheme.getAttributes(JavaHighlightingColors.STRING);
                        }
                        simpleTextAttributes = object != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)object) : c;
                    }
                    object = nodeDescriptorImpl.getEvaluateException();
                    if (object != null) {
                        String string4 = object.getMessage();
                        if (string3.endsWith(string4)) {
                            DebuggerTreeRenderer.a(simpleColoredText, string3.substring(0, string3.length() - string4.length()), simpleTextAttributes, editorColorsScheme);
                            simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        } else {
                            DebuggerTreeRenderer.a(simpleColoredText, string3, simpleTextAttributes, editorColorsScheme);
                            simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        }
                    } else if (string3.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                        simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        DebuggerTreeRenderer.a(simpleColoredText, string3, simpleTextAttributes, editorColorsScheme);
                    }
                }
            } else {
                simpleColoredText.append((String)stringArray[2], c);
            }
        }
        return simpleColoredText;
    }

    private static void a(SimpleColoredText simpleColoredText, String string, SimpleTextAttributes simpleTextAttributes, EditorColorsScheme editorColorsScheme) {
        SimpleTextAttributes simpleTextAttributes2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            char c10 = string.charAt(i10);
            if (bl2) {
                bl2 = false;
                if (c10 == '\\' || c10 == '\"' || c10 == 'b' || c10 == 't' || c10 == 'n' || c10 == 'f' || c10 == 'r') {
                    if (stringBuilder.length() > 0) {
                        simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
                        stringBuilder.setLength(0);
                    }
                    if (simpleTextAttributes2 == null) {
                        TextAttributes textAttributes = editorColorsScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                        simpleTextAttributes2 = textAttributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes) : c.derive(1, (Color)JBColor.GRAY, null, null);
                    }
                    if (c10 != '\\' && c10 != '\"') {
                        simpleColoredText.append("\\", simpleTextAttributes2);
                    }
                    simpleColoredText.append(String.valueOf(c10), simpleTextAttributes2);
                    continue;
                }
                stringBuilder.append('\\').append(c10);
                continue;
            }
            if (c10 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c10);
        }
        if (stringBuilder.length() > 0) {
            simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
        }
    }

    private static String[] a(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            int n2 = Math.max(string.indexOf(string2), 0);
            String string3 = n2 > 0 ? string.substring(0, n2) : null;
            String string4 = (n2 += string2.length()) < string.length() - 1 ? string.substring(n2) : null;
            return new String[]{string3, string2, string4};
        }
        return new String[]{string, null, null};
    }

    static {
        d = lb.a(8537140772904867190L, -2543423764345618207L, MethodHandles.lookup().lookupClass()).a(103632754434960L);
        c = new SimpleTextAttributes(0, null);
        b = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
        a = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = d ^ 0x346EED73253AL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "customizeCellRenderer"));
    }
}

