/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import b.a.lb;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.UpdatableDebuggerView;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.PopupHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.VMDisconnectedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerTreePanel
extends UpdatableDebuggerView
implements DataProvider,
Disposable {
    public static final DataKey<DebuggerTreePanel> DATA_KEY;
    private final SingleAlarm f;
    protected DebuggerTree myTree;
    private static final long j;

    public DebuggerTreePanel(Project project2, DebuggerStateManager stateManager) {
        long l2 = j ^ 0x7EEC65A0BEF8L;
        super(project2, stateManager);
        this.f = new SingleAlarm(() -> {
            try {
                DebuggerContextImpl debuggerContextImpl = this.getContext();
                if (debuggerContextImpl.getDebuggerSession() != null) {
                    this.getTree().rebuild(debuggerContextImpl);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }, 100);
        this.myTree = this.createTreeView();
        final PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x2, int y2) {
                ActionPopupMenu actionPopupMenu = DebuggerTreePanel.this.createPopupMenu();
                if (actionPopupMenu != null) {
                    DebuggerTreePanel.this.myTree.myTipManager.registerPopup(actionPopupMenu.getComponent()).show(comp, x2, y2);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)popupHandler);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new IdeFocusTraversalPolicy(){

            public Component getDefaultComponentImpl(Container focusCycleRoot) {
                return DebuggerTreePanel.this.myTree;
            }
        });
        this.registerDisposable(new Disposable(){

            public void dispose() {
                DebuggerTreePanel.this.myTree.removeMouseListener((MouseListener)popupHandler);
            }
        });
        DebuggerUIUtil.registerActionOnComponent((String)"Debugger.MarkObject", (JComponent)((Object)this.myTree), (Disposable)this);
    }

    protected abstract DebuggerTree createTreeView();

    @Override
    protected void changeEvent(DebuggerContextImpl newContext, DebuggerSession.Event event) {
        super.changeEvent(newContext, event);
        if (event == DebuggerSession.Event.DISPOSE) {
            this.getTree().getNodeFactory().dispose();
        }
    }

    @Override
    protected void rebuild(DebuggerSession.Event event) {
        this.f.cancelAndRequest();
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.f);
        try {
            super.dispose();
        }
        finally {
            DebuggerTree debuggerTree = this.myTree;
            if (debuggerTree != null) {
                Disposer.dispose((Disposable)debuggerTree);
            }
            this.myTree = null;
        }
    }

    protected abstract ActionPopupMenu createPopupMenu();

    public final DebuggerTree getTree() {
        return this.myTree;
    }

    public void clear() {
        this.myTree.removeAllChildren();
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            DebuggerTreePanel.b(0);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.getTree()), true));
    }

    static {
        j = lb.a(-676680508390934687L, -5000711526439252623L, MethodHandles.lookup().lookupClass()).a(61640790845041L);
        long l2 = j ^ 0x6AAAD46DCF37L;
        DATA_KEY = DataKey.create((String)"DebuggerPanel");
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = j ^ 0x22339A242435L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/debugger/ui/impl/DebuggerTreePanel", "getData"));
    }
}

