/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class WildcardMethodBreakpoint
extends Breakpoint<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger c;
    private static final long m;

    public WildcardMethodBreakpoint(Project project2, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        super(project2, breakpoint);
    }

    @Override
    public Key<MethodBreakpoint> getCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    protected WildcardMethodBreakpoint(Project project2, @NotNull String classPattern, @NotNull String methodName, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (classPattern == null) {
            WildcardMethodBreakpoint.b(0);
        }
        if (methodName == null) {
            WildcardMethodBreakpoint.b(1);
        }
        super(project2, breakpoint);
        this.a(classPattern);
        this.b(methodName);
    }

    @Override
    public String getClassName() {
        return this.a();
    }

    @Override
    @Nullable
    public String getShortClassName() {
        return this.getClassName();
    }

    public String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> this.getClassName() != null ? DebuggerUtils.findClass((String)this.getClassName(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null);
    }

    @Override
    public String getDisplayName() {
        long l2 = m ^ 0x5511D6C0D967L;
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        return this.a() + "." + this.getMethodName() + "()";
    }

    @Override
    public Icon getIcon() {
        if (!this.isEnabled()) {
            Breakpoint breakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return breakpoint == null ? AllIcons.Debugger.Db_disabled_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return (this.isEmulated() || this.a(event.location().method())) && super.evaluateCondition(context, event);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        if (this.isEmulated()) {
            debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, this.a());
            Pattern pattern = PatternUtil.fromMask((String)this.a());
            debugProcess.getVirtualMachineProxy().allClasses().stream().filter(referenceType -> pattern.matcher(referenceType.name()).matches()).filter(ReferenceType::isPrepared).forEach(referenceType -> this.processClassPrepare(debugProcess, (ReferenceType)referenceType));
        } else {
            try {
                EventRequest eventRequest;
                RequestManagerImpl requestManagerImpl = debugProcess.getRequestsManager();
                if (this.isWatchEntry()) {
                    eventRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                    if (eventRequest == null) {
                        eventRequest = requestManagerImpl.createMethodEntryRequest(this);
                    } else {
                        eventRequest.disable();
                    }
                    eventRequest.addClassFilter(this.a());
                    debugProcess.getRequestsManager().enableRequest(eventRequest);
                }
                if (this.isWatchExit()) {
                    eventRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                    if (eventRequest == null) {
                        eventRequest = requestManagerImpl.createMethodExitRequest(this);
                    } else {
                        eventRequest.disable();
                    }
                    eventRequest.addClassFilter(this.a());
                    debugProcess.getRequestsManager().enableRequest(eventRequest);
                }
            }
            catch (Exception exception) {
                c.debug((Throwable)exception);
            }
        }
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType refType) {
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, (DebugProcessImpl)debugProcess, refType, true);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            WildcardMethodBreakpoint.b(2);
        }
        return MethodBreakpoint.getEventMessage(event, "");
    }

    @Override
    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.a()) && !StringUtil.isEmpty((String)this.getMethodName());
    }

    @Override
    public PsiElement getEvaluationElement() {
        return null;
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        long l2 = m ^ 0x4A47BF07C5A7L;
        super.readExternal(parentNode);
        String string = parentNode.getAttributeValue("class_name");
        this.a(string);
        String string2 = parentNode.getAttributeValue("method_name");
        this.b(string2);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string2 == null) {
            throw new InvalidDataException();
        }
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        return (StreamEx)methods.filter(this::a);
    }

    private boolean a(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : StringUtil.split((String)this.getMethodName(), (String)",")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append('(').append(PatternUtil.convertToRegex((String)string)).append(')');
        }
        try {
            return method != null && Pattern.compile(stringBuilder.toString()).matcher(method.name()).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            c.warn((Throwable)patternSyntaxException);
            return false;
        }
    }

    public static WildcardMethodBreakpoint create(Project project2, String classPattern, String methodName, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        return new WildcardMethodBreakpoint(project2, classPattern, methodName, xBreakpoint);
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    private String a() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern;
    }

    private void a(String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = string;
    }

    private void b(String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = string;
    }

    static {
        m = lb.a(-8393728131535200826L, 8909701789062533109L, MethodHandles.lookup().lookupClass()).a(140952071804068L);
        long l2 = m ^ 0x35A0F752D7EBL;
        c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = m ^ 0x69C524D59E73L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

