/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class ExceptionBreakpoint
extends Breakpoint<JavaExceptionBreakpointProperties> {
    private static final Logger c;
    protected static final String READ_NO_CLASS_NAME;
    @NonNls
    public static final Key<ExceptionBreakpoint> CATEGORY;
    private static final long e;

    public ExceptionBreakpoint(Project project2, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    public Key<? extends ExceptionBreakpoint> getCategory() {
        return CATEGORY;
    }

    protected ExceptionBreakpoint(Project project2, String qualifiedName, String packageName, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
        this.setQualifiedName(qualifiedName);
        if (packageName == null) {
            this.setPackageName(ExceptionBreakpoint.a(qualifiedName));
        } else {
            this.setPackageName(packageName);
        }
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        return n2 >= 0 ? string.substring(0, n2) : "";
    }

    @Override
    public String getClassName() {
        return this.a();
    }

    @Override
    public String getPackageName() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName;
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> this.a() != null ? DebuggerUtils.findClass((String)this.a(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null);
    }

    @Override
    public String getDisplayName() {
        long l2 = e ^ 0x3FDFB04AF3AAL;
        return DebuggerBundle.message((String)"breakpoint.exception.breakpoint.display.name", (Object[])new Object[]{this.a()});
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        SourcePosition sourcePosition = (SourcePosition)ReadAction.compute(() -> {
            PsiClass psiClass = DebuggerUtils.findClass((String)this.a(), (Project)this.myProject, (GlobalSearchScope)debugProcess.getSearchScope());
            return psiClass != null ? SourcePosition.createFromElement((PsiElement)psiClass) : null;
        });
        if (sourcePosition == null) {
            this.createOrWaitPrepare(debugProcess, this.a());
        } else {
            this.createOrWaitPrepare(debugProcess, sourcePosition);
        }
    }

    @Override
    public void processClassPrepare(DebugProcess process2, ReferenceType refType) {
        long l2 = e ^ 0x37A334B59C95L;
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)process2;
        if (this.shouldCreateRequest(debugProcessImpl, true) && !debugProcessImpl.getRequestsManager().checkReadOnly(this)) {
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            requestManagerImpl.enableRequest(requestManagerImpl.createExceptionRequest(this, refType, this.b(), this.c()));
            if (c.isDebugEnabled()) {
                if (refType != null) {
                    c.debug("Created exception request for reference type " + refType.name());
                } else {
                    c.debug("Created exception request for reference type null");
                }
            }
        }
    }

    @Override
    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return event.location().declaringType().name();
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        if (event instanceof ExceptionEvent) {
            return ((ExceptionEvent)event).exception();
        }
        return super.getThisObject(context, event);
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        String string;
        Mirror mirror;
        long l2 = e ^ 0x70B50100EA11L;
        String string2 = this.a() != null ? this.a() : "java.lang.Throwable";
        String string3 = null;
        if (event instanceof ExceptionEvent) {
            mirror = (ExceptionEvent)event;
            try {
                string2 = mirror.exception().type().name();
                string3 = mirror.thread().name();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mirror = event.location();
        String string4 = DebuggerUtilsEx.getLocationMethodQName((Location)mirror);
        try {
            String string5 = mirror.sourceName();
            int n2 = DebuggerUtilsEx.getLineNumber((Location)mirror, false);
            string = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info", (Object[])new Object[]{string5, n2});
        }
        catch (AbsentInformationException absentInformationException) {
            string = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info.absent", (Object[])new Object[0]);
        }
        if (string3 != null) {
            return DebuggerBundle.message((String)"exception.breakpoint.console.message.with.thread.info", (Object[])new Object[]{string2, string3, string4, string});
        }
        return DebuggerBundle.message((String)"exception.breakpoint.console.message", (Object[])new Object[]{string2, string4, string});
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        Location location;
        if (((JavaExceptionBreakpointProperties)((Object)this.getProperties())).isCatchFiltersEnabled() && event instanceof ExceptionEvent && (location = ((ExceptionEvent)event).catchLocation()) != null && !ExceptionBreakpoint.typeMatchesClassFilters(location.declaringType().name(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassFilters(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassExclusionFilters())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public PsiElement getEvaluationElement() {
        if (this.getClassName() == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.getClassName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        long l2 = e ^ 0x2089D98DEF6AL;
        super.readExternal(parentNode);
        String string = parentNode.getAttributeValue("package_name");
        this.setPackageName(string != null ? string : ExceptionBreakpoint.a(string));
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"NOTIFY_CAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"NOTIFY_UNCAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = parentNode.getAttributeValue("class_name");
        this.setQualifiedName(string2);
        if (string2 == null) {
            throw new InvalidDataException(READ_NO_CLASS_NAME);
        }
    }

    private boolean b() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT;
    }

    private boolean c() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT;
    }

    private String a() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName;
    }

    void setQualifiedName(String qualifiedName) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName = qualifiedName;
    }

    void setPackageName(String packageName) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName = packageName;
    }

    public void setCatchFiltersEnabled(boolean enabled) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchFiltersEnabled(enabled);
    }

    public void setCatchClassFilters(ClassFilter[] filters) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassFilters(filters);
    }

    public void setCatchClassExclusionFilters(ClassFilter[] filters) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassExclusionFilters(filters);
    }

    static {
        e = lb.a(-8140129336009325664L, -7339751107990701912L, MethodHandles.lookup().lookupClass()).a(74955020932245L);
        long l2 = e ^ 0xD067FEC6A5CL;
        c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
        READ_NO_CLASS_NAME = DebuggerBundle.message((String)"error.absent.exception.breakpoint.class.name", (Object[])new Object[0]);
        CATEGORY = BreakpointCategory.lookup("exception_breakpoints");
    }
}

