/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    private static final Logger c;
    @Nullable
    private SourcePosition e;
    private boolean g;
    private volatile Icon f;
    @Nullable
    private String d;
    @Nullable
    private String i;
    @Nullable
    private String h;
    private static final long t;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected Icon getInvalidIcon(boolean isMuted) {
        return AllIcons.Debugger.Db_invalid_breakpoint;
    }

    protected Icon getSetIcon(boolean isMuted) {
        return null;
    }

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.f;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.d;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null && sourcePosition.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.i;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        if (!this.isValid()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
        }
        return this;
    }

    private void b(@Nullable DebugProcessImpl debugProcessImpl) {
        JavaDebugProcess javaDebugProcess;
        this.f = this.c(debugProcessImpl);
        if (this.isVisible() && this.isValid() && debugProcessImpl != null && this.myXBreakpoint instanceof XLineBreakpoint && (javaDebugProcess = debugProcessImpl.getXdebugProcess()) != null) {
            javaDebugProcess.getSession().updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.f, this.h);
        }
        if (debugProcessImpl != null && debugProcessImpl.getVirtualMachineProxy().canBeModified()) {
            this.d = JVMNameUtil.getSourcePositionClassDisplayName(debugProcessImpl, this.getSourcePosition());
            this.i = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcessImpl, this.getSourcePosition());
        }
    }

    private Icon c(@Nullable DebugProcessImpl debugProcessImpl) {
        boolean bl2;
        boolean bl3 = bl2 = debugProcessImpl != null && this.isMuted(debugProcessImpl);
        if (!this.isEnabled()) {
            return this.getDisabledIcon(bl2);
        }
        this.h = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(bl2);
        }
        if (debugProcessImpl == null) {
            return this.getSetIcon(bl2);
        }
        RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
        boolean bl4 = this.myCachedVerifiedState || requestManagerImpl.isVerified(this);
        String string = requestManagerImpl.getWarning(this);
        if (string != null) {
            this.h = string;
            if (!bl4) {
                return this.getInvalidIcon(bl2);
            }
            return this.getVerifiedWarningsIcon(bl2);
        }
        if (bl4) {
            return this.getVerifiedIcon(bl2);
        }
        return this.getValidatingIcon(bl2);
    }

    protected Icon getValidatingIcon(boolean muted) {
        Icon icon;
        if (this.myXBreakpoint != null && (icon = this.myXBreakpoint.getType().getPendingIcon()) != null) {
            return icon;
        }
        return this.getSetIcon(muted);
    }

    protected BreakpointWithHighlighter(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            BreakpointWithHighlighter.b(0);
        }
        super(project2, xBreakpoint);
        this.g = true;
        this.f = this.getSetIcon(false);
        ApplicationManager.getApplication().runReadAction(this::reload);
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(@Nullable XSourcePosition sourcePosition) {
        return (Boolean)ReadAction.compute(() -> sourcePosition != null && sourcePosition.getFile().isValid());
    }

    @Nullable
    public SourcePosition getSourcePosition() {
        return this.e;
    }

    @NotNull
    public String getDescription() {
        Object[] objectArray;
        long l2 = t ^ 0x88BAC27E721L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDisplayName());
        if (this.isCountFilterEnabled()) {
            stringBuilder.append("&nbsp;<br>&nbsp;");
            stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
            stringBuilder.append(this.getCountFilter());
        }
        if (this.isClassFiltersEnabled()) {
            stringBuilder.append("&nbsp;<br>&nbsp;");
            stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
            for (ClassFilter classFilter : objectArray = this.getClassFilters()) {
                stringBuilder.append(classFilter.getPattern()).append(" ");
            }
        }
        if (this.isInstanceFiltersEnabled()) {
            stringBuilder.append("&nbsp;<br>&nbsp;");
            stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
            for (ClassFilter classFilter : objectArray = this.getInstanceFilters()) {
                stringBuilder.append(classFilter.getId()).append(" ");
            }
        }
        String string = stringBuilder.toString();
        if (string == null) {
            BreakpointWithHighlighter.b(1);
        }
        return string;
    }

    @Override
    public void reload() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.e = DebuggerUtilsEx.toSourcePosition(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (this.e != null) {
            this.reload(null);
        }
    }

    @Nullable
    static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess) {
        if (requestor == null) {
            BreakpointWithHighlighter.b(2);
        }
        if (debugProcess == null) {
            BreakpointWithHighlighter.b(3);
        }
        if (location != null) {
            RequestManagerImpl requestManagerImpl = debugProcess.getRequestsManager();
            BreakpointRequest breakpointRequest = requestManagerImpl.createBreakpointRequest(requestor, location);
            requestManagerImpl.enableRequest(breakpointRequest);
            return breakpointRequest;
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcess) {
        long l2 = t ^ 0x3CDAC4A9BF41L;
        if (debugProcess == null) {
            BreakpointWithHighlighter.b(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null) {
            this.createOrWaitPrepare(debugProcess, sourcePosition);
        } else {
            c.error("Unable to create request for breakpoint with null position: " + this.toString() + " at " + this.myXBreakpoint.getSourcePosition());
        }
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            BreakpointWithHighlighter.b(5);
        }
        return debugProcess.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType classType) {
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)debugProcess;
        if (this.shouldCreateRequest(debugProcessImpl, true)) {
            this.createRequestForPreparedClass(debugProcessImpl, classType);
            this.updateUI();
        }
    }

    @Override
    public final void updateUI() {
        if (!this.isVisible() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DebuggerInvocationUtil.swingInvokeLater(this.myProject, () -> {
            if (!this.isValid()) {
                return;
            }
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            if (debugProcessImpl == null || !debugProcessImpl.isAttached()) {
                this.b(null);
            } else {
                debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (!BreakpointWithHighlighter.this.myProject.isDisposed()) {
                                BreakpointWithHighlighter.this.b(debugProcessImpl);
                            }
                        });
                    }
                });
            }
        });
    }

    public boolean isAt(@NotNull Document document, int offset) {
        if (document == null) {
            BreakpointWithHighlighter.b(6);
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        int n2 = document.getLineNumber(offset);
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null && xSourcePosition.getLine() == n2 && xSourcePosition.getFile().equals(virtualFile);
    }

    @Deprecated
    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(@Nullable SourcePosition sourcePosition) {
        return (PsiClass)ReadAction.compute(() -> JVMNameUtil.getClassAt(sourcePosition));
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    protected boolean isVisible() {
        return this.g;
    }

    public void setVisible(boolean visible) {
        this.g = visible;
    }

    @Nullable
    public Document getDocument() {
        PsiFile psiFile = DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (psiFile != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
        }
        return null;
    }

    public int getLineIndex() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null ? xSourcePosition.getLine() : -1;
    }

    protected String getFileName() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null ? xSourcePosition.getFile().getName() : "";
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        String string;
        long l2 = t ^ 0x6B3EB6231A1BL;
        if (breakpointNode == null) {
            BreakpointWithHighlighter.b(7);
        }
        super.readExternal(breakpointNode);
        String string2 = breakpointNode.getAttributeValue("class");
        if (string2 != null) {
            this.d = string2;
        }
        if ((string = breakpointNode.getAttributeValue("package")) != null) {
            this.i = string;
        }
    }

    public String toString() {
        return (String)ReadAction.compute(() -> {
            long l2 = t ^ 0xF86A8EB3B8BL;
            return "<html><body>" + this.getDescription() + "</body>" + "</html>";
        });
    }

    static {
        t = lb.a(3914944878228672031L, -1977383886790356529L, MethodHandles.lookup().lookupClass()).a(100353489668082L);
        long l2 = t ^ 0x31ECFE15EAE8L;
        c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = t ^ 0x4D0D86800EFCL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMuted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

