/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import gnu.trove.THashMap;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class BreakpointManager {
    private static final Logger f;
    @NonNls
    private static final String e = "master_breakpoint";
    @NonNls
    private static final String h = "slave_breakpoint";
    @NonNls
    private static final String j = "default_suspend_policy";
    @NonNls
    private static final String i = "default_condition_enabled";
    @NonNls
    private static final String c = "breakpoint_rules";
    private static final String a = "converted";
    private final Project d;
    private final Map<String, String> g;
    private final Map<String, Element> b;
    private static final long k;

    public BreakpointManager(@NotNull Project project2, @NotNull DebuggerManagerImpl debuggerManager) {
        if (project2 == null) {
            BreakpointManager.a(0);
        }
        if (debuggerManager == null) {
            BreakpointManager.a(1);
        }
        this.g = new LinkedHashMap<String, String>();
        this.b = new LinkedHashMap<String, Element>();
        this.d = project2;
        debuggerManager.getContextManager().addListener(new DebuggerContextListener(){
            private DebuggerSession a;
            private static final long b = lb.a(5302692594344656083L, -5155334406856104041L, MethodHandles.lookup().lookupClass()).a(192112661588870L);

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    1.a(0);
                }
                if (event == DebuggerSession.Event.ATTACHED) {
                    for (XBreakpoint xBreakpoint : BreakpointManager.this.a().getAllBreakpoints()) {
                        if (BreakpointManager.a(xBreakpoint)) break;
                    }
                }
                if (newContext.getDebuggerSession() != this.a || event == DebuggerSession.Event.DETACHED) {
                    BreakpointManager.this.updateBreakpointsUI();
                    this.a = newContext.getDebuggerSession();
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = b ^ 0x397C9FD2F6CEL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1", "changeEvent"));
            }
        });
    }

    private static boolean a(XBreakpoint xBreakpoint) {
        long l2 = k ^ 0x730D225513F8L;
        XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
        if (xBreakpoint.isEnabled() && xBreakpointProperties instanceof JavaMethodBreakpointProperties && !((JavaMethodBreakpointProperties)xBreakpointProperties).EMULATED) {
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"method.breakpoints.slowness.warning", (Object[])new Object[0]), MessageType.WARNING).notify(((XBreakpointBase)xBreakpoint).getProject());
            return true;
        }
        return false;
    }

    public void addListeners(@NotNull MessageBusConnection busConnection) {
        if (busConnection == null) {
            BreakpointManager.a(2);
        }
        busConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){
            private static final long a = lb.a(6968809751800450296L, 1900105065810501361L, MethodHandles.lookup().lookupClass()).a(134328402936104L);

            public void breakpointAdded(@NotNull XBreakpoint<?> xBreakpoint) {
                Breakpoint breakpoint;
                if (xBreakpoint == null) {
                    2.a(0);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    BreakpointManager.addBreakpoint(breakpoint);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                Breakpoint breakpoint;
                if (xBreakpoint == null) {
                    2.a(1);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    BreakpointManager.this.fireBreakpointChanged(breakpoint);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x73E4193133DBL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "xBreakpoint";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private XBreakpointManager a() {
        return XDebuggerManager.getInstance((Project)this.d).getBreakpointManager();
    }

    public void editBreakpoint(Breakpoint breakpoint, Editor editor) {
        DebuggerInvocationUtil.swingInvokeLater(this.d, () -> {
            GutterIconRenderer gutterIconRenderer;
            RangeHighlighter rangeHighlighter;
            XBreakpoint xBreakpoint = breakpoint.myXBreakpoint;
            if (xBreakpoint instanceof XLineBreakpointImpl && (rangeHighlighter = ((XLineBreakpointImpl)xBreakpoint).getHighlighter()) != null && (gutterIconRenderer = rangeHighlighter.getGutterIconRenderer()) != null) {
                DebuggerSupport.getDebuggerSupport(JavaDebuggerSupport.class).getEditBreakpointAction().editBreakpoint(this.d, editor, breakpoint.myXBreakpoint, gutterIconRenderer);
            }
        });
    }

    public void setBreakpointDefaults(Key<? extends Breakpoint> category, BreakpointDefaults defaults) {
        Class clazz = null;
        if (LineBreakpoint.CATEGORY.toString().equals(category.toString())) {
            clazz = JavaLineBreakpointType.class;
        } else if (MethodBreakpoint.CATEGORY.toString().equals(category.toString())) {
            clazz = JavaMethodBreakpointType.class;
        } else if (FieldBreakpoint.CATEGORY.toString().equals(category.toString())) {
            clazz = JavaFieldBreakpointType.class;
        } else if (ExceptionBreakpoint.CATEGORY.toString().equals(category.toString())) {
            clazz = JavaExceptionBreakpointType.class;
        }
        if (clazz != null) {
            XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
            ((XBreakpointManagerImpl)this.a()).getBreakpointDefaults(xBreakpointType).setSuspendPolicy(Breakpoint.transformSuspendPolicy(defaults.getSuspendPolicy()));
        }
    }

    @Nullable
    public RunToCursorBreakpoint addRunToCursorBreakpoint(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            BreakpointManager.a(3);
        }
        return RunToCursorBreakpoint.create(this.d, position, ignoreBreakpoints);
    }

    @Nullable
    public StepIntoBreakpoint addStepIntoBreakpoint(@NotNull BreakpointStepMethodFilter filter) {
        if (filter == null) {
            BreakpointManager.a(4);
        }
        return StepIntoBreakpoint.create(this.d, filter);
    }

    @Nullable
    public LineBreakpoint addLineBreakpoint(Document document, int lineIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!LineBreakpoint.canAddLineBreakpoint(this.d, document, lineIndex)) {
            return null;
        }
        XLineBreakpoint xLineBreakpoint = this.a(JavaLineBreakpointType.class, document, lineIndex);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof LineBreakpoint) {
            BreakpointManager.addBreakpoint(breakpoint);
            return (LineBreakpoint)breakpoint;
        }
        return null;
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(@NotNull Document document, int offset) {
        PsiField psiField;
        if (document == null) {
            BreakpointManager.a(5);
        }
        if ((psiField = FieldBreakpoint.findField(this.d, document, offset)) == null) {
            return null;
        }
        int n2 = document.getLineNumber(offset);
        if (document.getLineNumber(psiField.getNameIdentifier().getTextOffset()) < n2) {
            return null;
        }
        return this.addFieldBreakpoint(document, n2, psiField.getName());
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(Document document, int lineIndex, String fieldName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaFieldBreakpointType.class, document, lineIndex);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)breakpoint;
            fieldBreakpoint.setFieldName(fieldName);
            BreakpointManager.addBreakpoint(breakpoint);
            return fieldBreakpoint;
        }
        return null;
    }

    @Nullable
    public ExceptionBreakpoint addExceptionBreakpoint(@NotNull String exceptionClassName, String packageName) {
        if (exceptionClassName == null) {
            BreakpointManager.a(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JavaExceptionBreakpointType javaExceptionBreakpointType = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
        return (ExceptionBreakpoint)WriteAction.compute(() -> {
            XBreakpoint xBreakpoint;
            Breakpoint breakpoint;
            long l2 = k ^ 0x48BAD95BE5D9L;
            if (exceptionClassName == null) {
                BreakpointManager.a(18);
            }
            if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint = XDebuggerManager.getInstance((Project)this.d).getBreakpointManager().addBreakpoint((XBreakpointType)javaExceptionBreakpointType, (XBreakpointProperties)new JavaExceptionBreakpointProperties(exceptionClassName, packageName)))) instanceof ExceptionBreakpoint) {
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setQualifiedName(exceptionClassName);
                exceptionBreakpoint.setPackageName(packageName);
                BreakpointManager.addBreakpoint(exceptionBreakpoint);
                f.debug("ExceptionBreakpoint Added");
                return exceptionBreakpoint;
            }
            return null;
        });
    }

    @Nullable
    public MethodBreakpoint addMethodBreakpoint(Document document, int lineIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaMethodBreakpointType.class, document, lineIndex);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof MethodBreakpoint) {
            BreakpointManager.addBreakpoint(breakpoint);
            return (MethodBreakpoint)breakpoint;
        }
        return null;
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Document document, int n2) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return (XLineBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.d).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)xBreakpointType, virtualFile.getUrl(), n2, ((XLineBreakpointType)xBreakpointType).createBreakpointProperties(virtualFile, n2)));
    }

    @Nullable
    public <T extends BreakpointWithHighlighter> T findBreakpoint(Document document, int offset, @Nullable Key<T> category) {
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            if (!(breakpoint instanceof BreakpointWithHighlighter) || !((BreakpointWithHighlighter)breakpoint).isAt(document, offset) || category != null && !category.equals(breakpoint.getCategory())) continue;
            return (T)((BreakpointWithHighlighter)breakpoint);
        }
        return null;
    }

    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            BreakpointManager.a(7);
        }
        this.b.clear();
        for (Element element : parentNode.getChildren()) {
            this.b.put(element.getName(), JDOMUtil.internElement((Element)element));
        }
        if (!this.d.isDefault()) {
            StartupManager.getInstance((Project)this.d).runWhenProjectIsInitialized(() -> {
                if (parentNode == null) {
                    BreakpointManager.a(17);
                }
                this.a(parentNode);
            });
        }
    }

    private void a(@NotNull Element element) {
        long l2 = k ^ 0x65C26144991L;
        if (element == null) {
            BreakpointManager.a(8);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object;
            Object object2;
            Element element2;
            String string;
            Element element3;
            List list2;
            long l2 = k ^ 0x17C49C1808A9L;
            if (element == null) {
                BreakpointManager.a(16);
            }
            THashMap tHashMap = new THashMap();
            try {
                list2 = element.getChildren();
                for (Object object3 : list2) {
                    XBreakpoint xBreakpoint;
                    Breakpoint breakpoint;
                    Object object4;
                    XBreakpointManager xBreakpointManager;
                    Element element4;
                    element3 = (Element)object3;
                    if (element3.getName().equals(c) || element3.getAttribute(a) != null) continue;
                    string = element3.getName();
                    element2 = BreakpointCategory.lookup(string);
                    object2 = element3.getAttributeValue(j);
                    boolean bl2 = Boolean.parseBoolean(element3.getAttributeValue(i, "true"));
                    this.setBreakpointDefaults((Key<? extends Breakpoint>)element2, new BreakpointDefaults((String)object2, bl2));
                    if (!AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.equals((Object)element2)) {
                        element4 = element3.getChild(AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.toString());
                        object = element3.getChildren("breakpoint").iterator();
                        while (object.hasNext()) {
                            xBreakpointManager = (Element)object.next();
                            object4 = this.a(string, (Element)xBreakpointManager);
                            ((Breakpoint)object4).readExternal((Element)xBreakpointManager);
                            tHashMap.put(((Breakpoint)object4).getDisplayName(), object4);
                        }
                    } else {
                        element4 = element3;
                    }
                    if (element4 == null || (object = element3.getChild("breakpoint")) == null || (breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint = (xBreakpointManager = XDebuggerManager.getInstance((Project)this.d).getBreakpointManager()).getDefaultBreakpoint((XBreakpointType)(object4 = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class))))) == null) continue;
                    breakpoint.readExternal((Element)object);
                    BreakpointManager.addBreakpoint(breakpoint);
                }
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
            if ((list2 = element.getChild(c)) != null) {
                Object object3;
                List list3 = list2.getChildren("rule");
                object3 = list3.iterator();
                while (object3.hasNext()) {
                    Breakpoint breakpoint;
                    element3 = (Element)object3.next();
                    if (element3.getAttribute(a) != null || (string = element3.getChild(e)) == null || (element2 = element3.getChild(h)) == null || (object2 = (Breakpoint)tHashMap.get(string.getAttributeValue("name"))) == null || (breakpoint = (Breakpoint)tHashMap.get(element2.getAttributeValue("name"))) == null) continue;
                    boolean bl3 = Boolean.parseBoolean(element3.getAttributeValue("leaveEnabled"));
                    object = ((XBreakpointManagerImpl)this.a()).getDependentBreakpointManager();
                    object.setMasterBreakpoint(breakpoint.myXBreakpoint, ((Breakpoint)object2).myXBreakpoint, bl3);
                }
            }
            DebuggerInvocationUtil.invokeLater(this.d, this::updateBreakpointsUI);
        });
        this.g.clear();
        Element element2 = element.getChild("ui_properties");
        if (element2 != null) {
            List list2 = element2.getChildren("property");
            for (Object e10 : list2) {
                Element element3 = (Element)e10;
                String string = element3.getAttributeValue("name");
                String string2 = element3.getAttributeValue("value");
                if (string == null || string2 == null) continue;
                this.g.put(string, string2);
            }
        }
    }

    private Breakpoint a(String string, Element element) throws InvalidDataException {
        long l2 = k ^ 0x2D917CB7BA5FL;
        Object object = null;
        if (string.equals(LineBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaLineBreakpointType.class, element);
        } else if (string.equals(MethodBreakpoint.CATEGORY.toString())) {
            object = element.getAttribute("url") != null ? this.a(JavaMethodBreakpointType.class, element) : this.a(JavaWildcardMethodBreakpointType.class);
        } else if (string.equals(FieldBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaFieldBreakpointType.class, element);
        } else if (string.equals(ExceptionBreakpoint.CATEGORY.toString())) {
            object = this.a(JavaExceptionBreakpointType.class);
        }
        if (object == null) {
            throw new IllegalStateException("Unknown breakpoint category " + string);
        }
        return BreakpointManager.getJavaBreakpoint((XBreakpoint)object);
    }

    private <B extends XBreakpoint<?>> XBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.d).getBreakpointManager().addBreakpoint(xBreakpointType, xBreakpointType.createProperties()));
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Element element) throws InvalidDataException {
        int n2;
        long l2 = k ^ 0x2AE47A1BE747L;
        String string = element.getAttributeValue("url");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{string}));
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{string}));
        }
        try {
            n2 = Integer.parseInt(element.getAttributeValue("line"));
        }
        catch (Exception exception) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        return this.a(clazz, document, n2);
    }

    public static void addBreakpoint(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            BreakpointManager.a(9);
        }
        assert (breakpoint.myXBreakpoint.getUserData(Breakpoint.DATA_KEY) == breakpoint);
        breakpoint.updateUI();
        BreakpointManager.a(breakpoint.myXBreakpoint);
    }

    public void removeBreakpoint(@Nullable Breakpoint breakpoint) {
        if (breakpoint == null) {
            return;
        }
        WriteAction.run(() -> this.a().removeBreakpoint(breakpoint.myXBreakpoint));
    }

    public void writeExternal(@NotNull Element parentNode) {
        long l2 = k ^ 0x51DBF1AEB5FL;
        if (parentNode == null) {
            BreakpointManager.a(10);
        }
        for (Element element : this.b.values()) {
            Element element2 = element.clone();
            if (element2.getAttribute(a) == null) {
                element2.setAttribute(a, "true");
            }
            parentNode.addContent(element2);
        }
    }

    @NotNull
    public List<Breakpoint> getBreakpoints() {
        List list2 = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])this.a().getAllBreakpoints(), BreakpointManager::getJavaBreakpoint));
        if (list2 == null) {
            BreakpointManager.a(11);
        }
        return list2;
    }

    @Nullable
    public static Breakpoint getJavaBreakpoint(@Nullable XBreakpoint xBreakpoint) {
        if (xBreakpoint == null) {
            return null;
        }
        Breakpoint breakpoint = (Breakpoint)xBreakpoint.getUserData(Breakpoint.DATA_KEY);
        if (breakpoint == null && xBreakpoint.getType() instanceof JavaBreakpointType) {
            Project project2 = ((XBreakpointBase)xBreakpoint).getProject();
            breakpoint = ((JavaBreakpointType)xBreakpoint.getType()).createJavaBreakpoint(project2, xBreakpoint);
            xBreakpoint.putUserData(Breakpoint.DATA_KEY, breakpoint);
        }
        return breakpoint;
    }

    public void disableBreakpoints(@NotNull DebugProcessImpl debugProcess) {
        List<Breakpoint> list2;
        if (debugProcess == null) {
            BreakpointManager.a(12);
        }
        if (!(list2 = this.getBreakpoints()).isEmpty()) {
            RequestManagerImpl requestManagerImpl = debugProcess.getRequestsManager();
            for (Breakpoint breakpoint : list2) {
                breakpoint.markVerified(requestManagerImpl.isVerified(breakpoint));
                requestManagerImpl.deleteRequest(breakpoint);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    public void enableBreakpoints(DebugProcessImpl debugProcess) {
        List<Breakpoint> list2 = this.getBreakpoints();
        if (!list2.isEmpty()) {
            for (Breakpoint breakpoint : list2) {
                breakpoint.markVerified(false);
                breakpoint.createRequest(debugProcess);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcess, @Nullable ThreadReference newFilterThread) {
        RequestManagerImpl requestManagerImpl;
        ThreadReference threadReference;
        if (debugProcess == null) {
            BreakpointManager.a(13);
        }
        if (Comparing.equal((Object)newFilterThread, (Object)(threadReference = (requestManagerImpl = debugProcess.getRequestsManager()).getFilterThread()))) {
            return;
        }
        requestManagerImpl.setFilterThread(newFilterThread);
        if (newFilterThread == null || threadReference != null) {
            List<Breakpoint> list2 = this.getBreakpoints();
            for (Breakpoint breakpoint : list2) {
                if (!LineBreakpoint.CATEGORY.equals(breakpoint.getCategory()) && !MethodBreakpoint.CATEGORY.equals(breakpoint.getCategory())) continue;
                requestManagerImpl.deleteRequest(breakpoint);
                breakpoint.createRequest(debugProcess);
            }
        } else {
            EventRequestManager eventRequestManager = requestManagerImpl.getVMRequestManager();
            if (eventRequestManager != null) {
                BreakpointManager.a(eventRequestManager.breakpointRequests(), (? super T breakpointRequest) -> breakpointRequest.addThreadFilter(newFilterThread));
                BreakpointManager.a(eventRequestManager.methodEntryRequests(), (? super T methodEntryRequest) -> methodEntryRequest.addThreadFilter(newFilterThread));
                BreakpointManager.a(eventRequestManager.methodExitRequests(), (? super T methodExitRequest) -> methodExitRequest.addThreadFilter(newFilterThread));
            }
        }
    }

    private static <T extends EventRequest> void a(@NotNull List<T> list2, Consumer<? super T> consumer) {
        if (list2 == null) {
            BreakpointManager.a(14);
        }
        for (EventRequest eventRequest : list2) {
            try {
                boolean bl2 = eventRequest.isEnabled();
                if (bl2) {
                    eventRequest.disable();
                }
                consumer.accept(eventRequest);
                if (!bl2) continue;
                eventRequest.enable();
            }
            catch (InternalException | InvalidRequestStateException runtimeException) {
                f.info((Throwable)runtimeException);
            }
        }
    }

    public void updateBreakpointsUI() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::updateUI);
    }

    public void reloadBreakpoints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::reload);
    }

    public void fireBreakpointChanged(Breakpoint breakpoint) {
        breakpoint.reload();
        breakpoint.updateUI();
    }

    @Nullable
    public Breakpoint findMasterBreakpoint(@NotNull Breakpoint dependentBreakpoint) {
        if (dependentBreakpoint == null) {
            BreakpointManager.a(15);
        }
        XDependentBreakpointManager xDependentBreakpointManager = ((XBreakpointManagerImpl)this.a()).getDependentBreakpointManager();
        return BreakpointManager.getJavaBreakpoint(xDependentBreakpointManager.getMasterBreakpoint(dependentBreakpoint.myXBreakpoint));
    }

    public String getProperty(String name2) {
        return this.g.get(name2);
    }

    public String setProperty(String name2, String value) {
        return this.g.put(name2, value);
    }

    static {
        k = lb.a(6059761893867402321L, -8937983081619185281L, MethodHandles.lookup().lookupClass()).a(245918285705999L);
        long l2 = k ^ 0x202A70F4B06EL;
        f = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointManager");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0xCCEFB56618BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busConnection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRunToCursorBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addStepIntoBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFieldBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableBreakpoints";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyThreadFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMasterBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRead$4";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readExternal$3";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExceptionBreakpoint$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

