/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class Breakpoint<P extends JavaBreakpointProperties>
implements FilteredRequestor,
ClassPrepareRequestor,
OverheadProducer {
    public static final Key<Breakpoint> DATA_KEY;
    private static final Key<Long> a;
    final XBreakpoint<P> myXBreakpoint;
    protected final Project myProject;
    @NonNls
    private static final String b = "LOG_MESSAGE";
    protected boolean myCachedVerifiedState;
    private static final long s;

    protected Breakpoint(@NotNull Project project2, XBreakpoint<P> xBreakpoint) {
        if (project2 == null) {
            Breakpoint.a(0);
        }
        this.myCachedVerifiedState = false;
        this.myProject = project2;
        this.myXBreakpoint = xBreakpoint;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            Breakpoint.a(1);
        }
        return project2;
    }

    @NotNull
    protected P getProperties() {
        JavaBreakpointProperties javaBreakpointProperties = (JavaBreakpointProperties)this.myXBreakpoint.getProperties();
        if (javaBreakpointProperties == null) {
            Breakpoint.a(2);
        }
        return (P)((Object)javaBreakpointProperties);
    }

    public final XBreakpoint<P> getXBreakpoint() {
        return this.myXBreakpoint;
    }

    @Nullable
    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    static boolean shouldCreateRequest(Requestor requestor, XBreakpoint xBreakpoint, DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return (Boolean)ReadAction.compute(() -> {
            JavaDebugProcess javaDebugProcess = debugProcess.getXdebugProcess();
            return !(javaDebugProcess == null || !debugProcess.isAttached() || xBreakpoint != null && !((XDebugSessionImpl)javaDebugProcess.getSession()).isBreakpointActive(xBreakpoint) || !forPreparedClass && !debugProcess.getRequestsManager().findRequests(requestor).isEmpty());
        });
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return Breakpoint.shouldCreateRequest(this, this.getXBreakpoint(), debugProcess, forPreparedClass);
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess) {
        return this.shouldCreateRequest(debugProcess, false);
    }

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        if (this.myXBreakpoint != null) {
            renderer.setIcon(this.myXBreakpoint.getType().getEnabledIcon());
        } else {
            renderer.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        renderer.append(this.getDisplayName());
    }

    public abstract String getDisplayName();

    public String getShortName() {
        return this.getDisplayName();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean isVerified) {
        this.myCachedVerifiedState = isVerified;
    }

    public boolean isRemoveAfterHit() {
        return this.myXBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myXBreakpoint).isTemporary();
    }

    public void setRemoveAfterHit(boolean value) {
        if (this.myXBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myXBreakpoint).setTemporary(value);
        }
    }

    @Nullable
    public String getShortClassName() {
        String string = this.getClassName();
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        return n2 >= 0 && n2 + 1 < string.length() ? string.substring(n2 + 1) : string;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    protected String getStackTrace(LocatableEvent event) {
        long l2 = s ^ 0x6B89F9960F00L;
        StringBuilder stringBuilder = new StringBuilder(DebuggerBundle.message((String)"status.line.breakpoint.reached.full.trace", (Object[])new Object[0]));
        try {
            event.thread().frames().forEach(stackFrame -> {
                long l2 = s ^ 0x50C71581BF2DL;
                stringBuilder.append("\n\t  ").append(ThreadDumpAction.renderLocation(stackFrame.location()));
            });
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            stringBuilder.append("Stacktrace not available: ").append(incompatibleThreadStateException.getMessage());
        }
        return stringBuilder.toString();
    }

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        if (virtualMachineProxyImpl.canBeModified()) {
            this.a(debugProcess, virtualMachineProxyImpl.classesByName(classToBeLoaded).stream());
        }
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, @NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            Breakpoint.a(3);
        }
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classPosition);
        if (debugProcess.getVirtualMachineProxy().canBeModified()) {
            this.a(debugProcess, debugProcess.getPositionManager().getAllClasses(classPosition).stream().distinct());
        }
    }

    private void a(DebugProcessImpl debugProcessImpl, Stream<ReferenceType> stream2) {
        stream2.filter(ReferenceType::isPrepared).forEach(referenceType -> this.processClassPrepare(debugProcessImpl, (ReferenceType)referenceType));
    }

    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxyImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context.getThread();
        if (threadReferenceProxyImpl != null && (stackFrameProxyImpl = threadReferenceProxyImpl.frame(0)) != null) {
            return stackFrameProxyImpl.thisObject();
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        long l2 = s ^ 0x56DE920767FFL;
        SuspendContextImpl suspendContextImpl = action.getSuspendContext();
        if (!this.isValid()) {
            suspendContextImpl.getDebugProcess().getRequestsManager().deleteRequest(this);
            return false;
        }
        String string = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0]);
        try {
            StackFrameProxyImpl stackFrameProxyImpl = suspendContextImpl.getThread().frame(0);
            if (stackFrameProxyImpl == null) {
                return false;
            }
            EvaluationContextImpl evaluationContextImpl = new EvaluationContextImpl(suspendContextImpl, stackFrameProxyImpl, () -> this.getThisObject(suspendContextImpl, event));
            if (!this.evaluateCondition(evaluationContextImpl, event)) {
                return false;
            }
            string = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.a(evaluationContextImpl, event);
        }
        catch (EvaluateException evaluateException) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println(evaluateException.getMessage());
                return false;
            }
            throw new LocatableEventRequestor.EventProcessingException(string, evaluateException.getMessage(), evaluateException);
        }
        return true;
    }

    private void a(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) {
        long l2 = s ^ 0x57BC0BBAE24BL;
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        if (this.isLogEnabled() || this.isLogExpressionEnabled() || this.isLogStack()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.myXBreakpoint.isLogMessage()) {
                stringBuilder.append(this.getEventMessage(locatableEvent)).append("\n");
            }
            if (this.isLogStack()) {
                stringBuilder.append(this.getStackTrace(locatableEvent)).append("\n");
            }
            if (this.isLogExpressionEnabled()) {
                if (!debugProcessImpl.isAttached()) {
                    return;
                }
                TextWithImports textWithImports = this.getLogMessage();
                try {
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
                    PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
                    ExpressionEvaluator expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> {
                        long l2 = s ^ 0x334F69F4360BL;
                        return EvaluatorCache.cacheOrGet("LogMessageEvaluator", locatableEvent.request(), psiElement, textWithImports, () -> Breakpoint.a(this.myProject, psiElement, sourcePosition, textWithImports, this::b));
                    });
                    Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
                    stringBuilder.append(value instanceof VoidValue ? "void" : DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value));
                }
                catch (EvaluateException evaluateException) {
                    stringBuilder.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0])).append(" \"").append(textWithImports).append("\"").append(" : ").append(evaluateException.getMessage());
                }
                stringBuilder.append("\n");
            }
            if (stringBuilder.length() > 0) {
                debugProcessImpl.printToConsole(stringBuilder.toString());
            }
        }
        if (this.isRemoveAfterHit()) {
            this.a(debugProcessImpl);
        }
    }

    private boolean a(long l2) {
        return Arrays.stream(this.getInstanceFilters()).anyMatch(instanceFilter -> instanceFilter.getId() == l2);
    }

    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        String string;
        Mirror mirror;
        Object object;
        long l2 = s ^ 0x4FC79558BB65L;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        if (this.isCountFilterEnabled() && !this.isConditionEnabled()) {
            debugProcessImpl.getVirtualMachineProxy().suspend();
            debugProcessImpl.getRequestsManager().deleteRequest(this);
            this.createRequest(debugProcessImpl);
            debugProcessImpl.getVirtualMachineProxy().resume();
        }
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        if (((JavaBreakpointProperties)((Object)this.getProperties())).isCALLER_FILTERS_ENABLED() && stackFrameProxyImpl != null) {
            object = stackFrameProxyImpl.threadProxy();
            mirror = ((ThreadReferenceProxyImpl)object).frameCount() > 1 ? ((ThreadReferenceProxyImpl)object).frame(1) : null;
            String string2 = string = mirror != null ? DebuggerUtilsEx.methodKey(((StackFrameProxyImpl)((Object)mirror)).location().method()) : null;
            if (!Breakpoint.typeMatchesClassFilters(string, ((JavaBreakpointProperties)((Object)this.getProperties())).getCallerFilters(), ((JavaBreakpointProperties)((Object)this.getProperties())).getCallerExclusionFilters())) {
                return false;
            }
        }
        if (this.isInstanceFiltersEnabled() && (object = context.computeThisObject()) != null && !this.a((mirror = (ObjectReference)object).uniqueID())) {
            return false;
        }
        if (this.isClassFiltersEnabled() && !Breakpoint.typeMatchesClassFilters(this.calculateEventClass(context, event), this.getClassFilters(), this.getClassExclusionFilters())) {
            return false;
        }
        if (this.isConditionEnabled()) {
            object = this.getCondition();
            if (object.isEmpty()) {
                return true;
            }
            if (stackFrameProxyImpl != null && (mirror = stackFrameProxyImpl.location()) != null && (string = debugProcessImpl.getPositionManager().evaluateCondition(context, stackFrameProxyImpl, (Location)mirror, object.getText())) != ThreeState.UNSURE) {
                return string == ThreeState.YES;
            }
            try {
                mirror = ContextUtil.getSourcePosition((StackFrameContext)context);
                string = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> this.a((SourcePosition)mirror, event, (TextWithImports)object));
                if (!DebuggerUtilsEx.evaluateBoolean((ExpressionEvaluator)string, context)) {
                    return false;
                }
            }
            catch (EvaluateException evaluateException) {
                if (evaluateException.getCause() instanceof VMDisconnectedException) {
                    return false;
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{object, evaluateException.getMessage()}));
            }
        }
        if (this.isCountFilterEnabled() && this.isConditionEnabled()) {
            object = (Long)ObjectUtils.notNull((Object)((Long)event.request().getProperty(a)), (Object)0L) + 1L;
            event.request().putProperty(a, object);
            return (Long)object % (long)this.getCountFilter() == 0L;
        }
        return true;
    }

    private static ExpressionEvaluator a(Project project2, PsiElement psiElement, SourcePosition sourcePosition, TextWithImports textWithImports, Function<PsiElement, PsiCodeFragment> function) throws EvaluateException {
        try {
            return EvaluatorBuilderImpl.build(textWithImports, psiElement, sourcePosition, project2);
        }
        catch (UnsupportedExpressionException unsupportedExpressionException) {
            ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(project2, psiElement, function);
            if (expressionEvaluator != null) {
                return expressionEvaluator;
            }
            throw unsupportedExpressionException;
        }
    }

    private PsiCodeFragment a(PsiElement psiElement) {
        return Breakpoint.a(this.myProject, this.getCondition(), psiElement);
    }

    private PsiCodeFragment b(PsiElement psiElement) {
        return Breakpoint.a(this.myProject, this.getLogMessage(), psiElement);
    }

    private static PsiCodeFragment a(Project project2, TextWithImports textWithImports, PsiElement psiElement) {
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement).createCodeFragment(textWithImports, psiElement, project2);
    }

    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        String string = null;
        ObjectReference objectReference = (ObjectReference)context.computeThisObject();
        if (objectReference != null) {
            string = objectReference.referenceType().name();
        } else {
            StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
            if (stackFrameProxyImpl != null) {
                string = stackFrameProxyImpl.location().declaringType().name();
            }
        }
        return string;
    }

    protected static boolean typeMatchesClassFilters(@Nullable String typeName, ClassFilter[] includeFilters, ClassFilter[] exludeFilters) {
        if (typeName == null) {
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (ClassFilter classFilter2 : includeFilters) {
            if (!classFilter2.isEnabled()) continue;
            bl3 = true;
            if (!classFilter2.matches(typeName)) continue;
            bl2 = true;
            break;
        }
        if (bl3 && !bl2) {
            return false;
        }
        return Arrays.stream(exludeFilters).noneMatch(classFilter -> classFilter.isEnabled() && classFilter.matches(typeName));
    }

    private void a(final DebugProcessImpl debugProcessImpl) {
        debugProcessImpl.getRequestsManager().deleteRequest(this);
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){
            private static final long a = lb.a(1635646537728810957L, 8019680865896598437L, MethodHandles.lookup().lookupClass()).a(15752388911922L);

            public void resumed(SuspendContext suspendContext) {
                this.a();
            }

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                if (process2 == null) {
                    1.a(0);
                }
                this.a();
            }

            private void a() {
                AppUIUtil.invokeOnEdt(() -> DebuggerManagerEx.getInstanceEx(Breakpoint.this.myProject).getBreakpointManager().removeBreakpoint(Breakpoint.this));
                debugProcessImpl.removeDebugProcessListener(this);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4F56178B2350L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/ui/breakpoints/Breakpoint$1", "processDetached"));
            }
        });
    }

    public void updateUI() {
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        long l2 = s ^ 0x7416DE226407L;
        FilteredRequestorImpl filteredRequestorImpl = new FilteredRequestorImpl(this.myProject);
        filteredRequestorImpl.readTo(parentNode, this);
        try {
            this.setEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setLogEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = JDOMExternalizerUtil.readField((Element)parentNode, (String)b);
            if (string != null && !string.isEmpty()) {
                XExpressionImpl xExpressionImpl = XExpressionImpl.fromText((String)string);
                XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointLogExpression", (XExpression)xExpressionImpl);
                this.myXBreakpoint.setLogExpressionObject((XExpression)xExpressionImpl);
                ((XBreakpointBase)this.myXBreakpoint).setLogExpressionEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_EXPRESSION_ENABLED")).booleanValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setRemoveAfterHit(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"REMOVE_AFTER_HIT")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public abstract PsiElement getEvaluationElement();

    protected TextWithImports getLogMessage() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getLogExpressionObject());
    }

    protected TextWithImports getCondition() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getConditionExpression());
    }

    @Override
    public boolean isEnabled() {
        return this.myXBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myXBreakpoint.setEnabled(enabled);
    }

    protected boolean isLogEnabled() {
        return this.myXBreakpoint.isLogMessage();
    }

    public void setLogEnabled(boolean logEnabled) {
        this.myXBreakpoint.setLogMessage(logEnabled);
    }

    protected boolean isLogStack() {
        return this.myXBreakpoint.isLogStack();
    }

    protected boolean isLogExpressionEnabled() {
        if (XDebuggerUtilImpl.isEmptyExpression((XExpression)this.myXBreakpoint.getLogExpressionObject())) {
            return false;
        }
        return !this.getLogMessage().isEmpty();
    }

    @Override
    public boolean isCountFilterEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCOUNT_FILTER_ENABLED() && this.getCountFilter() > 0;
    }

    public void setCountFilterEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public int getCountFilter() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getCOUNT_FILTER();
    }

    public void setCountFilter(int filter) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER(filter)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCLASS_FILTERS_ENABLED();
    }

    public void setClassFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCLASS_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassFilters();
    }

    public void setClassFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassExclusionFilters();
    }

    public void setClassExclusionFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassExclusionFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isINSTANCE_FILTERS_ENABLED();
    }

    public void setInstanceFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setINSTANCE_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getInstanceFilters();
    }

    public void setInstanceFilters(InstanceFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setInstanceFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    private static String a(XBreakpoint xBreakpoint) {
        long l2 = s ^ 0x529D02CC3115L;
        switch (xBreakpoint.getSuspendPolicy()) {
            case ALL: {
                return "SuspendAll";
            }
            case THREAD: {
                return "SuspendThread";
            }
            case NONE: {
                return "SuspendNone";
            }
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    static SuspendPolicy transformSuspendPolicy(String policy) {
        long l2 = s ^ 0x1FE234A988EFL;
        if ("SuspendAll".equals(policy)) {
            return SuspendPolicy.ALL;
        }
        if ("SuspendThread".equals(policy)) {
            return SuspendPolicy.THREAD;
        }
        if ("SuspendNone".equals(policy)) {
            return SuspendPolicy.NONE;
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    protected boolean isSuspend() {
        return this.myXBreakpoint.getSuspendPolicy() != SuspendPolicy.NONE;
    }

    @Override
    public String getSuspendPolicy() {
        return Breakpoint.a(this.myXBreakpoint);
    }

    public void setSuspendPolicy(String policy) {
        this.myXBreakpoint.setSuspendPolicy(Breakpoint.transformSuspendPolicy(policy));
    }

    @Override
    public boolean isConditionEnabled() {
        XExpression xExpression = this.myXBreakpoint.getConditionExpression();
        if (XDebuggerUtilImpl.isEmptyExpression((XExpression)xExpression)) {
            return false;
        }
        return !this.getCondition().isEmpty();
    }

    public void setCondition(@Nullable TextWithImports condition) {
        this.myXBreakpoint.setConditionExpression(TextWithImportsImpl.toXExpression(condition));
    }

    public void addInstanceFilter(long l2) {
        ((JavaBreakpointProperties)((Object)this.getProperties())).addInstanceFilter(l2);
    }

    protected void fireBreakpointChanged() {
        ((XBreakpointBase)this.myXBreakpoint).fireBreakpointChanged();
    }

    private /* synthetic */ ExpressionEvaluator a(SourcePosition sourcePosition, LocatableEvent locatableEvent, TextWithImports textWithImports) throws EvaluateException {
        long l2 = s ^ 0x2501B7788E48L;
        PsiElement psiElement = ContextUtil.getContextElement(sourcePosition);
        PsiElement psiElement2 = psiElement != null ? psiElement : this.getEvaluationElement();
        return EvaluatorCache.cacheOrGet("ConditionEvaluator", locatableEvent.request(), psiElement2, textWithImports, () -> Breakpoint.a(this.myProject, psiElement2, sourcePosition, textWithImports, this::a));
    }

    static {
        s = lb.a(-4107843781033686392L, 2953279070413852361L, MethodHandles.lookup().lookupClass()).a(273551514458503L);
        long l2 = s ^ 0x51F655BA7FF2L;
        DATA_KEY = Key.create((String)"JavaBreakpoint");
        a = Key.create((String)"HIT_COUNTER");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = s ^ 0x16820875B628L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/Breakpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/Breakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOrWaitPrepare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EvaluatorCache {
        private final PsiElement c;
        private final TextWithImports b;
        private final ExpressionEvaluator a;

        private EvaluatorCache(PsiElement context, TextWithImports textWithImports, ExpressionEvaluator evaluator) {
            this.c = context;
            this.b = textWithImports;
            this.a = evaluator;
        }

        @Nullable
        static ExpressionEvaluator cacheOrGet(String propertyName, EventRequest request, PsiElement context, TextWithImports text2, EvaluatingComputable<? extends ExpressionEvaluator> supplier) throws EvaluateException {
            EvaluatorCache evaluatorCache = (EvaluatorCache)request.getProperty(propertyName);
            if (evaluatorCache != null && Objects.equals(evaluatorCache.c, context) && Objects.equals(evaluatorCache.b, text2)) {
                return evaluatorCache.a;
            }
            ExpressionEvaluator expressionEvaluator = supplier.compute();
            request.putProperty(propertyName, new EvaluatorCache(context, text2, expressionEvaluator));
            return expressionEvaluator;
        }
    }
}

