/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.reference.SoftReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import gnu.trove.TIntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class HotSwapProgressImpl
extends HotSwapProgress {
    static final NotificationGroup NOTIFICATION_GROUP;
    private final TIntObjectHashMap<List<String>> e;
    private final ProgressWindow i;
    private String h;
    private final MergingUpdateQueue g;
    private WeakReference<XDebugSession> d;
    private final List<HotSwapProgressListener> f;
    private static final long j;

    public HotSwapProgressImpl(Project project2) {
        long l2 = j ^ 0x51A7EC20326DL;
        super(project2);
        this.e = new TIntObjectHashMap();
        this.h = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);
        this.d = null;
        this.f = ContainerUtil.newSmartList();
        this.i = new BackgroundableProcessIndicator(this.getProject(), this.h, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return DebuggerSettings.getInstance().HOTSWAP_IN_BACKGROUND;
            }
        }, null, null, true);
        this.i.setIndeterminate(false);
        this.i.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                super.cancel();
                HotSwapProgressImpl.this.cancel();
            }
        });
        this.g = new MergingUpdateQueue("HotSwapProgress update queue", 100, true, null, (Disposable)this.i);
    }

    @Override
    public void cancel() {
        super.cancel();
        for (HotSwapProgressListener hotSwapProgressListener : this.f) {
            hotSwapProgressListener.onCancel();
        }
    }

    @Override
    public void finished() {
        long l2 = j ^ 0x10BDF8B12287L;
        super.finished();
        for (HotSwapProgressListener object2 : this.f) {
            object2.onFinish();
        }
        List<String> list2 = this.getMessages(4);
        List<String> list3 = this.getMessages(5);
        if (!list2.isEmpty()) {
            this.a(DebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]), this.a(list2, true), NotificationType.ERROR);
        } else if (!list3.isEmpty()) {
            this.a(DebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]), this.a(list3, true), NotificationType.WARNING);
        } else if (!this.e.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int n2 : this.e.keys()) {
                arrayList.addAll(this.getMessages(n2));
            }
            this.a("", this.a(arrayList, false), NotificationType.INFORMATION);
        }
    }

    private void a(String string, String string2, NotificationType notificationType) {
        HotSwapNotificationListener hotSwapNotificationListener = null;
        if (SoftReference.dereference(this.d) != null) {
            hotSwapNotificationListener = new HotSwapNotificationListener(this.d);
        }
        NOTIFICATION_GROUP.createNotification(string, string2, notificationType, (NotificationListener)hotSwapNotificationListener).setImportant(false).notify(this.getProject());
    }

    public void setSessionForActions(@NotNull DebuggerSession session) {
        if (session == null) {
            HotSwapProgressImpl.a(0);
        }
        this.d = new WeakReference<XDebugSession>(session.getXDebugSession());
    }

    List<String> getMessages(int category) {
        return ContainerUtil.notNullize((List)((List)this.e.get(category)));
    }

    private String a(List<String> list2, boolean bl2) {
        long l2 = j ^ 0x46BC6CFB023CL;
        StringBuilder stringBuilder = new StringBuilder(StreamEx.of(list2).map(string -> StringUtil.trimEnd((String)string, (char)';')).joining((CharSequence)"\n"));
        if (SoftReference.dereference(this.d) != null) {
            stringBuilder.append("\n").append(DebuggerBundle.message((String)"status.hot.swap.completed.stop", (Object[])new Object[0]));
            if (bl2) {
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(DebuggerBundle.message((String)"status.hot.swap.completed.restart", (Object[])new Object[0]));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void addMessage(DebuggerSession session, int type, String text2) {
        long l2 = j ^ 0x13B1B56B41DAL;
        List list2 = (List)this.e.get(type);
        if (list2 == null) {
            list2 = new SmartList();
            this.e.put(type, (Object)list2);
        }
        list2.add(session.getSessionName() + ": " + text2 + ";");
    }

    @Override
    public void setText(final String text2) {
        long l2 = j ^ 0x7DE21DB67AF7L;
        this.g.queue(new Update("Text"){

            public void run() {
                DebuggerInvocationUtil.invokeLater(HotSwapProgressImpl.this.getProject(), () -> {
                    if (!HotSwapProgressImpl.this.i.isCanceled() && HotSwapProgressImpl.this.i.isRunning()) {
                        HotSwapProgressImpl.this.i.setText(text2);
                    }
                }, HotSwapProgressImpl.this.i.getModalityState());
            }
        });
    }

    @Override
    public void setTitle(String text2) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.i.isCanceled() && this.i.isRunning()) {
                this.i.setTitle(text2);
            }
        }, this.i.getModalityState());
    }

    @Override
    public void setFraction(double v2) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.i.isCanceled() && this.i.isRunning()) {
                this.i.setFraction(v2);
            }
        }, this.i.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.i.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.i;
    }

    @Override
    public void setDebuggerSession(DebuggerSession session) {
        long l2 = j ^ 0x8969E641510L;
        this.h = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + session.getSessionName();
        this.i.setTitle(this.h);
    }

    void addProgressListener(@NotNull HotSwapProgressListener listener) {
        if (listener == null) {
            HotSwapProgressImpl.a(1);
        }
        this.f.add(listener);
    }

    static {
        j = lb.a(9007426645106700210L, -416354982587716867L, MethodHandles.lookup().lookupClass()).a(216420031042708L);
        long l2 = j ^ 0x55D03EB7D9A8L;
        NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"HotSwap", (String)ToolWindowId.DEBUG);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = j ^ 0x7ED8B267142DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/HotSwapProgressImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSessionForActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgressListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface HotSwapProgressListener {
        default public void onCancel() {
        }

        default public void onFinish() {
        }
    }

    private static class HotSwapNotificationListener
    implements NotificationListener {
        final WeakReference<XDebugSession> mySessionRef;
        private static final long a = lb.a(4406052092565141584L, 4645775017941700904L, MethodHandles.lookup().lookupClass()).a(93346663867716L);

        HotSwapNotificationListener(WeakReference<XDebugSession> sessionRef) {
            this.mySessionRef = sessionRef;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x49A9F8020E84L;
            if (notification == null) {
                HotSwapNotificationListener.a(0);
            }
            if (event == null) {
                HotSwapNotificationListener.a(1);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            XDebugSession xDebugSession = (XDebugSession)SoftReference.dereference(this.mySessionRef);
            if (xDebugSession == null) {
                return;
            }
            notification.expire();
            switch (event.getDescription()) {
                case "stop": {
                    xDebugSession.stop();
                    break;
                }
                case "restart": {
                    ExecutionEnvironment executionEnvironment = ((XDebugSessionImpl)xDebugSession).getExecutionEnvironment();
                    if (executionEnvironment == null) break;
                    ExecutionUtil.restart((ExecutionEnvironment)executionEnvironment);
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x6E5B4D06CAA1L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/HotSwapProgressImpl$HotSwapNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

