/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import b.a.lb;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;

public abstract class EditorEvaluationCommand<T>
extends DebuggerContextCommandImpl {
    protected final PsiElement myElement;
    @Nullable
    private final Editor i;
    protected final ProgressIndicator myProgressIndicator;
    private static final long o = lb.a(522545325967853996L, -2484756070943250074L, MethodHandles.lookup().lookupClass()).a(142130964578587L);

    public EditorEvaluationCommand(@Nullable Editor editor, PsiElement expression, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(context);
        this.myProgressIndicator = indicator;
        this.i = editor;
        this.myElement = expression;
    }

    @Override
    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    protected abstract T evaluate(EvaluationContextImpl var1) throws EvaluateException;

    public T evaluate() throws EvaluateException {
        long l2 = o ^ 0x4602204942E6L;
        Object[] objectArray = new Object[1];
        objectArray[0] = ReadAction.compute(() -> ((PsiElement)this.myElement).getText());
        this.myProgressIndicator.setText(DebuggerBundle.message((String)"progress.evaluating", (Object[])objectArray));
        try {
            T t2 = this.evaluate(this.getDebuggerContext().createEvaluationContext());
            if (this.myProgressIndicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            return t2;
        }
        catch (EvaluateException evaluateException) {
            if (this.i != null) {
                DebuggerInvocationUtil.invokeLater(this.myElement.getProject(), () -> EditorEvaluationCommand.showEvaluationHint(this.i, this.myElement, evaluateException), this.myProgressIndicator.getModalityState());
            }
            throw evaluateException;
        }
    }

    public static void showEvaluationHint(Editor myEditor, PsiElement myElement, EvaluateException e10) {
        if (myEditor.isDisposed() || !myEditor.getComponent().isVisible()) {
            return;
        }
        HintManager.getInstance().showErrorHint(myEditor, e10.getMessage(), myElement.getTextRange().getStartOffset(), myElement.getTextRange().getEndOffset(), (short)2, 9, 1500);
    }
}

