/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> a;
    private static final Key<Boolean> c;
    private final Project b;
    private static final long d;

    public AlternativeSourceNotificationProvider(Project project2) {
        this.b = project2;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = a;
        if (key == null) {
            AlternativeSourceNotificationProvider.a(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            AlternativeSourceNotificationProvider.a(1);
        }
        if (fileEditor == null) {
            AlternativeSourceNotificationProvider.a(2);
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.b).getCurrentSession();
        if (xDebugSession == null) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        XSourcePosition xSourcePosition = xDebugSession.getCurrentPosition();
        if (xSourcePosition == null || !file.equals(xSourcePosition.getFile())) {
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.b).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
        if (psiClassArray.length == 0) {
            return null;
        }
        PsiClass psiClass2 = psiClassArray[0];
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return null;
        }
        if (DumbService.getInstance((Project)this.b).isDumb()) {
            return null;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])JavaPsiFacade.getInstance((Project)this.b).findClasses(string, GlobalSearchScope.allScope((Project)this.b)));
        ContainerUtil.removeDuplicates((Collection)arrayList);
        AlternativeSourceNotificationProvider.setFileProcessed(file, true);
        if (arrayList.size() > 1) {
            Location location;
            Object object2;
            for (Object object2 : arrayList) {
                if (!object2.equals(psiClass2) && !object2.getNavigationElement().equals(psiClass2)) continue;
                arrayList.remove(object2);
                break;
            }
            arrayList.add(0, psiClass2);
            ComboBoxClassElement[] comboBoxClassElementArray = (ComboBoxClassElement[])ContainerUtil.map2Array((Collection)arrayList, ComboBoxClassElement.class, psiClass -> new ComboBoxClassElement((PsiClass)psiClass.getNavigationElement()));
            object2 = null;
            XStackFrame xStackFrame = xDebugSession.getCurrentStackFrame();
            if (xStackFrame instanceof JavaStackFrame && (location = ((JavaStackFrame)xStackFrame).getDescriptor().getLocation()) != null) {
                object2 = location.declaringType().name();
            }
            return new AlternativeSourceNotificationPanel(comboBoxClassElementArray, psiClass2, this.b, file, (String)object2);
        }
        return null;
    }

    public static boolean isFileProcessed(VirtualFile file) {
        return c.get((UserDataHolder)file) != null;
    }

    public static void setFileProcessed(VirtualFile file, boolean value) {
        c.set((UserDataHolder)file, (Object)(value ? Boolean.TRUE : null));
    }

    static {
        d = lb.a(-7531925428163803476L, -7550278528702833259L, MethodHandles.lookup().lookupClass()).a(78379353539434L);
        long l2 = d ^ 0x4E30CCCD57FBL;
        a = Key.create((String)"AlternativeSource");
        c = Key.create((String)"AlternativeSourceCheckDone");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x59DE433E386FL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/AlternativeSourceNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/AlternativeSourceNotificationProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        private static final long a = lb.a(-7450580269171756307L, 491952594062122108L, MethodHandles.lookup().lookupClass()).a(201785389034395L);

        AlternativeSourceNotificationPanel(ComboBoxClassElement[] alternatives, PsiClass aClass, final Project project2, final VirtualFile file, final String locationDeclName) {
            long l2 = a ^ 0x5AF99A907659L;
            this.setText(DebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{aClass.getQualifiedName()}));
            final ComboBox comboBox = new ComboBox((Object[])alternatives);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e10) {
                    DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
                    final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
                    PsiClass psiClass = ((ComboBoxClassElement)comboBox.getSelectedItem()).a;
                    final VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
                    if (debuggerSession != null && virtualFile != null) {
                        debuggerSession.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() {
                                if (!StringUtil.isEmpty((String)locationDeclName)) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl(locationDeclName, virtualFile.getUrl(), project2);
                                }
                                DebuggerUIUtil.invokeLater(() -> {
                                    FileEditorManager.getInstance((Project)project2).closeFile(file);
                                    debuggerSession.refresh(true);
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)project2).closeFile(file);
                        psiClass.navigate(true);
                    }
                }
            });
            this.myLinksPanel.add((Component)comboBox);
            this.createActionLabel(DebuggerBundle.message((String)"action.disable.text", (Object[])new Object[0]), () -> {
                DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                AlternativeSourceNotificationProvider.setFileProcessed(file, false);
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                FileEditor fileEditor = fileEditorManager.getSelectedEditor(file);
                if (fileEditor != null) {
                    fileEditorManager.removeTopComponent(fileEditor, (JComponent)((Object)this));
                }
            });
        }
    }

    private static class ComboBoxClassElement {
        private final PsiClass a;
        private String b;
        private static final JList c = new JBList();

        ComboBoxClassElement(PsiClass aClass) {
            this.a = aClass;
        }

        public String toString() {
            if (this.b == null) {
                ModuleRendererFactory moduleRendererFactory = ModuleRendererFactory.findInstance((Object)this.a);
                DefaultListCellRenderer defaultListCellRenderer = moduleRendererFactory.getModuleRenderer();
                defaultListCellRenderer.getListCellRendererComponent((JList<?>)c, this.a, 1, false, false);
                this.b = defaultListCellRenderer.getText();
            }
            return this.b;
        }
    }
}

