/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import b.a.lb;
import com.intellij.debugger.memory.action.ActionUtil;
import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.ReferenceType;
import java.lang.invoke.MethodHandles;

public class ShowNewInstancesAction
extends ShowInstancesAction {
    private static final String a = "Show New Instances";
    private static final long d = lb.a(-3343439711834940192L, -1454814497488657669L, MethodHandles.lookup().lookupClass()).a(27770026930600L);

    @Override
    protected boolean isEnabled(AnActionEvent e10) {
        ReferenceType referenceType = ActionUtil.getSelectedClass(e10);
        InstancesProvider instancesProvider = (InstancesProvider)e10.getData(ClassesFilteredView.NEW_INSTANCES_PROVIDER_KEY);
        int n2 = this.getInstancesCount(e10);
        return super.isEnabled(e10) && referenceType != null && instancesProvider != null && n2 > 0;
    }

    @Override
    protected String getLabel() {
        long l2 = d ^ 0x105C88D53334L;
        return a;
    }

    @Override
    protected int getInstancesCount(AnActionEvent e10) {
        ClassesTable.ReferenceCountProvider referenceCountProvider = (ClassesTable.ReferenceCountProvider)e10.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        TypeInfo typeInfo = ActionUtil.getSelectedTypeInfo(e10);
        if (referenceCountProvider == null || typeInfo == null) {
            return -1;
        }
        return referenceCountProvider.getNewInstancesCount(typeInfo);
    }

    @Override
    protected void perform(AnActionEvent e10) {
        XDebugSession xDebugSession;
        Project project2 = e10.getProject();
        ReferenceType referenceType = ActionUtil.getSelectedClass(e10);
        InstancesProvider instancesProvider = (InstancesProvider)e10.getData(ClassesFilteredView.NEW_INSTANCES_PROVIDER_KEY);
        XDebugSession xDebugSession2 = xDebugSession = project2 != null ? XDebuggerManager.getInstance((Project)project2).getCurrentSession() : null;
        if (referenceType != null && instancesProvider != null && xDebugSession != null) {
            new InstancesWindow(xDebugSession, instancesProvider, referenceType.name()).show();
        }
    }
}

