/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import b.a.lb;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.ThreeState;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ObjectReferenceProxyImpl
extends JdiProxy {
    private final ObjectReference c;
    private ReferenceType b;
    private Type d;
    private ThreeState e;
    private static final long n = lb.a(-2522237567286754060L, 5840272707260355253L, MethodHandles.lookup().lookupClass()).a(204631984594132L);

    public ObjectReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, @NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            ObjectReferenceProxyImpl.b(0);
        }
        super(virtualMachineProxy);
        this.e = ThreeState.UNSURE;
        this.c = objectReference;
    }

    public ObjectReference getObjectReference() {
        this.checkValid();
        return this.c;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public ReferenceType referenceType() {
        this.checkValid();
        if (this.b == null) {
            this.b = this.getObjectReference().referenceType();
        }
        return this.b;
    }

    public Type type() {
        this.checkValid();
        if (this.d == null) {
            this.d = this.getObjectReference().type();
        }
        return this.d;
    }

    @NonNls
    public String toString() {
        long l2 = n ^ 0x1368B7885608L;
        ObjectReference objectReference = this.getObjectReference();
        String string = objectReference != null ? objectReference.toString() : "[referenced object collected]";
        return "ObjectReferenceProxyImpl: " + string + " " + super.toString();
    }

    public Map<Field, Value> getValues(List<? extends Field> list2) {
        return this.getObjectReference().getValues(list2);
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.getObjectReference().setValue(field, value);
    }

    public boolean isCollected() {
        this.checkValid();
        if (this.e != ThreeState.YES) {
            try {
                this.e = ThreeState.fromBoolean((boolean)VirtualMachineProxyImpl.isCollected(this.c));
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.e = ThreeState.YES;
            }
        }
        return this.e.toBoolean();
    }

    public long uniqueID() {
        return this.getObjectReference().uniqueID();
    }

    public List<ThreadReferenceProxyImpl> waitingThreads() throws IncompatibleThreadStateException {
        return StreamEx.of(this.getObjectReference().waitingThreads()).map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public ThreadReferenceProxyImpl owningThread() throws IncompatibleThreadStateException {
        return this.getVirtualMachineProxy().getThreadReferenceProxy(this.getObjectReference().owningThread());
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.getObjectReference().entryCount();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ObjectReferenceProxyImpl)) {
            return false;
        }
        if (this == o2) {
            return true;
        }
        return this.c.equals(((ObjectReferenceProxyImpl)o2).c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    @Override
    protected void clearCaches() {
        if (this.e == ThreeState.NO) {
            this.e = ThreeState.UNSURE;
        }
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = n ^ 0x60FEEF6904E0L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/debugger/jdi/ObjectReferenceProxyImpl", "<init>"));
    }
}

