/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import b.a.lb;
import com.intellij.Patches;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodBytecodeUtil {
    private static final Type a;
    private static final long b;

    private MethodBytecodeUtil() {
    }

    public static void visit(Method method, MethodVisitor methodVisitor, boolean withLineNumbers) {
        MethodBytecodeUtil.a(method, method.bytecodes(), methodVisitor, withLineNumbers);
    }

    public static void visit(Method method, long maxOffset, MethodVisitor methodVisitor, boolean withLineNumbers) {
        if (maxOffset > 0L) {
            byte[] byArray;
            byte[] byArray2 = byArray = method.bytecodes();
            if (maxOffset < (long)byArray.length) {
                byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, (int)maxOffset);
            }
            MethodBytecodeUtil.a(method, byArray2, methodVisitor, withLineNumbers);
        }
    }

    public static byte[] getConstantPool(ReferenceType type) {
        long l2 = b ^ 0x184720E1151FL;
        if (Patches.JDK_BUG_ID_6822627) {
            try {
                return type.constantPool();
            }
            catch (NullPointerException nullPointerException) {
                ReflectionUtil.resetField((Object)type, (String)"constantPoolInfoGotten");
                return type.constantPool();
            }
        }
        return type.constantPool();
    }

    private static void a(final Method method, byte[] byArray, final MethodVisitor methodVisitor, boolean bl2) {
        ReferenceType referenceType = method.declaringType();
        byte[] byArray2 = MethodBytecodeUtil.getConstantPool(referenceType);
        try (ByteArrayBuilderOutputStream byteArrayBuilderOutputStream = new ByteArrayBuilderOutputStream(byArray2.length + 24);
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayBuilderOutputStream);){
            ClassType classType;
            ClassType classType2;
            MethodBytecodeUtil.a(dataOutputStream, referenceType.constantPoolCount(), byArray2);
            ClassReader classReader = new ClassReader(byteArrayBuilderOutputStream.getBuffer());
            ClassWriter classWriter = new ClassWriter(classReader, 0);
            String string = null;
            String[] stringArray = null;
            if (referenceType instanceof ClassType) {
                classType2 = (ClassType)referenceType;
                classType = classType2.superclass();
                string = classType != null ? classType.name() : null;
                stringArray = (String[])classType2.interfaces().stream().map(ReferenceType::name).toArray(String[]::new);
            } else if (referenceType instanceof InterfaceType) {
                stringArray = (String[])((InterfaceType)referenceType).superinterfaces().stream().map(ReferenceType::name).toArray(String[]::new);
            }
            classWriter.visit(52, 1, referenceType.name(), referenceType.signature(), string, stringArray);
            classType2 = MethodBytecodeUtil.a(classReader, classWriter);
            if (classType2 != null) {
                classWriter.visitAttribute((Attribute)classType2);
            }
            classType = classWriter.visitMethod(1, method.name(), method.signature(), method.signature(), null);
            classType.visitAttribute(MethodBytecodeUtil.a(classWriter, method, byArray, bl2));
            new ClassReader(classWriter.toByteArray()).accept(new ClassVisitor(458752){

                public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                    assert (name2.equals(method.name()));
                    return methodVisitor;
                }
            }, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static Attribute a(String var0, ThrowableConsumer<DataOutputStream, IOException> var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void a(DataOutputStream dataOutputStream, int n2, byte[] byArray) throws IOException {
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeInt(52);
        dataOutputStream.writeShort(n2);
        dataOutputStream.write(byArray);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
    }

    @Nullable
    private static Attribute a(ClassReader classReader, ClassWriter classWriter) throws IOException {
        int n2;
        long l2 = b ^ 0xB6EB7478FA6L;
        HashSet<Short> hashSet = new HashSet<Short>();
        block4: for (n2 = 1; n2 < classReader.getItemCount(); ++n2) {
            int n3 = classReader.getItem(n2);
            int n4 = classReader.readByte(n3 - 1);
            switch (n4) {
                case 5: 
                case 6: {
                    ++n2;
                    continue block4;
                }
                case 18: {
                    hashSet.add(classReader.readShort(n3));
                    classReader.readShort(n3 + 2);
                }
            }
        }
        if (!hashSet.isEmpty()) {
            n2 = classWriter.newHandle(6, "DummyOwner", "DummyMethod", "", false);
            return MethodBytecodeUtil.a("BootstrapMethods", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dataOutputStream -> {
                dataOutputStream.writeShort(hashSet.size());
                for (int i10 = 0; i10 < hashSet.size(); ++i10) {
                    dataOutputStream.writeShort(n2);
                    dataOutputStream.writeShort(0);
                }
            }));
        }
        return null;
    }

    @NotNull
    private static Attribute a(ClassWriter classWriter, Method method, byte[] byArray, boolean bl2) throws IOException {
        long l2 = b ^ 0x18C7E1246CE2L;
        Attribute attribute = MethodBytecodeUtil.a("Code", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dataOutputStream -> {
            List<Object> list2;
            long l2 = b ^ 0xC0C069493F9L;
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeShort(0);
            List<Object> list3 = list2 = bl2 ? DebuggerUtilsEx.allLineLocations(method) : Collections.emptyList();
            if (!ContainerUtil.isEmpty(list2)) {
                dataOutputStream.writeShort(1);
                dataOutputStream.writeShort(classWriter.newUTF8("LineNumberTable"));
                dataOutputStream.writeInt(2 * list2.size() + 2);
                dataOutputStream.writeShort(list2.size());
                for (Location location : list2) {
                    dataOutputStream.writeShort((short)location.codeIndex());
                    dataOutputStream.writeShort(location.lineNumber());
                }
            } else {
                dataOutputStream.writeShort(0);
            }
        }));
        if (attribute == null) {
            MethodBytecodeUtil.b(1);
        }
        return attribute;
    }

    public static Type getVarInstructionType(int opcode) {
        switch (opcode) {
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
        }
        return a;
    }

    @Nullable
    public static Method getLambdaMethod(ReferenceType clsType, final @NotNull ClassesByNameProvider classesByName) {
        List list2;
        if (classesByName == null) {
            MethodBytecodeUtil.b(2);
        }
        final Ref ref = Ref.create();
        if (DebuggerUtilsEx.isLambdaClassName(clsType.name()) && (list2 = ContainerUtil.filter(clsType.methods(), method -> method.isPublic() && !method.isBridge())).size() == 1) {
            MethodBytecodeUtil.visit((Method)list2.get(0), new MethodVisitor(458752){

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method;
                    ReferenceType referenceType = (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (referenceType != null && (method = DebuggerUtils.findMethod((ReferenceType)referenceType, (String)name2, (String)desc)) != null) {
                        ref.setIfNull((Object)method);
                    }
                }
            }, false);
        }
        return (Method)ref.get();
    }

    @Nullable
    public static Method getBridgeTargetMethod(final Method method, final @NotNull ClassesByNameProvider classesByName) {
        if (classesByName == null) {
            MethodBytecodeUtil.b(3);
        }
        final Ref ref = Ref.create();
        if (method.isBridge()) {
            MethodBytecodeUtil.visit(method, new MethodVisitor(458752){
                private static final long a = lb.a(5693950303413187783L, 6389785095584943879L, MethodHandles.lookup().lookupClass()).a(19082256301300L);

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method2;
                    long l2 = a ^ 0x184A0F90DF68L;
                    if ("java/lang/AbstractMethodError".equals(owner2)) {
                        return;
                    }
                    ReferenceType referenceType = method.declaringType();
                    owner2 = owner2.replace("/", ".");
                    ReferenceType referenceType2 = referenceType.name().equals(owner2) ? referenceType : (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (referenceType2 != null && (method2 = DebuggerUtils.findMethod((ReferenceType)referenceType2, (String)name2, (String)desc)) != null) {
                        ref.setIfNull((Object)method2);
                    }
                }
            }, false);
        }
        return (Method)ref.get();
    }

    public static List<Location> removeSameLineLocations(@NotNull List<Location> locations) {
        if (locations == null) {
            MethodBytecodeUtil.b(4);
        }
        if (locations.size() < 2) {
            return locations;
        }
        MultiMap multiMap = new MultiMap();
        for (Location object : locations) {
            multiMap.putValue((Object)object.method(), (Object)object);
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : multiMap.entrySet()) {
            arrayList.addAll(MethodBytecodeUtil.a((Method)entry.getKey(), (List)entry.getValue()));
        }
        return arrayList;
    }

    private static Collection<Location> a(@NotNull Method method, @NotNull List<Location> list2) {
        int n2;
        if (method == null) {
            MethodBytecodeUtil.b(5);
        }
        if (list2 == null) {
            MethodBytecodeUtil.b(6);
        }
        if ((n2 = list2.size()) < 2) {
            return list2;
        }
        final int n3 = list2.get(0).lineNumber();
        final ArrayList arrayList = new ArrayList(n2);
        MethodBytecodeUtil.visit(method, new MethodVisitor(458752){
            boolean myNewBlock;
            {
                super(x0);
                this.myNewBlock = true;
            }

            public void visitLineNumber(int line, Label start) {
                if (n3 == line) {
                    arrayList.add(this.myNewBlock);
                    this.myNewBlock = false;
                }
            }

            public void visitInsn(int opcode) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    this.myNewBlock = true;
                }
            }

            public void visitJumpInsn(int opcode, Label label) {
                this.myNewBlock = true;
            }
        }, true);
        if (arrayList.size() == n2) {
            list2.sort(Comparator.comparing(Location::codeIndex));
            ArrayList<Location> arrayList2 = new ArrayList<Location>(n2);
            int n4 = 0;
            for (Location location : list2) {
                if (!((Boolean)arrayList.get(n4++)).booleanValue()) continue;
                arrayList2.add(location);
            }
            return arrayList2;
        }
        return list2;
    }

    static {
        b = lb.a(6543669856067322391L, 8150894136611025941L, MethodHandles.lookup().lookupClass()).a(76115935578840L);
        long l2 = b ^ 0x674DD573F068L;
        a = Type.getObjectType((String)"java/lang/Object");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x2E5AABD0DF09L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/MethodBytecodeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/MethodBytecodeUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBridgeTargetMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSameLineLocations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeMethodSameLineLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ByteArrayBuilderOutputStream
    extends ByteArrayOutputStream {
        private static final long a = lb.a(-8330312075139211330L, 4069875222496814470L, MethodHandles.lookup().lookupClass()).a(277774067290561L);

        ByteArrayBuilderOutputStream(int size) {
            super(size);
        }

        byte[] getBuffer() {
            long l2 = a ^ 0xE8DB92B53E9L;
            assert (this.buf.length == this.count) : "Buffer is not fully filled";
            return this.buf;
        }
    }
}

