/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class LocalVariablesUtil {
    private static final Logger e;
    private static final boolean i;
    private static Class<?> d;
    private static Constructor<?> b;
    private static Method h;
    private static Method g;
    private static final boolean c;
    private static Class<?> a;
    private static Constructor<?> j;
    private static Method k;
    private static Method f;
    private static final long l;

    public static Map<DecompiledLocalVariable, Value> fetchValues(@NotNull StackFrameProxyImpl frameProxy, DebugProcess process2, boolean full) throws Exception {
        if (frameProxy == null) {
            LocalVariablesUtil.a(0);
        }
        LinkedHashMap<DecompiledLocalVariable, Value> linkedHashMap = new LinkedHashMap<DecompiledLocalVariable, Value>();
        Location location = frameProxy.location();
        com.sun.jdi.Method method = location.method();
        int n2 = LocalVariablesUtil.a(method);
        MultiMap<Integer, String> multiMap = full ? LocalVariablesUtil.a(new SimpleStackFrameContext(frameProxy, process2), n2) : MultiMap.empty();
        int n3 = LocalVariablesUtil.b(method);
        List<String> list2 = method.argumentTypeNames();
        List<Value> list3 = frameProxy.getArgumentValues();
        for (int i10 = 0; i10 < list3.size(); ++i10) {
            linkedHashMap.put(new DecompiledLocalVariable(n3, true, null, multiMap.get((Object)n3)), list3.get(i10));
            n3 += LocalVariablesUtil.a(list2.get(i10));
        }
        if (!full || !i) {
            return linkedHashMap;
        }
        List<DecompiledLocalVariable> list4 = LocalVariablesUtil.a(frameProxy.getVirtualMachine(), location, multiMap);
        StackFrame stackFrame = frameProxy.getStackFrame();
        for (int i11 = list4.size(); i11 > 0; --i11) {
            try {
                return LocalVariablesUtil.a(linkedHashMap, list4.subList(0, i11), stackFrame);
            }
            catch (Exception exception) {
                e.debug((Throwable)exception);
                continue;
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<DecompiledLocalVariable, Value> a(Map<DecompiledLocalVariable, Value> map2, List<DecompiledLocalVariable> list2, StackFrame stackFrame) throws Exception {
        Object object;
        Object object2;
        long l2 = l ^ 0x2E3FCF32D6C6L;
        Long l3 = (Long)ReflectionUtil.getField(stackFrame.getClass(), (Object)stackFrame, Long.TYPE, (String)"id");
        VirtualMachine virtualMachine = stackFrame.virtualMachine();
        Method method = virtualMachine.getClass().getDeclaredMethod("state", new Class[0]);
        method.setAccessible(true);
        Object object3 = LocalVariablesUtil.a(list2);
        Object object4 = object2 = method.invoke((Object)virtualMachine, new Object[0]);
        synchronized (object4) {
            object = h.invoke(null, virtualMachine, stackFrame.thread(), l3, object3);
        }
        object4 = g.invoke(null, virtualMachine, object);
        Value[] valueArray = (Value[])ReflectionUtil.getField(object4.getClass(), (Object)object4, Value[].class, (String)"values");
        if (list2.size() != valueArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int n2 = 0;
        for (DecompiledLocalVariable decompiledLocalVariable : list2) {
            map2.put(decompiledLocalVariable, valueArray[n2++]);
        }
        return map2;
    }

    public static boolean canSetValues() {
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(StackFrame frame, int slot, Value value) throws EvaluateException {
        long l2 = l ^ 0x7941ADA2A7C6L;
        try {
            Object object;
            Object object2;
            Long l3 = (Long)ReflectionUtil.getField(frame.getClass(), (Object)frame, Long.TYPE, (String)"id");
            VirtualMachine virtualMachine = frame.virtualMachine();
            Method method = virtualMachine.getClass().getDeclaredMethod("state", new Class[0]);
            method.setAccessible(true);
            Object object3 = LocalVariablesUtil.a(slot, value);
            Object object4 = object2 = method.invoke((Object)virtualMachine, new Object[0]);
            synchronized (object4) {
                object = k.invoke(null, virtualMachine, frame.thread(), l3, object3);
            }
            f.invoke(null, virtualMachine, object);
        }
        catch (Exception exception) {
            throw new EvaluateException("Unable to set value", (Throwable)exception);
        }
    }

    private static Object a(int n2, Value value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object object = Array.newInstance(a, 1);
        Array.set(object, 0, j.newInstance(n2, value));
        return object;
    }

    private static Object a(Collection<DecompiledLocalVariable> collection) throws Exception {
        Object object = Array.newInstance(d, collection.size());
        int n2 = 0;
        for (DecompiledLocalVariable decompiledLocalVariable : collection) {
            Object obj = b.newInstance(decompiledLocalVariable.getSlot(), (byte)decompiledLocalVariable.getSignature().charAt(0));
            Array.set(object, n2++, obj);
        }
        return object;
    }

    private static Method a(Class clazz, String string) throws NoSuchMethodException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!string.equals(method.getName())) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(clazz.getName() + "." + string);
    }

    @NotNull
    private static List<DecompiledLocalVariable> a(VirtualMachineProxyImpl virtualMachineProxyImpl, Location location, final MultiMap<Integer, String> multiMap) {
        block14: {
            ArrayList<DecompiledLocalVariable> arrayList;
            HashMap hashMap;
            block15: {
                byte[] byArray;
                com.sun.jdi.Method method;
                block13: {
                    if (!virtualMachineProxyImpl.canGetBytecodes()) {
                        List<DecompiledLocalVariable> list2 = Collections.emptyList();
                        if (list2 == null) {
                            LocalVariablesUtil.a(1);
                        }
                        return list2;
                    }
                    e.assertTrue(location != null);
                    method = location.method();
                    Location location2 = method.location();
                    if (location2 != null && location2.codeIndex() >= 0L) break block13;
                    List<DecompiledLocalVariable> list3 = Collections.emptyList();
                    if (list3 == null) {
                        LocalVariablesUtil.a(2);
                    }
                    return list3;
                }
                long l2 = location.codeIndex();
                if (l2 <= 0L || (byArray = method.bytecodes()) == null || byArray.length <= 0) break block14;
                final int n2 = LocalVariablesUtil.a(method);
                hashMap = new HashMap();
                MethodBytecodeUtil.visit(method, l2, new MethodVisitor(458752){

                    public void visitVarInsn(int opcode, int slot) {
                        if (slot >= n2) {
                            DecompiledLocalVariable decompiledLocalVariable = (DecompiledLocalVariable)hashMap.get(slot);
                            String string = MethodBytecodeUtil.getVarInstructionType(opcode).getDescriptor();
                            if (decompiledLocalVariable == null || !string.equals(decompiledLocalVariable.getSignature())) {
                                decompiledLocalVariable = new DecompiledLocalVariable(slot, false, string, multiMap.get((Object)slot));
                                hashMap.put(slot, decompiledLocalVariable);
                            }
                        }
                    }
                }, false);
                if (!hashMap.isEmpty()) break block15;
                List<DecompiledLocalVariable> list4 = Collections.emptyList();
                if (list4 == null) {
                    LocalVariablesUtil.a(3);
                }
                return list4;
            }
            try {
                ArrayList<DecompiledLocalVariable> arrayList2 = new ArrayList<DecompiledLocalVariable>(hashMap.values());
                arrayList2.sort(Comparator.comparingInt(DecompiledLocalVariable::getSlot));
                arrayList = arrayList2;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                break block14;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (Exception exception) {
                if (virtualMachineProxyImpl.canBeModified()) {
                    e.debug((Throwable)exception);
                    break block14;
                }
                e.warn((Throwable)exception);
            }
            if (arrayList == null) {
                LocalVariablesUtil.a(4);
            }
            return arrayList;
        }
        List<DecompiledLocalVariable> list5 = Collections.emptyList();
        if (list5 == null) {
            LocalVariablesUtil.a(5);
        }
        return list5;
    }

    @NotNull
    private static MultiMap<Integer, String> a(@NotNull StackFrameContext stackFrameContext, int n2) {
        SourcePosition sourcePosition;
        if (stackFrameContext == null) {
            LocalVariablesUtil.a(6);
        }
        if ((sourcePosition = ContextUtil.getSourcePosition(stackFrameContext)) != null) {
            MultiMap multiMap = (MultiMap)ReadAction.compute(() -> {
                PsiElement psiElement = sourcePosition.getElementAt();
                PsiElement psiElement2 = DebuggerUtilsEx.getContainingMethod(psiElement);
                if (psiElement2 != null) {
                    MultiMap multiMap = new MultiMap();
                    int n3 = Math.max(0, n2 - LocalVariablesUtil.a(psiElement2));
                    for (PsiParameter psiParameter : DebuggerUtilsEx.getParameters(psiElement2)) {
                        multiMap.putValue((Object)n3, (Object)psiParameter.getName());
                        n3 += LocalVariablesUtil.a(psiParameter.getType());
                    }
                    PsiElement psiElement3 = DebuggerUtilsEx.getBody(psiElement2);
                    if (psiElement3 != null) {
                        try {
                            psiElement3.accept((PsiElementVisitor)new LocalVariableNameFinder(n2, (MultiMap<Integer, String>)multiMap, psiElement));
                        }
                        catch (Exception exception) {
                            e.info((Throwable)exception);
                        }
                    }
                    return multiMap;
                }
                return MultiMap.empty();
            });
            if (multiMap == null) {
                LocalVariablesUtil.a(7);
            }
            return multiMap;
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            LocalVariablesUtil.a(8);
        }
        return multiMap;
    }

    private static int a(PsiElement psiElement) {
        return Arrays.stream(DebuggerUtilsEx.getParameters(psiElement)).mapToInt(psiParameter -> LocalVariablesUtil.a(psiParameter.getType())).sum();
    }

    private static int a(PsiType psiType) {
        if (PsiType.DOUBLE.equals((Object)psiType) || PsiType.LONG.equals((Object)psiType)) {
            return 2;
        }
        return 1;
    }

    private static int b(com.sun.jdi.Method method) {
        return method.isStatic() ? 0 : 1;
    }

    private static int a(com.sun.jdi.Method method) {
        return LocalVariablesUtil.b(method) + method.argumentTypeNames().stream().mapToInt(LocalVariablesUtil::a).sum();
    }

    private static int a(String string) {
        long l2 = l ^ 0x102100FE670AL;
        if ("double".equals(string) || "long".equals(string)) {
            return 2;
        }
        return 1;
    }

    static {
        Class<?> clazz;
        String string;
        l = lb.a(6932228905270379393L, 7322919667234349419L, MethodHandles.lookup().lookupClass()).a(278427915351263L);
        long l2 = l ^ 0x40384C8126A3L;
        e = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
        boolean bl2 = false;
        try {
            string = "com.sun.tools.jdi.JDWP$StackFrame$GetValues";
            d = Class.forName(string + "$SlotInfo");
            b = d.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            b.setAccessible(true);
            clazz = Class.forName(string);
            h = LocalVariablesUtil.a(clazz, "enqueueCommand");
            g = LocalVariablesUtil.a(clazz, "waitForReply");
            bl2 = true;
        }
        catch (Throwable throwable) {
            e.info(throwable);
        }
        i = bl2;
        bl2 = false;
        try {
            string = "com.sun.tools.jdi.JDWP$StackFrame$SetValues";
            a = Class.forName(string + "$SlotInfo");
            j = a.getDeclaredConstructors()[0];
            j.setAccessible(true);
            clazz = Class.forName(string);
            k = LocalVariablesUtil.a(clazz, "enqueueCommand");
            f = LocalVariablesUtil.a(clazz, "waitForReply");
            bl2 = true;
        }
        catch (Throwable throwable) {
            e.info(throwable);
        }
        c = bl2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x379003BE906L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProxy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/LocalVariablesUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/LocalVariablesUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVariablesFromBytecode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final MultiMap<Integer, String> b;
        private int c;
        private final PsiElement a;
        private final Deque<Integer> d = new LinkedList<Integer>();
        private boolean e = false;
        private static final long f = lb.a(5657993660763520436L, -2915821874702667642L, MethodHandles.lookup().lookupClass()).a(79963150699744L);

        LocalVariableNameFinder(int startSlot, MultiMap<Integer, String> names, PsiElement element) {
            this.b = names;
            this.c = startSlot;
            this.a = element;
        }

        private boolean a(PsiElement psiElement) {
            return !this.e && PsiTreeUtil.isContextAncestor((PsiElement)psiElement, (PsiElement)this.a, (boolean)false);
        }

        public void visitElement(PsiElement element) {
            if (element == this.a) {
                this.e = true;
            } else {
                super.visitElement(element);
            }
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (!this.e) {
                this.a((PsiVariable)variable);
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            long l2 = f ^ 0x5C4F81DE3EA6L;
            if (this.a((PsiElement)statement2)) {
                this.d.push(this.c);
                try {
                    this.a("<monitor>", 1);
                    super.visitSynchronizedStatement(statement2);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        private void a(@Nullable PsiVariable psiVariable) {
            if (psiVariable != null) {
                this.a(psiVariable.getName(), LocalVariablesUtil.a(psiVariable.getType()));
            }
        }

        private void a(String string, int n2) {
            this.b.putValue((Object)this.c, (Object)string);
            this.c += n2;
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.a((PsiElement)block)) {
                this.d.push(this.c);
                try {
                    super.visitCodeBlock(block);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        public void visitForStatement(PsiForStatement statement2) {
            if (this.a((PsiElement)statement2)) {
                this.d.push(this.c);
                try {
                    super.visitForStatement(statement2);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            long l2 = f ^ 0xB7D6558188DL;
            if (this.a((PsiElement)statement2)) {
                this.d.push(this.c);
                try {
                    PsiExpression psiExpression = statement2.getIteratedValue();
                    if (psiExpression != null && psiExpression.getType() instanceof PsiArrayType) {
                        this.a("", 1);
                        this.a("<length>", 1);
                        this.a("<index>", 1);
                    } else {
                        this.a("<iterator>", 1);
                    }
                    this.a((PsiVariable)statement2.getIterationParameter());
                    super.visitForeachStatement(statement2);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        public void visitCatchSection(PsiCatchSection section) {
            if (this.a((PsiElement)section)) {
                this.d.push(this.c);
                try {
                    this.a((PsiVariable)section.getParameter());
                    super.visitCatchSection(section);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            if (this.a((PsiElement)resourceList)) {
                this.d.push(this.c);
                try {
                    super.visitResourceList(resourceList);
                }
                finally {
                    this.c = this.d.pop();
                }
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }
}

