/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;

public class LocalVariableProxyImpl
extends JdiProxy
implements LocalVariableProxy {
    private final StackFrameProxyImpl b;
    private final String e;
    private final String f;
    private LocalVariable d;
    private Type c;

    public LocalVariableProxyImpl(StackFrameProxyImpl frame, LocalVariable variable) {
        super(frame.myTimer);
        this.b = frame;
        this.e = variable.name();
        this.f = variable.typeName();
        this.d = variable;
    }

    @Override
    protected void clearCaches() {
        this.d = null;
        this.c = null;
    }

    public LocalVariable getVariable() throws EvaluateException {
        this.checkValid();
        if (this.d == null) {
            this.d = this.b.visibleVariableByNameInt(this.e);
            if (this.d == null) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
        }
        return this.d;
    }

    public Type getType() throws EvaluateException, ClassNotLoadedException {
        if (this.c == null) {
            this.c = this.getVariable().type();
        }
        return this.c;
    }

    public StackFrameProxyImpl getFrame() {
        return this.b;
    }

    public int hashCode() {
        return 31 * this.b.hashCode() + this.e.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof LocalVariableProxyImpl) {
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)o2;
            return Comparing.equal((Object)localVariableProxyImpl.b, (Object)this.b) && this.e.equals(localVariableProxyImpl.e);
        }
        return false;
    }

    public String name() {
        return this.e;
    }

    public String typeName() {
        return this.f;
    }

    public String toString() {
        return this.e;
    }
}

