/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.Properties;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NonNls;

public class RemoteConnectionBuilder {
    private static final Logger a;
    private final int c;
    private final boolean b;
    private final String d;
    private boolean h;
    private boolean e;
    private boolean f;
    private static final String i = "debugger-agent.jar";
    @NonNls
    private static final String g = "idea.xdebug.key";
    private static final long j;

    public RemoteConnectionBuilder(boolean server, int transport, String address) {
        this.c = transport;
        this.b = server;
        this.d = address;
    }

    public RemoteConnectionBuilder checkValidity(boolean check) {
        this.h = check;
        return this;
    }

    public RemoteConnectionBuilder asyncAgent(boolean useAgent) {
        this.e = useAgent;
        return this;
    }

    public RemoteConnectionBuilder quiet() {
        this.f = true;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public RemoteConnection create(JavaParameters parameters) throws ExecutionException {
        var2_2 = RemoteConnectionBuilder.j ^ 80049949404983L;
        if (this.h) {
            RemoteConnectionBuilder.b(parameters);
        }
        var4_3 = this.c == 0;
        var5_4 = "";
        if (StringUtil.isEmptyOrSpaces((String)this.d)) {
            try {
                var5_4 = DebuggerUtils.getInstance().findAvailableDebugAddress(var4_3);
            }
            catch (ExecutionException var6_5) {
                if (!this.h) ** GOTO lbl14
                throw var6_5;
            }
        } else {
            var5_4 = this.d;
        }
lbl14:
        // 3 sources

        var6_6 = this.b != false && var4_3 != false ? "127.0.0.1:" + var5_4 : var5_4;
        var7_7 = "transport=" + DebugProcessImpl.findConnector(var4_3, this.b).transport().name() + ",address=" + var6_6;
        var7_7 = this.b != false ? var7_7 + ",suspend=y,server=n" : var7_7 + ",suspend=n,server=y";
        if (StringUtil.containsWhitespaces((CharSequence)var7_7)) {
            var7_7 = "\"" + var7_7 + "\"";
        }
        if (this.f) {
            var7_7 = var7_7 + ",quiet=y";
        }
        var8_8 = var7_7;
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.execution.configurations.JavaParameters java.lang.String ), ()V)((RemoteConnectionBuilder)this, (JavaParameters)parameters, (String)var8_8));
        return new RemoteConnection(var4_3, "127.0.0.1", var5_4, this.b);
    }

    private static void b(JavaParameters javaParameters) throws ExecutionException {
        long l2 = j ^ 0x78D99B1EC8E2L;
        Sdk sdk = javaParameters.getJdk();
        if (sdk == null) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
        if (javaSdkVersion == JavaSdkVersion.JDK_1_0 || javaSdkVersion == JavaSdkVersion.JDK_1_1) {
            String string = sdk.getVersionString();
            throw new ExecutionException(DebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{string}));
        }
        if (SystemInfo.isWindows && javaSdkVersion == JavaSdkVersion.JDK_1_2) {
            VirtualFile virtualFile = sdk.getHomeDirectory();
            if (virtualFile == null || !virtualFile.isValid()) {
                String string = sdk.getVersionString();
                throw new ExecutionException(DebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{string}));
            }
            File file = new File(virtualFile.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!file.exists()) {
                GetJPDADialog getJPDADialog = new GetJPDADialog();
                getJPDADialog.show();
                throw new ExecutionException(DebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static void a(JavaParameters javaParameters) {
        long l2 = j ^ 0x33324877353FL;
        if (AsyncStacksUtils.isAgentEnabled()) {
            String string = "-javaagent:";
            ParametersList parametersList = javaParameters.getVMParametersList();
            if (parametersList.getParameters().stream().noneMatch(string2 -> {
                long l2 = j ^ 0x2A2A9404504AL;
                return string2.startsWith(string) && string2.contains(i);
            })) {
                String string3;
                Sdk sdk = javaParameters.getJdk();
                String string4 = string3 = sdk != null ? JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION) : null;
                if (string3 != null) {
                    JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromVersionString((String)string3);
                    if (javaSdkVersion != null && javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                        Object object;
                        File file2 = new File(PathUtil.getJarPathForClass(DebuggerManagerImpl.class));
                        File file3 = file2.isFile() ? new File(file2.getParentFile(), "rt/debugger-agent.jar") : (((File)(object = new File(file2.getParentFile().getParentFile().getParentFile(), "project-artifacts"))).exists() ? new File((File)object, "debugger_agent/debugger-agent.jar") : new File(file2.getParentFile().getParentFile(), "/artifacts/debugger_agent/debugger-agent.jar"));
                        if (file3.exists()) {
                            object = JavaExecutionUtil.handleSpacesInAgentPath((String)file3.getAbsolutePath(), (String)"captureAgent", null, file -> {
                                long l2 = j ^ 0x11D0D6515834L;
                                return i.equals(file.getName());
                            });
                            if (object != null) {
                                parametersList.add(string + (String)object + RemoteConnectionBuilder.a());
                            }
                        } else {
                            a.warn("Capture agent not found: " + file3);
                        }
                    } else {
                        a.warn("Capture agent is not supported for jre " + string3);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a() {
        long l2 = j ^ 0x4212D5A67AB7L;
        Properties properties = CaptureSettingsProvider.getPointsProperties();
        if (properties.isEmpty()) return "";
        try {
            File file = FileUtil.createTempFile((String)"capture", (String)".props");
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                properties.store(fileOutputStream, null);
                String string = "=" + file.toURI().toASCIIString();
                return string;
            }
        }
        catch (IOException iOException) {
            a.error((Throwable)iOException);
        }
        return "";
    }

    private static boolean d(Sdk sdk) {
        long l2 = j ^ 0x7FA697DA12E1L;
        if (SystemInfo.isMac) {
            return false;
        }
        if (sdk == null) {
            return false;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null || StringUtil.compareVersionNumbers((String)string, (String)"1.4") >= 0) {
            return false;
        }
        if (string.startsWith("1.2") && SystemInfo.isWindows) {
            return true;
        }
        if ((string = string + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
            return true;
        }
        if ((string.startsWith("1.3.1_07") || string.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
            return false;
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    private static boolean a(Sdk sdk) {
        String string;
        long l2 = j ^ 0x3164FAE9CD4L;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return sdk != null && (string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (string.startsWith("1.2") || string.startsWith("1.3"));
    }

    private static boolean b(Sdk sdk) {
        long l2 = j ^ 0x2D948C2C1FE4L;
        if (sdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return string == null || string.startsWith("1.4") || string.startsWith("1.3") || string.startsWith("1.2") || string.startsWith("1.1") || string.startsWith("1.0");
    }

    private static boolean c(Sdk sdk) {
        long l2 = j ^ 0x7B2651A6EECFL;
        if (sdk == null) {
            return false;
        }
        String string = JdkUtil.getJdkMainAttribute((Sdk)sdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null) {
            return false;
        }
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    private /* synthetic */ void a(JavaParameters javaParameters, String string) {
        boolean bl2;
        long l2 = j ^ 0x6BD2919BAF1DL;
        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
        if (this.e) {
            RemoteConnectionBuilder.a(javaParameters);
        }
        Sdk sdk = javaParameters.getJdk();
        boolean bl3 = RemoteConnectionBuilder.d(sdk);
        boolean bl4 = RemoteConnectionBuilder.a(sdk);
        String string2 = System.getProperty(g, "-Xdebug");
        boolean bl5 = bl2 = RemoteConnectionBuilder.b(sdk) || !"-Xdebug".equals(string2);
        if (bl3 || bl4 || bl2 || !RemoteConnectionBuilder.c(sdk)) {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + string);
        } else {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
            javaParameters.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + string);
        }
        if (bl4) {
            javaParameters.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
            javaParameters.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
        }
        if (bl2) {
            javaParameters.getVMParametersList().replaceOrPrepend(string2, string2);
        } else {
            javaParameters.getVMParametersList().replaceOrPrepend("-Xdebug", "");
        }
        javaParameters.getVMParametersList().replaceOrPrepend("-classic", bl3 ? "-classic" : "");
    }

    static {
        j = lb.a(-1206849084386207970L, 2258927513471394227L, MethodHandles.lookup().lookupClass()).a(97719073337708L);
        a = Logger.getInstance(RemoteConnectionBuilder.class);
    }
}

