/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class ReloadClassesWorker {
    private static final Logger c;
    private final DebuggerSession a;
    private final HotSwapProgress b;
    private static final long d;

    ReloadClassesWorker(DebuggerSession session, HotSwapProgress progress) {
        this.a = session;
        this.b = progress;
    }

    private DebugProcessImpl a() {
        return this.a.getProcess();
    }

    private void a(Throwable throwable) {
        long l2 = d ^ 0x7D2C7A1D8170L;
        if (throwable.getMessage() != null) {
            this.b.addMessage(this.a, 4, throwable.getMessage());
        }
        if (throwable instanceof ProcessCanceledException) {
            this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
            return;
        }
        if (throwable instanceof UnsupportedOperationException) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[0]));
        } else if (throwable instanceof NoClassDefFoundError) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof VerifyError) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof UnsupportedClassVersionError) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof ClassFormatError) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof ClassCircularityError) {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else {
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{throwable.getClass().getName(), throwable.getLocalizedMessage()}));
        }
    }

    public void reloadClasses(Map<String, HotSwapFile> modifiedClasses) {
        JavaExecutionStack javaExecutionStack;
        Object object;
        long l2 = d ^ 0x28065AE0E404L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (modifiedClasses == null || modifiedClasses.size() == 0) {
            this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
            return;
        }
        DebugProcessImpl debugProcessImpl = this.a();
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
        Project project2 = debugProcessImpl.getProject();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcessImpl);
        StackCapturingLineBreakpoint.deleteAll(debugProcessImpl);
        if (c.isDebugEnabled()) {
            c.debug("Threads before hotswap:\n", new Object[]{StreamEx.of(ThreadDumpAction.buildThreadStates(virtualMachineProxyImpl)).map(ThreadState::getStackTrace).joining((CharSequence)"\n")});
        }
        if (Registry.is((String)"debugger.resume.yourkit.threads")) {
            virtualMachineProxyImpl.allThreads().stream().filter(ThreadReferenceProxyImpl::isResumeOnHotSwap).filter(ThreadReferenceProxyImpl::isSuspended).forEach(threadReferenceProxyImpl -> IntStream.range(0, threadReferenceProxyImpl.getSuspendCount()).forEach(n2 -> threadReferenceProxyImpl.resume()));
        }
        try {
            object = new RedefineProcessor(virtualMachineProxyImpl);
            int n2 = 0;
            for (Map.Entry<String, HotSwapFile> object2 : modifiedClasses.entrySet()) {
                if (debugProcessImpl.isDetached() || debugProcessImpl.isDetaching() || ((RedefineProcessor)object).getProcessedClassesCount() == 0 && this.b.isCancelled()) break;
                ++n2;
                String string = object2.getKey();
                if (string != null) {
                    this.b.setText(string);
                    this.b.setFraction((double)n2 / (double)modifiedClasses.size());
                }
                try {
                    ((RedefineProcessor)object).processClass(string, object2.getValue().file);
                }
                catch (IOException iOException) {
                    this.a(string, iOException);
                }
            }
            if (((RedefineProcessor)object).getProcessedClassesCount() == 0 && this.b.isCancelled()) {
                return;
            }
            ((RedefineProcessor)object).processPending();
            this.b.setFraction(1.0);
            int n3 = ((RedefineProcessor)object).getPartiallyRedefinedClassesCount();
            if (n3 == 0) {
                this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{((RedefineProcessor)object).getProcessedClassesCount()}));
            } else {
                String exception = DebuggerBundle.message((String)"status.classes.not.all.versions.reloaded", (Object[])new Object[]{n3, ((RedefineProcessor)object).getProcessedClassesCount()});
                this.b.addMessage(this.a, 5, exception);
            }
            c.debug("classes reloaded");
        }
        catch (Throwable throwable) {
            this.a(throwable);
        }
        debugProcessImpl.onHotSwapFinished();
        object = this.a.getContextManager().getContext();
        SuspendContextImpl suspendContextImpl = ((DebuggerContextImpl)object).getSuspendContext();
        if (suspendContextImpl != null && (javaExecutionStack = suspendContextImpl.getActiveExecutionStack()) != null) {
            javaExecutionStack.initTopFrame();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        SwingUtilities.invokeLater(() -> {
            long l2 = d ^ 0x5E537A113EEEL;
            try {
                if (!project2.isDisposed()) {
                    breakpointManager.reloadBreakpoints();
                    debugProcessImpl.getRequestsManager().clearWarnings();
                    if (c.isDebugEnabled()) {
                        c.debug("requests updated");
                        c.debug("time stamp set");
                    }
                    this.a.refresh(false);
                    XDebugSession xDebugSession = this.a.getXDebugSession();
                    if (xDebugSession != null) {
                        xDebugSession.rebuildViews();
                    }
                }
            }
            catch (Throwable throwable) {
                c.error(throwable);
            }
            finally {
                semaphore.up();
            }
        });
        semaphore.waitFor();
        if (!project2.isDisposed()) {
            try {
                breakpointManager.enableBreakpoints(debugProcessImpl);
                StackCapturingLineBreakpoint.createAll(debugProcessImpl);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(String string, @Nullable Exception exception) {
        long l2 = d ^ 0x60E5CDF68368L;
        String string2 = null;
        if (exception != null) {
            string2 = exception.getLocalizedMessage();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = DebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        this.b.addMessage(this.a, 4, string + " : " + string2);
    }

    static {
        d = lb.a(3368801235183476308L, -950983626411212190L, MethodHandles.lookup().lookupClass()).a(48709290157818L);
        long l2 = d ^ 0x153C1DBF8B8L;
        c = Logger.getInstance((String)"#com.intellij.debugger.impl.ReloadClassesWorker");
    }

    private static class RedefineProcessor {
        private static final int b = 100;
        private final VirtualMachineProxyImpl c;
        private final Map<ReferenceType, byte[]> d = new HashMap<ReferenceType, byte[]>();
        private int e;
        private int a;

        RedefineProcessor(VirtualMachineProxyImpl virtualMachineProxy) {
            this.c = virtualMachineProxy;
        }

        public void processClass(String qualifiedName, File file) throws Throwable {
            List<ReferenceType> list2 = this.c.classesByName(qualifiedName);
            if (list2.isEmpty()) {
                return;
            }
            byte[] byArray = FileUtil.loadFileBytes((File)file);
            if (list2.size() == 1) {
                this.d.put(list2.get(0), byArray);
                if (this.d.size() >= 100) {
                    this.a();
                }
                return;
            }
            int n2 = 0;
            Throwable throwable = null;
            for (ReferenceType referenceType : list2) {
                try {
                    this.c.redefineClasses(Collections.singletonMap(referenceType, byArray));
                    ++n2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (n2 == 0) {
                throw throwable;
            }
            if (n2 < list2.size()) {
                ++this.a;
            }
            ++this.e;
        }

        private void a() throws Throwable {
            try {
                this.c.redefineClasses(this.d);
                this.e += this.d.size();
            }
            finally {
                this.d.clear();
            }
        }

        public void processPending() throws Throwable {
            if (this.d.size() > 0) {
                this.a();
            }
        }

        public int getProcessedClassesCount() {
            return this.e;
        }

        public int getPartiallyRedefinedClassesCount() {
            return this.a;
        }
    }
}

