/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger g;
    public static final DebuggerContextImpl EMPTY_CONTEXT;
    private boolean e;
    @Nullable
    private final DebuggerSession d;
    private final SuspendContextImpl c;
    private final ThreadReferenceProxyImpl a;
    private StackFrameProxyImpl f;
    private SourcePosition b;
    private PsiElement h;
    private static final long i;

    private DebuggerContextImpl(@Nullable DebuggerSession session, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy, SourcePosition position, PsiElement contextElement, boolean initialized) {
        g.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        this.d = session;
        this.a = threadProxy;
        this.f = frameProxy;
        this.b = position;
        this.c = context;
        this.h = contextElement;
        this.e = initialized;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.d;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.d != null ? this.d.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.a;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.c;
    }

    public Project getProject() {
        return this.d != null ? this.d.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        g.assertTrue(this.e);
        return this.f;
    }

    public SourcePosition getSourcePosition() {
        g.assertTrue(this.e);
        return this.b;
    }

    public PsiElement getContextElement() {
        g.assertTrue(this.e);
        PsiElement psiElement = this.h;
        if (psiElement != null && !psiElement.isValid()) {
            this.h = ContextUtil.getContextElement(this.b);
        }
        return this.h;
    }

    public EvaluationContextImpl createEvaluationContext(Value thisObject) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), thisObject);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl suspendContextImpl = this.getSuspendContext();
        return suspendContextImpl != null ? new EvaluationContextImpl(suspendContextImpl, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession session, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy) {
        g.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(session, context, threadProxy, frameProxy, null, null, context == null);
        if (debuggerContextImpl == null) {
            DebuggerContextImpl.a(0);
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.e) {
            return;
        }
        this.e = true;
        if (this.f == null && this.a != null) {
            try {
                this.f = this.a.frameCount() > 0 ? this.a.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.f != null) {
            if (this.b == null) {
                this.b = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.h = ContextUtil.getContextElement(this.b);
        }
    }

    public void setPositionCache(SourcePosition position) {
        this.b = position;
    }

    public boolean isInitialised() {
        return this.e;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess();
        return debugProcessImpl != null && debugProcessImpl.isEvaluationPossible();
    }

    static {
        i = lb.a(-3488318940047524005L, -3284314185468243225L, MethodHandles.lookup().lookupClass()).a(8651408717085L);
        long l2 = i ^ 0x1B7AFA7BD25L;
        g = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
        EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = i ^ 0x3A9ED6E0D692L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
    }
}

