/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.io.StreamUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClassLoadingUtils {
    private static final int a = 4096;
    private static final long b = lb.a(-549700502504427158L, -5108281038980545890L, MethodHandles.lookup().lookupClass()).a(28918831434862L);

    private ClassLoadingUtils() {
    }

    public static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process2) throws EvaluateException {
        long l2 = b ^ 0x1933792C8B1AL;
        try {
            ArrayType arrayType = (ArrayType)context.getDebugProcess().findClass(context, "java.net.URL[]", context.getClassLoader());
            ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray(arrayType, 0, context);
            ClassType classType = (ClassType)process2.findClass(context, "java.net.URLClassLoader", context.getClassLoader());
            Method method = classType.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
            ClassLoaderReference classLoaderReference = (ClassLoaderReference)process2.newInstance(context, classType, method, Arrays.asList(arrayReference, context.getClassLoader()));
            context.keep((Value)classLoaderReference);
            return classLoaderReference;
        }
        catch (Exception exception) {
            throw new EvaluateException("Error creating evaluation class loader: " + exception, (Throwable)exception);
        }
    }

    public static void defineClass(String name2, byte[] bytes, EvaluationContext context, DebugProcess process2, ClassLoaderReference classLoader) throws EvaluateException {
        long l2 = b ^ 0x67477B66D4BFL;
        try {
            VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
            Method method = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            process2.invokeMethod(context, (ObjectReference)classLoader, method, Arrays.asList(DebuggerUtilsEx.mirrorOfString(name2, virtualMachineProxyImpl, context), ClassLoadingUtils.a(bytes, context, process2), virtualMachineProxyImpl.mirrorOf(0), virtualMachineProxyImpl.mirrorOf(bytes.length)));
        }
        catch (Exception exception) {
            throw new EvaluateException("Error during class " + name2 + " definition: " + exception, (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ClassType getHelperClass(Class cls, EvaluationContext evaluationContext) throws EvaluateException {
        long l2 = b ^ 0x657AA7B09D15L;
        String string = cls.getName();
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        try {
            return (ClassType)debugProcess.findClass(evaluationContext, string, evaluationContext.getClassLoader());
        }
        catch (EvaluateException evaluateException) {
            Throwable throwable = evaluateException.getCause();
            if (!(throwable instanceof InvocationException)) throw evaluateException;
            if (!"java.lang.ClassNotFoundException".equals(((InvocationException)throwable).exception().type().name())) throw evaluateException;
            ClassLoaderReference classLoaderReference = ClassLoadingUtils.getClassLoader(evaluationContext, debugProcess);
            try (InputStream inputStream = cls.getResourceAsStream("/" + string.replaceAll("[.]", "/") + ".class");){
                if (inputStream == null) {
                    ClassType classType = null;
                    return classType;
                }
                ClassLoadingUtils.defineClass(string, StreamUtil.loadFromStream((InputStream)inputStream), evaluationContext, debugProcess, classLoaderReference);
                ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoaderReference);
                ClassType classType = (ClassType)debugProcess.findClass(evaluationContext, string, classLoaderReference);
                return classType;
            }
            catch (IOException iOException) {
                throw new EvaluateException("Unable to read " + string + " class bytes", (Throwable)iOException);
            }
        }
    }

    private static ArrayReference a(byte[] byArray, EvaluationContext evaluationContext, DebugProcess debugProcess) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        long l2 = b ^ 0x69F5C77A920AL;
        ArrayType arrayType = (ArrayType)debugProcess.findClass(evaluationContext, "byte[]", evaluationContext.getClassLoader());
        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray(arrayType, byArray.length, evaluationContext);
        ArrayList<ByteValue> arrayList = new ArrayList<ByteValue>(byArray.length);
        for (byte by2 : byArray) {
            arrayList.add(((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(by2));
        }
        if (DebuggerUtils.isAndroidVM((VirtualMachine)arrayType.virtualMachine())) {
            ClassLoadingUtils.a(arrayReference, arrayList);
        } else {
            arrayReference.setValues(arrayList);
        }
        return arrayReference;
    }

    private static void a(ArrayReference arrayReference, List<? extends Value> list2) throws ClassNotLoadedException, InvalidTypeException {
        int n2;
        for (int i10 = 0; i10 < list2.size(); i10 += n2) {
            n2 = Math.min(4096, list2.size() - i10);
            arrayReference.setValues(i10, list2, i10, n2);
        }
    }
}

