/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RequestManagerImpl
extends DebugProcessAdapterImpl
implements RequestManager {
    private static final Logger g;
    private static final Key b;
    private static final Key<Requestor> c;
    private final DebugProcessImpl d;
    private final Map<Requestor, String> h = new HashMap<Requestor, String>();
    private final Map<Requestor, Set<EventRequest>> e = new HashMap<Requestor, Set<EventRequest>>();
    private EventRequestManager f;
    @Nullable
    private ThreadReference a;
    private static final long j;

    public RequestManagerImpl(DebugProcessImpl debugProcess) {
        this.d = debugProcess;
        this.d.addDebugProcessListener(this);
    }

    public EventRequestManager getVMRequestManager() {
        return this.f;
    }

    @Nullable
    public ThreadReference getFilterThread() {
        return this.a;
    }

    public void setFilterThread(@Nullable ThreadReference filterThread) {
        this.a = filterThread;
    }

    public Set<EventRequest> findRequests(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set<EventRequest> set = this.e.get(requestor);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Nullable
    public static Requestor findRequestor(EventRequest request) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return request != null ? (Requestor)request.getProperty(c) : null;
    }

    private static void b(EventRequest eventRequest, String string) {
        if (eventRequest instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof ExceptionRequest) {
            ((ExceptionRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof MethodEntryRequest) {
            ((MethodEntryRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof MethodExitRequest) {
            ((MethodExitRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof WatchpointRequest) {
            ((WatchpointRequest)eventRequest).addClassFilter(string);
        }
    }

    private static void a(EventRequest eventRequest, String string) {
        if (eventRequest instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof ExceptionRequest) {
            ((ExceptionRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof MethodEntryRequest) {
            ((MethodEntryRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof MethodExitRequest) {
            ((MethodExitRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof WatchpointRequest) {
            ((WatchpointRequest)eventRequest).addClassExclusionFilter(string);
        }
    }

    private void a(FilteredRequestor filteredRequestor, EventRequest eventRequest) {
        long l2 = j ^ 0x793FA310E34AL;
        if ("SuspendAll".equals(filteredRequestor.getSuspendPolicy())) {
            eventRequest.setSuspendPolicy(2);
        } else {
            eventRequest.setSuspendPolicy(1);
        }
        if (filteredRequestor.isCountFilterEnabled() && !filteredRequestor.isConditionEnabled()) {
            eventRequest.addCountFilter(filteredRequestor.getCountFilter());
        }
        if (filteredRequestor.isClassFiltersEnabled() && !(eventRequest instanceof BreakpointRequest)) {
            ClassFilter[] classFilterArray = filteredRequestor.getClassFilters();
            if (DebuggerUtilsEx.getEnabledNumber(classFilterArray) == 1) {
                for (ClassFilter classFilter : classFilterArray) {
                    if (!classFilter.isEnabled()) continue;
                    JVMName jVMName = (JVMName)ReadAction.compute(() -> {
                        PsiClass psiClass = DebuggerUtils.findClass((String)classFilter.getPattern(), (Project)this.d.getProject(), (GlobalSearchScope)this.d.getSearchScope());
                        if (psiClass == null) {
                            return null;
                        }
                        return JVMNameUtil.getJVMQualifiedName(psiClass);
                    });
                    String string = classFilter.getPattern();
                    try {
                        if (jVMName != null) {
                            string = jVMName.getName(this.d);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        // empty catch block
                    }
                    RequestManagerImpl.b(eventRequest, string);
                    break;
                }
            }
            for (ClassFilter classFilter : filteredRequestor.getClassExclusionFilters()) {
                if (!classFilter.isEnabled()) continue;
                RequestManagerImpl.a(eventRequest, classFilter.getPattern());
            }
        }
        this.registerRequestInternal(filteredRequestor, eventRequest);
    }

    public void registerRequestInternal(Requestor requestor, EventRequest request) {
        this.registerRequest(requestor, request);
        request.putProperty(c, requestor);
    }

    public void registerRequest(Requestor requestor2, EventRequest request) {
        this.e.computeIfAbsent(requestor2, requestor -> new HashSet()).add(request);
    }

    @Nullable
    public ClassPrepareRequest createClassPrepareRequest(ClassPrepareRequestor requestor, String pattern) {
        if (this.f == null) {
            return null;
        }
        ClassPrepareRequest classPrepareRequest = this.f.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(1);
        if (!StringUtil.isEmpty((String)pattern)) {
            classPrepareRequest.addClassFilter(pattern);
            classPrepareRequest.putProperty(b, pattern);
        }
        this.registerRequestInternal((Requestor)requestor, classPrepareRequest);
        return classPrepareRequest;
    }

    public ExceptionRequest createExceptionRequest(FilteredRequestor requestor, ReferenceType referenceType, boolean notifyCaught, boolean notifyUnCaught) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ExceptionRequest exceptionRequest = this.f.createExceptionRequest(referenceType, notifyCaught, notifyUnCaught);
        this.a(requestor, exceptionRequest);
        return exceptionRequest;
    }

    public MethodEntryRequest createMethodEntryRequest(FilteredRequestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodEntryRequest methodEntryRequest = this.f.createMethodEntryRequest();
        this.a(requestor, methodEntryRequest);
        return methodEntryRequest;
    }

    public MethodExitRequest createMethodExitRequest(FilteredRequestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodExitRequest methodExitRequest = this.f.createMethodExitRequest();
        this.a(requestor, methodExitRequest);
        return methodExitRequest;
    }

    public BreakpointRequest createBreakpointRequest(FilteredRequestor requestor, Location location) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        BreakpointRequest breakpointRequest = this.f.createBreakpointRequest(location);
        this.a(requestor, breakpointRequest);
        this.h.remove(requestor);
        return breakpointRequest;
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(FilteredRequestor requestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        AccessWatchpointRequest accessWatchpointRequest = this.f.createAccessWatchpointRequest(field);
        this.a(requestor, accessWatchpointRequest);
        return accessWatchpointRequest;
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(FilteredRequestor requestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ModificationWatchpointRequest modificationWatchpointRequest = this.f.createModificationWatchpointRequest(field);
        this.a(requestor, modificationWatchpointRequest);
        return modificationWatchpointRequest;
    }

    public void deleteRequest(Requestor requestor) {
        long l2 = j ^ 0xF3F3C251D22L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.h.remove(requestor);
        if (!this.d.isAttached()) {
            return;
        }
        Set<EventRequest> set = this.e.remove(requestor);
        if (set == null) {
            return;
        }
        for (EventRequest eventRequest : set) {
            try {
                Set<EventRequest> set2;
                Requestor requestor2 = (Requestor)eventRequest.getProperty(c);
                if (requestor2 != requestor && (set2 = this.e.get(requestor2)) != null) {
                    set2.remove(eventRequest);
                    if (set2.isEmpty()) {
                        this.e.remove(requestor2);
                    }
                }
                try {
                    this.f.deleteEventRequest(eventRequest);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    g.error("Exception in EventRequestManager.deleteEventRequest", (Throwable)arrayIndexOutOfBoundsException, new String[]{ThreadDumper.dumpThreadsToString()});
                }
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 41) continue;
                g.info((Throwable)internalException);
            }
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor, SourcePosition classPosition) {
        long l2 = j ^ 0x1127B49F952L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.checkReadOnly((Requestor)requestor)) {
            return;
        }
        List<ClassPrepareRequest> list2 = this.d.getPositionManager().createPrepareRequests(requestor, classPosition);
        if (list2.isEmpty()) {
            this.setInvalid((Requestor)requestor, DebuggerBundle.message((String)"status.invalid.breakpoint.out.of.class", (Object[])new Object[0]));
            return;
        }
        for (ClassPrepareRequest classPrepareRequest : list2) {
            if (classPrepareRequest == null) continue;
            this.registerRequest((Requestor)requestor, classPrepareRequest);
            classPrepareRequest.enable();
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor, String classOrPatternToBeLoaded) {
        long l2 = j ^ 0xC28C6519C50L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.checkReadOnly((Requestor)requestor)) {
            return;
        }
        ClassPrepareRequest classPrepareRequest = this.createClassPrepareRequest(requestor, classOrPatternToBeLoaded);
        if (classPrepareRequest != null) {
            this.registerRequest((Requestor)requestor, classPrepareRequest);
            classPrepareRequest.enable();
            if (g.isDebugEnabled()) {
                g.debug("classOrPatternToBeLoaded = " + classOrPatternToBeLoaded);
            }
        }
    }

    public void enableRequest(EventRequest request) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        g.assertTrue(RequestManagerImpl.findRequestor(request) != null);
        try {
            ThreadReference threadReference = this.a;
            if (threadReference != null) {
                if (request instanceof BreakpointRequest) {
                    ((BreakpointRequest)request).addThreadFilter(threadReference);
                } else if (request instanceof MethodEntryRequest) {
                    ((MethodEntryRequest)request).addThreadFilter(threadReference);
                } else if (request instanceof MethodExitRequest) {
                    ((MethodExitRequest)request).addThreadFilter(threadReference);
                }
            }
            request.enable();
        }
        catch (InternalException internalException) {
            switch (internalException.errorCode()) {
                case 40: {
                    g.info((Throwable)internalException);
                    break;
                }
                case 41: {
                    break;
                }
                default: {
                    g.error((Throwable)internalException);
                }
            }
        }
    }

    public void setInvalid(Requestor requestor, String message) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isVerified(requestor)) {
            this.h.put(requestor, message);
        }
    }

    @Nullable
    public String getWarning(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.h.get(requestor);
    }

    public boolean isVerified(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.findRequests(requestor).stream().anyMatch(eventRequest -> !(eventRequest instanceof ClassPrepareRequest));
    }

    @Override
    public void processDetached(DebugProcessImpl process2, boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.f = null;
        this.h.clear();
        this.e.clear();
    }

    @Override
    public void processAttached(DebugProcessImpl process2) {
        if (this.d.getVirtualMachineProxy().canBeModified()) {
            this.f = this.d.getVirtualMachineProxy().eventRequestManager();
        }
    }

    public void processClassPrepared(ClassPrepareEvent event) {
        long l2 = j ^ 0x361794ADE775L;
        if (!this.d.isAttached()) {
            return;
        }
        ReferenceType referenceType = event.referenceType();
        if (referenceType instanceof ClassType || referenceType instanceof InterfaceType) {
            ClassPrepareRequestor classPrepareRequestor;
            if (g.isDebugEnabled()) {
                g.debug("signature = " + referenceType.signature());
            }
            if ((classPrepareRequestor = (ClassPrepareRequestor)event.request().getProperty(c)) != null) {
                if (g.isDebugEnabled()) {
                    g.debug("requestor found " + referenceType.signature());
                }
                classPrepareRequestor.processClassPrepare((DebugProcess)this.d, referenceType);
            }
        }
    }

    public void clearWarnings() {
        this.h.clear();
    }

    public boolean checkReadOnly(Requestor requestor) {
        long l2 = j ^ 0xFDD425133ADL;
        if (!this.d.getVirtualMachineProxy().canBeModified()) {
            this.setInvalid(requestor, "Not available in read only mode");
            return true;
        }
        return false;
    }

    static {
        j = lb.a(-7714614388577892866L, 5793010321892062203L, MethodHandles.lookup().lookupClass()).a(44216164727861L);
        long l2 = j ^ 0x6776DF15B51EL;
        g = Logger.getInstance((String)"#com.intellij.debugger.RequestManagerImpl");
        b = Key.create((String)"ClassName");
        c = Key.create((String)"Requestor");
    }
}

