/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import b.a.lb;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThrowEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TryEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.a;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl a;
    private static final long b;

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return a;
    }

    public static ExpressionEvaluator build(TextWithImports text2, @Nullable PsiElement contextElement, @Nullable SourcePosition position, @NotNull Project project2) throws EvaluateException {
        CodeFragmentFactory codeFragmentFactory;
        JavaCodeFragment javaCodeFragment;
        long l2 = b ^ 0x50A9E1614F03L;
        if (project2 == null) {
            EvaluatorBuilderImpl.a(0);
        }
        if ((javaCodeFragment = (codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, contextElement)).createCodeFragment(text2, contextElement, project2)) == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{text2.getText()}));
        }
        DebuggerUtils.checkSyntax((PsiCodeFragment)javaCodeFragment);
        return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, position);
    }

    public ExpressionEvaluator build(PsiElement codeFragment, SourcePosition position) throws EvaluateException {
        return new Builder(position, null).buildElement(codeFragment);
    }

    private static void a(PsiParameter[] psiParameterArray, PsiExpression[] psiExpressionArray, PsiSubstitutor psiSubstitutor, Evaluator[] evaluatorArray) {
        if (psiParameterArray.length > 0) {
            int n2 = Math.max(psiParameterArray.length, psiExpressionArray.length);
            PsiType psiType = null;
            for (int i10 = 0; i10 < n2 && i10 < psiExpressionArray.length; ++i10) {
                PsiType psiType2;
                PsiType psiType3;
                if (i10 < psiParameterArray.length) {
                    psiType3 = psiSubstitutor.substitute(psiParameterArray[i10].getType());
                    if (psiType3 instanceof PsiEllipsisType) {
                        psiType3 = psiType = ((PsiEllipsisType)psiType3).getComponentType();
                    }
                } else {
                    if (psiType == null) break;
                    psiType3 = psiType;
                }
                if (!TypeConversionUtil.boxingConversionApplicable((PsiType)psiType3, (PsiType)(psiType2 = psiExpressionArray[i10].getType()))) continue;
                Evaluator evaluator = evaluatorArray[i10];
                evaluatorArray[i10] = psiType3 instanceof PsiPrimitiveType ? new UnBoxingEvaluator(evaluator) : new BoxingEvaluator(evaluator);
            }
        }
    }

    static {
        b = lb.a(-8649988051236838678L, -3479037747012988210L, MethodHandles.lookup().lookupClass()).a(220866374800276L);
        a = new EvaluatorBuilderImpl();
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = b ^ 0x9A3D38DA5BCL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl", "build"));
    }

    private static class Builder
    extends JavaElementVisitor {
        private static final Logger a;
        private Evaluator g = null;
        private PsiClass e;
        private CodeFragmentEvaluator f;
        private final Set<JavaCodeFragment> d = new HashSet<JavaCodeFragment>();
        @Nullable
        private final SourcePosition c;
        @Nullable
        private final PsiClass b;
        private static final long h;

        private Builder(@Nullable SourcePosition position) {
            this.c = position;
            this.b = JVMNameUtil.getClassAt(this.c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitCodeFragment(JavaCodeFragment codeFragment) {
            this.d.add(codeFragment);
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                for (PsiElement psiElement = codeFragment.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
                    psiElement.accept((PsiElementVisitor)this);
                    if (this.g != null) {
                        arrayList.add(this.g);
                    }
                    this.g = null;
                }
                this.f.setStatements(arrayList.toArray(new Evaluator[0]));
                this.g = this.f;
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            Builder.a((PsiElement)element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            long l2 = h ^ 0x42E89D0985E0L;
            PsiExpression psiExpression = expression.getRExpression();
            if (psiExpression == null) {
                Builder.a((PsiElement)expression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            PsiExpression psiExpression2 = expression.getLExpression();
            PsiType psiType = psiExpression2.getType();
            if (psiType == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression2.getText()}));
            }
            IElementType iElementType = expression.getOperationTokenType();
            PsiType psiType2 = psiExpression.getType();
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType, (PsiExpression)psiExpression) && psiType2 != null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{expression.getOperationSign().getText()}));
            }
            psiExpression2.accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.g;
            evaluator = Builder.a(psiType, psiType2, evaluator);
            if (iElementType != JavaTokenType.EQ) {
                IElementType iElementType2 = TypeConversionUtil.convertEQtoOperation((IElementType)iElementType);
                PsiType psiType3 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType, (PsiType)psiType2, (IElementType)iElementType2, (boolean)true);
                if (psiType3 == null || psiType2 == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
                }
                evaluator = Builder.a(evaluator2, psiType, evaluator, psiType2, iElementType2, psiType3);
            }
            this.g = new AssignmentEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, PsiType psiType2, Evaluator evaluator) {
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            if (psiPrimitiveType != null) {
                if (psiType2 instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)psiType2)) {
                    if (!psiType2.equals(psiPrimitiveType)) {
                        evaluator = new TypeCastEvaluator(evaluator, psiPrimitiveType.getCanonicalText(), true);
                    }
                    evaluator = new BoxingEvaluator(evaluator);
                }
            } else if (psiType instanceof PsiPrimitiveType) {
                PsiPrimitiveType psiPrimitiveType2;
                PsiPrimitiveType psiPrimitiveType3;
                if (psiType2 instanceof PsiClassType) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
                Object object = psiPrimitiveType3 = (psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2)) != null ? psiPrimitiveType2 : psiType2;
                if (psiPrimitiveType3 instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)psiPrimitiveType3) && !psiType.equals(psiPrimitiveType3)) {
                    evaluator = new TypeCastEvaluator(evaluator, psiType.getCanonicalText(), true);
                }
            }
            return evaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitTryStatement(PsiTryStatement statement2) {
            long l2 = h ^ 0x4EFF9C8D9720L;
            if (statement2.getResourceList() != null) {
                throw new EvaluateRuntimeException(new UnsupportedExpressionException("Try with resources is not yet supported"));
            }
            Evaluator evaluator = this.c((PsiElement)statement2.getTryBlock());
            if (evaluator != null) {
                PsiCatchSection[] psiCatchSectionArray = statement2.getCatchSections();
                ArrayList<CatchEvaluator> arrayList = new ArrayList<CatchEvaluator>();
                for (PsiCatchSection psiCatchSection : psiCatchSectionArray) {
                    PsiParameter psiParameter = psiCatchSection.getParameter();
                    PsiCodeBlock psiCodeBlock = psiCatchSection.getCatchBlock();
                    if (psiParameter == null || psiCodeBlock == null) continue;
                    CodeFragmentEvaluator codeFragmentEvaluator = this.b();
                    try {
                        this.f.setInitialValue(psiParameter.getName(), null);
                        this.f.setStatements(this.a(psiCodeBlock.getStatements()));
                        PsiType psiType = psiParameter.getType();
                        List list2 = psiType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)psiType).getDisjunctions() : Collections.singletonList(psiType);
                        for (PsiType psiType2 : list2) {
                            arrayList.add(new CatchEvaluator(psiType2.getCanonicalText(), psiParameter.getName(), this.f));
                        }
                    }
                    finally {
                        this.f = codeFragmentEvaluator;
                    }
                }
                this.g = new TryEvaluator(evaluator, arrayList, this.c((PsiElement)statement2.getFinallyBlock()));
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            Evaluator evaluator = this.c((PsiElement)statement2.getException());
            if (evaluator != null) {
                this.g = new ThrowEvaluator(evaluator);
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            this.g = new ReturnEvaluator(this.c((PsiElement)statement2.getReturnValue()));
        }

        public void visitStatement(PsiStatement statement2) {
            long l2 = h ^ 0x6F4887BF4A80L;
            Builder.a(DebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement2.getText()}));
        }

        private CodeFragmentEvaluator b() {
            CodeFragmentEvaluator codeFragmentEvaluator = this.f;
            this.f = new CodeFragmentEvaluator(this.f);
            return codeFragmentEvaluator;
        }

        private Evaluator[] a(PsiStatement[] psiStatementArray) {
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            for (PsiStatement psiStatement : psiStatementArray) {
                psiStatement.accept((PsiElementVisitor)this);
                if (this.g != null) {
                    arrayList.add(DisableGC.create(this.g));
                }
                this.g = null;
            }
            return arrayList.toArray(new Evaluator[0]);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                this.g = new BlockStatementEvaluator(this.a(block.getStatements()));
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        public void visitBlockStatement(PsiBlockStatement statement2) {
            this.visitCodeBlock(statement2.getCodeBlock());
        }

        public void visitLabeledStatement(PsiLabeledStatement labeledStatement) {
            PsiStatement psiStatement = labeledStatement.getStatement();
            if (psiStatement != null) {
                psiStatement.accept((PsiElementVisitor)this);
            }
        }

        private static String b(PsiElement psiElement) {
            String string = null;
            if (psiElement.getParent() instanceof PsiLabeledStatement) {
                string = ((PsiLabeledStatement)psiElement.getParent()).getName();
            }
            return string;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            Evaluator evaluator = this.c((PsiElement)statement2.getBody());
            Evaluator evaluator2 = this.c((PsiElement)statement2.getCondition());
            if (evaluator2 != null) {
                this.g = new DoWhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.b((PsiElement)statement2));
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            Evaluator evaluator = this.c((PsiElement)statement2.getBody());
            Evaluator evaluator2 = this.c((PsiElement)statement2.getCondition());
            if (evaluator2 != null) {
                this.g = new WhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.b((PsiElement)statement2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForStatement(PsiForStatement statement2) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                Evaluator evaluator = this.c((PsiElement)statement2.getInitialization());
                Evaluator evaluator2 = this.c((PsiElement)statement2.getCondition());
                if (evaluator2 != null) {
                    evaluator2 = new UnBoxingEvaluator(evaluator2);
                }
                Evaluator evaluator3 = this.c((PsiElement)statement2.getUpdate());
                Evaluator evaluator4 = this.c((PsiElement)statement2.getBody());
                if (evaluator4 != null) {
                    this.g = new ForStatementEvaluator(evaluator, evaluator2, evaluator3, evaluator4, Builder.b((PsiElement)statement2));
                }
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForeachStatement(PsiForeachStatement statement2) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                String string = statement2.getIterationParameter().getName();
                this.f.setInitialValue(string, null);
                SyntheticVariableEvaluator syntheticVariableEvaluator = new SyntheticVariableEvaluator(this.f, string);
                Evaluator evaluator = this.c((PsiElement)statement2.getIteratedValue());
                Evaluator evaluator2 = this.c((PsiElement)statement2.getBody());
                if (evaluator2 != null) {
                    this.g = new ForeachStatementEvaluator(syntheticVariableEvaluator, evaluator, evaluator2, Builder.b((PsiElement)statement2));
                }
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        @Nullable
        private Evaluator c(@Nullable PsiElement psiElement) {
            if (psiElement == null || psiElement instanceof PsiEmptyStatement) {
                return null;
            }
            psiElement.accept((PsiElementVisitor)this);
            return this.g;
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiExpression psiExpression;
            PsiStatement psiStatement = statement2.getThenBranch();
            if (psiStatement == null) {
                return;
            }
            psiStatement.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            PsiStatement psiStatement2 = statement2.getElseBranch();
            Evaluator evaluator2 = null;
            if (psiStatement2 != null) {
                psiStatement2.accept((PsiElementVisitor)this);
                evaluator2 = this.g;
            }
            if ((psiExpression = statement2.getCondition()) == null) {
                return;
            }
            psiExpression.accept((PsiElementVisitor)this);
            this.g = new IfStatementEvaluator(new UnBoxingEvaluator(this.g), evaluator, evaluator2);
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            PsiIdentifier psiIdentifier = statement2.getLabelIdentifier();
            this.g = BreakContinueStatementEvaluator.createBreakEvaluator(psiIdentifier != null ? psiIdentifier.getText() : null);
        }

        public void visitContinueStatement(PsiContinueStatement statement2) {
            PsiIdentifier psiIdentifier = statement2.getLabelIdentifier();
            this.g = BreakContinueStatementEvaluator.createContinueEvaluator(psiIdentifier != null ? psiIdentifier.getText() : null);
        }

        public void visitExpressionStatement(PsiExpressionStatement statement2) {
            statement2.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression expression) {
            long l2 = h ^ 0x7DDC8706B531L;
            if (a.isDebugEnabled()) {
                a.debug("visitExpression " + expression);
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression wideExpression) {
            long l2 = h ^ 0x75EDE8CCD013L;
            if (a.isDebugEnabled()) {
                a.debug("visitPolyadicExpression " + wideExpression);
            }
            PsiExpression[] psiExpressionArray = wideExpression.getOperands();
            psiExpressionArray[0].accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            PsiType psiType = psiExpressionArray[0].getType();
            for (int i10 = 1; i10 < psiExpressionArray.length; ++i10) {
                PsiType psiType2;
                PsiExpression psiExpression = psiExpressionArray[i10];
                if (psiExpression == null) {
                    Builder.a((PsiElement)wideExpression);
                }
                psiExpression.accept((PsiElementVisitor)this);
                Evaluator evaluator2 = this.g;
                IElementType iElementType = wideExpression.getOperationTokenType();
                PsiType psiType3 = psiExpression.getType();
                if (psiType3 == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression.getText()}));
                }
                if ((psiType2 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType, (PsiType)psiType3, (IElementType)iElementType, (boolean)true)) == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{wideExpression.getText()}));
                }
                this.g = Builder.a(evaluator, psiType, evaluator2, psiType3, iElementType, psiType2);
                psiType = psiType2;
                evaluator = this.g;
            }
        }

        private static Evaluator a(Evaluator evaluator, PsiType psiType, Evaluator evaluator2, @NotNull PsiType psiType2, @NotNull IElementType iElementType, @NotNull PsiType psiType3) {
            if (psiType2 == null) {
                Builder.a(0);
            }
            if (iElementType == null) {
                Builder.a(1);
            }
            if (psiType3 == null) {
                Builder.a(2);
            }
            if (Builder.b(psiType, psiType2, iElementType)) {
                if (psiType2 instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(psiType2.getCanonicalText())) {
                    evaluator2 = new UnBoxingEvaluator(evaluator2);
                }
                if (psiType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(psiType.getCanonicalText())) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
            }
            if (Builder.a(psiType, psiType2, iElementType)) {
                PsiType psiType4 = psiType;
                PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
                if (psiPrimitiveType != null) {
                    psiType4 = psiPrimitiveType;
                }
                PsiType psiType5 = psiType2;
                PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
                if (psiPrimitiveType2 != null) {
                    psiType5 = psiPrimitiveType2;
                }
                if (PsiType.DOUBLE.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.DOUBLE)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.DOUBLE.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.DOUBLE)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.FLOAT)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.FLOAT)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.LONG)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.LONG.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.LONG)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.LONG.getCanonicalText(), true);
                    }
                } else {
                    if (!PsiType.INT.equals((Object)psiType4) && TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.INT)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.INT.getCanonicalText(), true);
                    }
                    if (!PsiType.INT.equals((Object)psiType5) && TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.INT)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.INT.getCanonicalText(), true);
                    }
                }
            } else if (iElementType == JavaTokenType.GTGT || iElementType == JavaTokenType.LTLT || iElementType == JavaTokenType.GTGTGT) {
                evaluator = Builder.a(psiType, evaluator);
                evaluator2 = Builder.a(psiType2, evaluator2);
            }
            return DisableGC.create(new BinaryExpressionEvaluator(evaluator, evaluator2, iElementType, psiType3.getCanonicalText()));
        }

        private static boolean a(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            if (psiType == null || psiType2 == null) {
                return false;
            }
            if (!TypeConversionUtil.isNumericType((PsiType)psiType) || !TypeConversionUtil.isNumericType((PsiType)psiType2)) {
                return false;
            }
            if (iElementType == JavaTokenType.EQEQ || iElementType == JavaTokenType.NE) {
                if (PsiType.NULL.equals((Object)psiType) || PsiType.NULL.equals((Object)psiType2)) {
                    return false;
                }
                if (psiType instanceof PsiClassType && psiType2 instanceof PsiClassType) {
                    return false;
                }
                if (psiType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null;
                }
                if (psiType2 instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)psiType2) != null;
                }
                return true;
            }
            return iElementType == JavaTokenType.ASTERISK || iElementType == JavaTokenType.DIV || iElementType == JavaTokenType.PERC || iElementType == JavaTokenType.PLUS || iElementType == JavaTokenType.MINUS || iElementType == JavaTokenType.LT || iElementType == JavaTokenType.LE || iElementType == JavaTokenType.GT || iElementType == JavaTokenType.GE || iElementType == JavaTokenType.AND || iElementType == JavaTokenType.XOR || iElementType == JavaTokenType.OR;
        }

        private static boolean b(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            long l2 = h ^ 0x4B6E2C208F13L;
            if (PsiType.NULL.equals((Object)psiType) || PsiType.NULL.equals((Object)psiType2)) {
                return false;
            }
            if (iElementType == JavaTokenType.EQEQ || iElementType == JavaTokenType.NE) {
                return psiType instanceof PsiPrimitiveType && psiType2 instanceof PsiClassType || psiType instanceof PsiClassType && psiType2 instanceof PsiPrimitiveType;
            }
            if (iElementType == JavaTokenType.PLUS && (psiType instanceof PsiClassType && psiType.equalsToText("java.lang.String") || psiType2 instanceof PsiClassType && psiType2.equalsToText("java.lang.String"))) {
                return false;
            }
            return psiType instanceof PsiClassType || psiType2 instanceof PsiClassType;
        }

        @Nullable
        private static PsiType a(PsiPrimitiveType psiPrimitiveType) {
            if (PsiType.BYTE.equals((Object)psiPrimitiveType) || PsiType.SHORT.equals((Object)psiPrimitiveType) || PsiType.CHAR.equals((Object)psiPrimitiveType) || PsiType.INT.equals((Object)psiPrimitiveType)) {
                return PsiType.INT;
            }
            return null;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            long l2 = h ^ 0x718F08E8AEB6L;
            ArrayList<AssignmentEvaluator> arrayList = new ArrayList<AssignmentEvaluator>();
            PsiElement[] psiElementArray = statement2.getDeclaredElements();
            for (PsiElement psiElement : psiElementArray) {
                if (psiElement instanceof PsiLocalVariable) {
                    if (this.f != null) {
                        Object object;
                        PsiExpression psiExpression;
                        PsiLocalVariable psiLocalVariable = (PsiLocalVariable)psiElement;
                        PsiType psiType = psiLocalVariable.getType();
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)psiLocalVariable.getProject());
                        try {
                            psiExpression = psiElementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)psiType), null);
                            object = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)psiExpression, (boolean)true);
                            this.f.setInitialValue(psiLocalVariable.getName(), object);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            a.error((Throwable)incorrectOperationException);
                        }
                        psiExpression = psiLocalVariable.getInitializer();
                        if (psiExpression == null) continue;
                        try {
                            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType, (PsiExpression)psiExpression)) {
                                Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{psiLocalVariable.getName()}));
                            }
                            object = psiExpression.getType();
                            psiExpression.accept((PsiElementVisitor)this);
                            Evaluator evaluator = this.g;
                            PsiExpression psiExpression2 = psiElementFactory.createExpressionFromText(psiLocalVariable.getName(), (PsiElement)psiExpression);
                            psiExpression2.accept((PsiElementVisitor)this);
                            Evaluator evaluator2 = this.g;
                            evaluator = Builder.a(psiExpression2.getType(), (PsiType)object, evaluator);
                            AssignmentEvaluator assignmentEvaluator = new AssignmentEvaluator(evaluator2, evaluator);
                            arrayList.add(assignmentEvaluator);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            a.error((Throwable)incorrectOperationException);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{psiElement.getText()}), null));
            }
            if (!arrayList.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.f);
                codeFragmentEvaluator.setStatements(arrayList.toArray(new Evaluator[0]));
                this.g = codeFragmentEvaluator;
            } else {
                this.g = null;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            long l2 = h ^ 0xF895FC49A24L;
            if (a.isDebugEnabled()) {
                a.debug("visitConditionalExpression " + expression);
            }
            PsiExpression psiExpression = expression.getThenExpression();
            PsiExpression psiExpression2 = expression.getElseExpression();
            if (psiExpression == null || psiExpression2 == null) {
                Builder.a((PsiElement)expression);
            }
            PsiExpression psiExpression3 = expression.getCondition();
            psiExpression3.accept((PsiElementVisitor)this);
            if (this.g == null) {
                Builder.a((PsiElement)psiExpression3);
            }
            UnBoxingEvaluator unBoxingEvaluator = new UnBoxingEvaluator(this.g);
            psiExpression.accept((PsiElementVisitor)this);
            if (this.g == null) {
                Builder.a((PsiElement)psiExpression);
            }
            Evaluator evaluator = this.g;
            psiExpression2.accept((PsiElementVisitor)this);
            if (this.g == null) {
                Builder.a((PsiElement)psiExpression2);
            }
            Evaluator evaluator2 = this.g;
            this.g = new ConditionalExpressionEvaluator(unBoxingEvaluator, evaluator, evaluator2);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            long l2 = h ^ 0xA3CE81FE7BBL;
            if (a.isDebugEnabled()) {
                a.debug("visitReferenceExpression " + expression);
            }
            PsiExpression psiExpression = expression.getQualifierExpression();
            JavaResolveResult javaResolveResult = expression.advancedResolve(true);
            PsiElement psiElement = javaResolveResult.getElement();
            if (psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) {
                Value value = (Value)psiElement.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                if (value != null) {
                    this.g = new IdentityEvaluator(value);
                    return;
                }
                PsiFile psiFile = psiElement.getContainingFile();
                if (psiFile instanceof PsiCodeFragment && this.f != null && this.d.contains(psiFile)) {
                    this.g = new SyntheticVariableEvaluator(this.f, ((PsiVariable)psiElement).getName());
                    return;
                }
                PsiVariable psiVariable = (PsiVariable)psiElement;
                String string = psiVariable.getName();
                PsiClass psiClass = this.a(psiVariable);
                PsiClass psiClass2 = this.a();
                if (Objects.equals(psiClass2, psiClass)) {
                    PsiElement psiElement2 = DebuggerUtilsEx.getContainingMethod((PsiElement)expression);
                    boolean bl2 = psiElement2 instanceof PsiLambdaExpression || ContextUtil.isJspImplicit(psiElement);
                    this.g = new LocalVariableEvaluator(string, bl2);
                    return;
                }
                int n2 = this.a((PsiElement)psiClass, "Base class not found for " + psiVariable.getName(), false) - 1;
                if (n2 > -1) {
                    Object object;
                    PsiExpression psiExpression2 = psiVariable.getInitializer();
                    if (psiExpression2 != null && (object = JavaPsiFacade.getInstance((Project)psiVariable.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)psiExpression2)) != null) {
                        PsiType psiType = javaResolveResult.getSubstitutor().substitute(psiVariable.getType());
                        this.g = new LiteralEvaluator(object, psiType.getCanonicalText());
                        return;
                    }
                    object = new ThisEvaluator(n2);
                    this.g = Builder.a(new FieldEvaluator((Evaluator)object, FieldEvaluator.createClassFilter(psiClass2), "val$" + string), (Evaluator)new LocalVariableEvaluator(string, true));
                    return;
                }
                Builder.a(DebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{string}));
            } else if (psiElement instanceof PsiField) {
                Evaluator evaluator;
                PsiField psiField = (PsiField)psiElement;
                PsiClass psiClass = psiField.getContainingClass();
                if (psiClass == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                    return;
                }
                if (psiField.hasModifierProperty("static")) {
                    JVMName jVMName = JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField));
                    if (jVMName == null) {
                        jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                    }
                    evaluator = new TypeEvaluator(jVMName);
                } else if (psiExpression != null) {
                    psiExpression.accept((PsiElementVisitor)this);
                    evaluator = this.g;
                } else {
                    int n3 = this.a((PsiElement)psiClass, psiClass.getName(), true);
                    if (n3 < 0) {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                    }
                    evaluator = new ThisEvaluator(n3);
                }
                this.g = new FieldEvaluator(evaluator, FieldEvaluator.createClassFilter(psiClass), psiField.getName());
            } else {
                PsiElement psiElement3 = expression.getReferenceNameElement();
                if (!(psiElement3 instanceof PsiIdentifier)) {
                    String string = psiElement3 != null ? psiElement3.getText() : "(null)";
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{string}));
                    return;
                }
                String string = psiElement3.getText();
                if (psiExpression != null) {
                    PsiElement psiElement4;
                    PsiElement psiElement5 = psiElement4 = psiExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)psiExpression).resolve() : null;
                    if (psiElement4 instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)psiElement4;
                        JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.g = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.createClassFilter(psiClass), string);
                    } else {
                        psiExpression.accept((PsiElementVisitor)this);
                        if (this.g == null) {
                            Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{psiExpression.getText()}));
                        }
                        this.g = new FieldEvaluator(this.g, FieldEvaluator.createClassFilter(psiExpression.getType()), string);
                    }
                } else {
                    this.g = Builder.a(new LocalVariableEvaluator(string, false), (Evaluator)new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, string));
                }
            }
        }

        private static Evaluator a(final Evaluator evaluator, final Evaluator evaluator2) {
            return new Evaluator(){
                private boolean a;

                @Override
                public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                    try {
                        return evaluator.evaluate(context);
                    }
                    catch (EvaluateException evaluateException) {
                        try {
                            Object object = evaluator2.evaluate(context);
                            this.a = true;
                            return object;
                        }
                        catch (EvaluateException evaluateException2) {
                            throw evaluateException;
                        }
                    }
                }

                @Override
                public Modifier getModifier() {
                    return this.a ? evaluator2.getModifier() : evaluator.getModifier();
                }
            };
        }

        private static void a(PsiElement psiElement) {
            long l2 = h ^ 0x34943DED2739L;
            Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{psiElement.getText()}));
        }

        private static void a(String string) throws EvaluateRuntimeException {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)string));
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            long l2 = h ^ 0x53EEC2BF23BEL;
            if (a.isDebugEnabled()) {
                a.debug("visitSuperExpression " + expression);
            }
            this.g = new SuperEvaluator(this.a(expression.getQualifier()));
        }

        public void visitThisExpression(PsiThisExpression expression) {
            long l2 = h ^ 0x672AF050567DL;
            if (a.isDebugEnabled()) {
                a.debug("visitThisExpression " + expression);
            }
            this.g = new ThisEvaluator(this.a(expression.getQualifier()));
        }

        private int a(PsiJavaCodeReferenceElement psiJavaCodeReferenceElement) {
            if (psiJavaCodeReferenceElement != null) {
                return this.a(psiJavaCodeReferenceElement.resolve(), psiJavaCodeReferenceElement.getText(), false);
            }
            return 0;
        }

        private int a(PsiElement psiElement, String string, boolean bl2) {
            long l2 = h ^ 0x232787C2BCFBL;
            PsiClass psiClass = this.a();
            if (psiElement == null || psiClass == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{string}));
            }
            try {
                int n2 = Builder.a(psiElement, psiClass, bl2);
                if (n2 < -1 && !psiClass.equals(this.e)) {
                    n2 = Builder.a(psiElement, this.e, bl2);
                }
                return Math.max(0, n2);
            }
            catch (Exception exception) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)exception));
            }
        }

        private static int a(PsiElement psiElement, PsiClass psiClass, boolean bl2) {
            int n2 = 0;
            while (!(psiClass == null || psiClass.equals(psiElement) || bl2 && psiClass.isInheritor((PsiClass)psiElement, true))) {
                ++n2;
                psiClass = Builder.a(psiClass);
            }
            return psiClass != null ? n2 : -1;
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            PsiTypeElement psiTypeElement;
            long l2 = h ^ 0x78055C93D924L;
            if (a.isDebugEnabled()) {
                a.debug("visitInstanceOfExpression " + expression);
            }
            if ((psiTypeElement = expression.getCheckType()) == null) {
                Builder.a((PsiElement)expression);
            }
            PsiType psiType = psiTypeElement.getType();
            expression.getOperand().accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            this.g = new InstanceofEvaluator(evaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiExpression psiExpression;
            long l2 = h ^ 0x3D90FE5ABB3CL;
            if (a.isDebugEnabled()) {
                a.debug("visitParenthesizedExpression " + expression);
            }
            if ((psiExpression = expression.getExpression()) != null) {
                psiExpression.accept((PsiElementVisitor)this);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            long l2 = h ^ 0x28D7DEF7531AL;
            if (expression.getType() == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            PsiExpression psiExpression = expression.getOperand();
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            IElementType iElementType = expression.getOperationTokenType();
            PsiType psiType = psiExpression.getType();
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            Evaluator evaluator2 = Builder.a(evaluator, psiType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, iElementType == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(psiPrimitiveType != null ? psiPrimitiveType : psiType));
            if (psiPrimitiveType != null) {
                evaluator2 = new BoxingEvaluator(evaluator2);
            }
            this.g = new PostfixOperationEvaluator(evaluator, evaluator2);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression psiExpression;
            long l2 = h ^ 0x4E91977A1B9L;
            PsiType psiType = expression.getType();
            if (psiType == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            if ((psiExpression = expression.getOperand()) == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{expression.getText()}));
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            PsiType psiType2 = psiExpression.getType();
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
            IElementType iElementType = expression.getOperationTokenType();
            if (iElementType == JavaTokenType.PLUSPLUS || iElementType == JavaTokenType.MINUSMINUS) {
                try {
                    Evaluator evaluator2 = Builder.a(evaluator, psiType2, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, iElementType == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(psiPrimitiveType != null ? psiPrimitiveType : psiType2));
                    this.g = new AssignmentEvaluator(evaluator, psiPrimitiveType != null ? new BoxingEvaluator(evaluator2) : evaluator2);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    a.error((Throwable)incorrectOperationException);
                }
            } else {
                if (JavaTokenType.PLUS.equals(iElementType) || JavaTokenType.MINUS.equals(iElementType) || JavaTokenType.TILDE.equals(iElementType)) {
                    evaluator = Builder.a(psiType2, evaluator);
                } else if (psiPrimitiveType != null) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
                this.g = new UnaryExpressionEvaluator(iElementType, psiType.getCanonicalText(), evaluator, expression.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            boolean bl2;
            Evaluator evaluator;
            PsiClass psiClass;
            PsiExpression psiExpression;
            long l2 = h ^ 0x740B243FD649L;
            if (a.isDebugEnabled()) {
                a.debug("visitMethodCallExpression " + expression);
            }
            PsiExpressionList psiExpressionList = expression.getArgumentList();
            PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
            Evaluator[] evaluatorArray = new Evaluator[psiExpressionArray.length];
            for (int i10 = 0; i10 < psiExpressionArray.length; ++i10) {
                psiExpression = psiExpressionArray[i10];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.g == null) {
                    Builder.a((PsiElement)psiExpression);
                }
                evaluatorArray[i10] = DisableGC.create(this.g);
            }
            PsiReferenceExpression psiReferenceExpression = expression.getMethodExpression();
            psiExpression = psiReferenceExpression.advancedResolve(false);
            PsiMethod psiMethod = (PsiMethod)psiExpression.getElement();
            PsiExpression psiExpression2 = psiReferenceExpression.getQualifierExpression();
            JVMName jVMName = null;
            if (psiMethod != null) {
                psiClass = psiMethod.getContainingClass();
                jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                if (psiMethod.hasModifierProperty("static")) {
                    evaluator = new TypeEvaluator(jVMName);
                } else if (psiExpression2 != null) {
                    psiExpression2.accept((PsiElementVisitor)this);
                    evaluator = this.g;
                } else {
                    bl2 = false;
                    PsiElement psiElement = psiExpression.getCurrentFileResolveScope();
                    if (psiElement instanceof PsiClass) {
                        bl2 = this.a(psiElement, ((PsiClass)psiElement).getName(), false);
                    }
                    evaluator = new ThisEvaluator(bl2 ? 1 : 0);
                }
            } else if (psiExpression2 != null) {
                psiClass = psiExpression2.getType();
                if (psiClass != null) {
                    jVMName = JVMNameUtil.getJVMQualifiedName((PsiType)psiClass);
                }
                if (psiExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)psiExpression2).resolve() instanceof PsiClass) {
                    if (jVMName == null) {
                        jVMName = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)psiExpression2).getQualifiedName());
                    }
                    evaluator = new TypeEvaluator(jVMName);
                } else {
                    psiExpression2.accept((PsiElementVisitor)this);
                    evaluator = this.g;
                }
            } else {
                evaluator = new ThisEvaluator();
                psiClass = this.a();
                if (psiClass != null) {
                    jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                }
            }
            if (evaluator == null) {
                Builder.a((PsiElement)expression);
            }
            if (psiMethod != null && !psiMethod.isConstructor() && psiMethod.getReturnType() == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
            }
            boolean bl3 = false;
            bl2 = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.a(psiMethod.getParameterList().getParameters(), psiExpressionArray, psiExpression.getSubstitutor(), evaluatorArray);
                bl3 = psiMethod.hasModifierProperty("default");
                bl2 = psiMethod.isVarArgs();
            }
            this.g = new MethodEvaluator(evaluator, jVMName, psiReferenceExpression.getReferenceName(), psiMethod != null ? JVMNameUtil.getJVMSignature(psiMethod) : null, evaluatorArray, bl3, bl2);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            long l2 = h ^ 0x7BB92FB0FE61L;
            HighlightInfo highlightInfo = HighlightUtil.checkLiteralExpressionParsingError((PsiLiteralExpression)expression, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)expression), null);
            if (highlightInfo != null) {
                Builder.a(highlightInfo.getDescription());
                return;
            }
            PsiType psiType = expression.getType();
            if (psiType == null) {
                Builder.a(expression + ": null type");
                return;
            }
            this.g = new LiteralEvaluator(expression.getValue(), psiType.getCanonicalText());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            PsiExpression psiExpression = expression.getIndexExpression();
            if (psiExpression == null) {
                Builder.a((PsiElement)expression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = Builder.a(psiExpression.getType(), this.g);
            expression.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.g;
            this.g = new ArrayAccessEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, Evaluator evaluator) {
            PsiType psiType2;
            PsiPrimitiveType psiPrimitiveType;
            PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            if (psiPrimitiveType2 != null && !PsiType.BOOLEAN.equals((Object)psiPrimitiveType2)) {
                evaluator = new UnBoxingEvaluator(evaluator);
            }
            Object object = psiPrimitiveType = psiPrimitiveType2 != null ? psiPrimitiveType2 : psiType;
            if (psiPrimitiveType instanceof PsiPrimitiveType && (psiType2 = Builder.a(psiPrimitiveType)) != null) {
                evaluator = new TypeCastEvaluator(evaluator, psiType2.getCanonicalText(), true);
            }
            return evaluator;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            boolean bl2;
            long l2 = h ^ 0x5DDCE622F68EL;
            PsiExpression psiExpression = expression.getOperand();
            if (psiExpression == null) {
                Builder.a((PsiElement)expression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.g;
            PsiTypeElement psiTypeElement = expression.getCastType();
            if (psiTypeElement == null) {
                Builder.a((PsiElement)expression);
            }
            PsiType psiType = psiTypeElement.getType();
            PsiType psiType2 = psiExpression.getType();
            if (psiType2 != null && !TypeConversionUtil.areTypesConvertible((PsiType)psiType2, (PsiType)psiType) && PsiUtil.resolveClassInType((PsiType)psiType2) != null) {
                throw new EvaluateRuntimeException(new EvaluateException(JavaErrorMessages.message((String)"inconvertible.type.cast", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)psiType2), JavaHighlightUtil.formatType((PsiType)psiType)})));
            }
            boolean bl3 = psiType2 != null && TypeConversionUtil.boxingConversionApplicable((PsiType)psiType, (PsiType)psiType2);
            boolean bl4 = psiType instanceof PsiPrimitiveType;
            if (bl3 && bl4) {
                evaluator = new UnBoxingEvaluator(evaluator);
            }
            boolean bl5 = bl2 = bl3 && !bl4;
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType) instanceof PsiTypeParameter)) {
                PsiPrimitiveType psiPrimitiveType;
                String string = psiType.getCanonicalText();
                if (bl2 && (psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType)) != null) {
                    string = psiPrimitiveType.getCanonicalText();
                }
                this.g = new TypeCastEvaluator(evaluator, string, bl4);
            }
            if (bl2) {
                this.g = new BoxingEvaluator(this.g);
            }
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
            long l2 = h ^ 0x66B270CCE331L;
            PsiType psiType = expression.getOperand().getType();
            if (psiType instanceof PsiPrimitiveType) {
                JVMName jVMName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)psiType).getBoxedTypeName());
                this.g = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.g = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
            long l2 = h ^ 0x1664D7B3A692L;
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            long l2 = h ^ 0x139F16D8311AL;
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitNewExpression(PsiNewExpression expression) {
            long l2 = h ^ 0x7244F99F6619L;
            PsiType psiType = expression.getType();
            if (psiType instanceof PsiArrayType) {
                Object object;
                Evaluator evaluator = null;
                PsiExpression[] psiExpressionArray = expression.getArrayDimensions();
                if (psiExpressionArray.length == 1) {
                    object = psiExpressionArray[0];
                    object.accept((PsiElementVisitor)this);
                    if (this.g != null) {
                        evaluator = Builder.a(object.getType(), this.g);
                    } else {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{object.getText()}));
                    }
                } else if (psiExpressionArray.length > 1) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                }
                object = null;
                PsiArrayInitializerExpression psiArrayInitializerExpression = expression.getArrayInitializer();
                if (psiArrayInitializerExpression != null) {
                    if (evaluator != null) {
                        Builder.a((PsiElement)expression);
                    }
                    psiArrayInitializerExpression.accept((PsiElementVisitor)this);
                    if (this.g != null) {
                        object = Builder.a(psiArrayInitializerExpression.getType(), this.g);
                    } else {
                        Builder.a((PsiElement)psiArrayInitializerExpression);
                    }
                }
                if (evaluator == null && object == null) {
                    Builder.a((PsiElement)expression);
                }
                this.g = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), evaluator, (Evaluator)object);
            } else if (psiType instanceof PsiClassType) {
                PsiClass psiClass;
                PsiExpression psiExpression;
                PsiClass psiClass2 = ((PsiClassType)psiType).resolve();
                if (psiClass2 instanceof PsiAnonymousClass) {
                    throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0])));
                }
                PsiExpressionList psiExpressionList = expression.getArgumentList();
                if (psiExpressionList == null) {
                    Builder.a((PsiElement)expression);
                }
                PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
                JavaResolveResult javaResolveResult = expression.resolveMethodGenerics();
                PsiMethod psiMethod = (PsiMethod)javaResolveResult.getElement();
                if (psiMethod == null && psiExpressionArray.length > 0) {
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{expression.getText()}), null));
                }
                Object[] objectArray = new Evaluator[psiExpressionArray.length];
                for (int i10 = 0; i10 < psiExpressionArray.length; ++i10) {
                    psiExpression = psiExpressionArray[i10];
                    psiExpression.accept((PsiElementVisitor)this);
                    if (this.g != null) {
                        objectArray[i10] = DisableGC.create(this.g);
                        continue;
                    }
                    Builder.a((PsiElement)psiExpression);
                }
                if (psiMethod != null) {
                    EvaluatorBuilderImpl.a(psiMethod.getParameterList().getParameters(), psiExpressionArray, javaResolveResult.getSubstitutor(), (Evaluator[])objectArray);
                }
                if (psiClass2 != null && (psiClass = psiClass2.getContainingClass()) != null && !psiClass2.hasModifierProperty("static")) {
                    psiExpression = expression.getQualifier();
                    if (psiExpression != null) {
                        psiExpression.accept((PsiElementVisitor)this);
                        if (this.g != null) {
                            objectArray = (Evaluator[])ArrayUtil.prepend((Object)this.g, (Object[])objectArray);
                        }
                    } else {
                        objectArray = (Evaluator[])ArrayUtil.prepend((Object)new ThisEvaluator(this.a((PsiElement)psiClass, "this", false)), (Object[])objectArray);
                    }
                }
                JVMName jVMName = JVMNameUtil.getJVMConstructorSignature(psiMethod, psiClass2);
                this.g = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), jVMName, (Evaluator[])objectArray);
            } else if (psiType != null) {
                Builder.a("Unsupported expression type: " + psiType.getPresentableText());
            } else {
                Builder.a("Unknown type for expression: " + expression.getText());
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            PsiExpression[] psiExpressionArray = expression.getInitializers();
            Evaluator[] evaluatorArray = new Evaluator[psiExpressionArray.length];
            PsiType psiType = expression.getType();
            boolean bl2 = psiType instanceof PsiArrayType && ((PsiArrayType)psiType).getComponentType() instanceof PsiPrimitiveType;
            for (int i10 = 0; i10 < psiExpressionArray.length; ++i10) {
                PsiExpression psiExpression = psiExpressionArray[i10];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.g != null) {
                    Evaluator evaluator = bl2 ? Builder.a(psiExpression.getType(), this.g) : new BoxingEvaluator(this.g);
                    evaluatorArray[i10] = DisableGC.create(evaluator);
                    continue;
                }
                Builder.a((PsiElement)psiExpression);
            }
            this.g = new ArrayInitializerEvaluator(evaluatorArray);
            if (psiType != null && !(expression.getParent() instanceof PsiNewExpression)) {
                this.g = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), null, this.g);
            }
        }

        @Nullable
        private static PsiClass a(PsiClass psiClass) {
            return psiClass == null ? null : (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        }

        @Nullable
        private PsiClass a(@NotNull PsiVariable psiVariable) {
            PsiClass psiClass;
            if (psiVariable == null) {
                Builder.a(3);
            }
            return (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiVariable.getParent(), PsiClass.class, (boolean)false)) == null ? this.e : psiClass;
        }

        @Nullable
        private PsiClass a() {
            return this.b != null ? this.b : this.e;
        }

        protected ExpressionEvaluator buildElement(PsiElement element) throws EvaluateException {
            long l2 = h ^ 0x3B2918D60D88L;
            a.assertTrue(element.isValid());
            this.e = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            try {
                element.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw evaluateRuntimeException.getCause();
            }
            if (this.g == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{element.toString()}));
            }
            return new ExpressionEvaluatorImpl(this.g);
        }

        /* synthetic */ Builder(SourcePosition x0, a x1) {
            this(x0);
        }

        static {
            h = lb.a(7220341388322844655L, 1357648600737589960L, MethodHandles.lookup().lookupClass()).a(155338040972644L);
            long l2 = h ^ 0x7A03391C6692L;
            a = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl");
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = h ^ 0x2DFCA2E1E8DAL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionExpectedType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBinaryEvaluator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContainingClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

