/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import b.a.lb;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeFragmentFactory
extends CodeFragmentFactory {
    public static final Key<String> KEY;
    private static final long a;

    public static DefaultCodeFragmentFactory getInstance() {
        return SingletonHolder.ourInstance;
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        return this.createCodeFragment(item, context, project2);
    }

    public JavaCodeFragment createCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        long l2 = a ^ 0x40BB456DA5F4L;
        JavaCodeFragmentFactory javaCodeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)project2);
        String string = item.getText();
        JavaCodeFragment javaCodeFragment = null;
        if (CodeFragmentKind.EXPRESSION == item.getKind()) {
            try {
                String string2 = StringUtil.trimTrailing((String)string, (char)';');
                if (!string2.isEmpty()) {
                    JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(string2, context);
                }
                javaCodeFragment = javaCodeFragmentFactory.createExpressionCodeFragment(string2, context, null, true);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (javaCodeFragment == null) {
            javaCodeFragment = javaCodeFragmentFactory.createCodeBlockCodeFragment(string, context, true);
        }
        if (item.getImports().length() > 0) {
            javaCodeFragment.addImportsFromString(item.getImports());
        }
        javaCodeFragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        javaCodeFragment.putUserData(KEY, (Object)"DebuggerComboBoxEditor.IS_DEBUGGER_EDITOR");
        javaCodeFragment.putCopyableUserData(JavaCompletionUtil.DYNAMIC_TYPE_EVALUATOR, (psiExpression, completionParameters) -> {
            long l2 = a ^ 0x7F7EBC0F69FDL;
            if (!RuntimeTypeEvaluator.isSubtypeable(psiExpression)) {
                return null;
            }
            if (completionParameters.getInvocationCount() <= 1 && JavaCompletionUtil.mayHaveSideEffects((PsiElement)psiExpression)) {
                CompletionService completionService = CompletionService.getCompletionService();
                if (completionParameters.getInvocationCount() < 2) {
                    completionService.setAdvertisementText("Invoke completion once more to see runtime type variants");
                }
                return null;
            }
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            if (debuggerSession != null && debuggerContextImpl.getSuspendContext() != null) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                final AtomicReference atomicReference = new AtomicReference();
                RuntimeTypeEvaluator runtimeTypeEvaluator = new RuntimeTypeEvaluator(null, (PsiElement)psiExpression, debuggerContextImpl, ProgressManager.getInstance().getProgressIndicator()){

                    @Override
                    protected void typeCalculationFinished(@Nullable PsiType type) {
                        atomicReference.set(type);
                        semaphore.up();
                    }
                };
                debuggerSession.getProcess().getManagerThread().invoke(runtimeTypeEvaluator);
                for (int i10 = 0; i10 < 50; ++i10) {
                    ProgressManager.checkCanceled();
                    if (semaphore.waitFor(20L)) break;
                }
                return (PsiType)atomicReference.get();
            }
            return null;
        });
        return javaCodeFragment;
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return true;
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            DefaultCodeFragmentFactory.a(0);
        }
        return languageFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    public static boolean isDebuggerFile(PsiFile file) {
        return file.getUserData(KEY) != null || file.getUserData(DebuggerExpressionComboBox.KEY) != null;
    }

    static {
        a = lb.a(2505774671302334528L, -1247469942359059144L, MethodHandles.lookup().lookupClass()).a(11623239944428L);
        long l2 = a ^ 0x68DFF57BB7EFL;
        KEY = Key.create((String)"DefaultCodeFragmentFactory.KEY");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = a ^ 0x303213DBA763L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory", "getFileType"));
    }

    private static final class SingletonHolder {
        public static final DefaultCodeFragmentFactory ourInstance = new DefaultCodeFragmentFactory();

        private SingletonHolder() {
        }
    }
}

