/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextImpl
extends XSuspendContext
implements SuspendContext {
    private static final Logger a;
    private final DebugProcessImpl c;
    private final int f;
    private ThreadReferenceProxyImpl j;
    boolean myIsVotedForResume;
    protected int myVotesToVote;
    protected Set<ThreadReferenceProxyImpl> myResumedThreads;
    private final EventSet i;
    private volatile boolean k;
    private final ConcurrentLinkedQueue<SuspendContextCommandImpl> g;
    public volatile boolean myInProgress;
    private final HashSet<ObjectReference> h;
    private EvaluationContextImpl b;
    private JavaExecutionStack d;
    private static final Comparator<JavaExecutionStack> l;
    private static final Comparator<ThreadReferenceProxyImpl> e;
    private static final Comparator<JavaExecutionStack> m;
    private static final long n;

    SuspendContextImpl(@NotNull DebugProcessImpl debugProcess, int suspendPolicy, int eventVotes, EventSet set) {
        if (debugProcess == null) {
            SuspendContextImpl.a(0);
        }
        this.myIsVotedForResume = true;
        this.g = new ConcurrentLinkedQueue();
        this.h = new HashSet();
        this.b = null;
        this.c = debugProcess;
        this.f = suspendPolicy;
        this.myVotesToVote = eventVotes;
        this.i = set;
    }

    public void setThread(ThreadReference thread) {
        this.a();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.c.getVirtualMachineProxy().getThreadReferenceProxy(thread);
        a.assertTrue(this.j == null || this.j == threadReferenceProxyImpl);
        this.j = threadReferenceProxyImpl;
    }

    protected abstract void resumeImpl();

    protected void resume() {
        long l2 = n ^ 0x3B596F9BE0FEL;
        this.a();
        if (this.isEvaluating()) {
            a.error("Resuming context while evaluating", new String[]{ThreadDumper.dumpThreadsToString()});
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                this.h.forEach(DebuggerUtilsEx::enableCollection);
                this.h.clear();
            }
            SuspendContextCommandImpl suspendContextCommandImpl = this.pollPostponedCommand();
            while (suspendContextCommandImpl != null) {
                suspendContextCommandImpl.notifyCancelled();
                suspendContextCommandImpl = this.pollPostponedCommand();
            }
            this.resumeImpl();
        }
        finally {
            this.k = true;
        }
    }

    private void a() {
        long l2 = n ^ 0x6DBCEB61DBDCL;
        if (this.k && this.c.isAttached()) {
            a.error("Cannot access SuspendContext. SuspendContext is resumed.");
        }
    }

    @Nullable
    public EventSet getEventSet() {
        return this.i;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.c;
        if (debugProcessImpl == null) {
            SuspendContextImpl.a(1);
        }
        return debugProcessImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        this.a();
        try {
            return this.j != null && this.j.frameCount() > 0 ? this.j.frame(0) : null;
        }
        catch (EvaluateException evaluateException) {
            return null;
        }
    }

    @Nullable
    public ThreadReferenceProxyImpl getThread() {
        return this.j;
    }

    public int getSuspendPolicy() {
        return this.f;
    }

    public void doNotResumeHack() {
        this.a();
        this.myVotesToVote = 1000000000;
    }

    public boolean isExplicitlyResumed(@Nullable ThreadReferenceProxyImpl thread) {
        return this.myResumedThreads != null && this.myResumedThreads.contains(thread);
    }

    public boolean suspends(ThreadReferenceProxyImpl thread) {
        this.a();
        if (this.isEvaluating()) {
            return false;
        }
        switch (this.getSuspendPolicy()) {
            case 2: {
                return !this.isExplicitlyResumed(thread);
            }
            case 1: {
                return thread == this.getThread();
            }
        }
        return false;
    }

    public boolean isEvaluating() {
        this.a();
        return this.b != null;
    }

    public EvaluationContextImpl getEvaluationContext() {
        return this.b;
    }

    public boolean isResumed() {
        return this.k;
    }

    public void setIsEvaluating(EvaluationContextImpl evaluationContext) {
        this.a();
        this.b = evaluationContext;
    }

    public String toString() {
        long l2 = n ^ 0x49AA3FADE0BCL;
        if (this.i != null) {
            return this.i.toString();
        }
        return this.j != null ? this.j.toString() : DebuggerBundle.message((String)"string.null.context", (Object[])new Object[0]);
    }

    public void keep(ObjectReference reference) {
        boolean bl2;
        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (bl2 = this.h.add(reference))) {
            DebuggerUtilsEx.disableCollection(reference);
        }
    }

    public final void postponeCommand(SuspendContextCommandImpl command) {
        if (!this.isResumed()) {
            command.hold();
            this.g.add(command);
        } else {
            command.notifyCancelled();
        }
    }

    public final SuspendContextCommandImpl pollPostponedCommand() {
        return this.g.poll();
    }

    @Nullable
    public JavaExecutionStack getActiveExecutionStack() {
        return this.d;
    }

    public void initExecutionStacks(ThreadReferenceProxyImpl activeThread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.j == null) {
            this.j = activeThread;
        }
        if (activeThread != null) {
            this.d = new JavaExecutionStack(activeThread, this.c, this.j == activeThread);
            this.d.initTopFrame();
        }
    }

    public void computeExecutionStacks(final XSuspendContext.XExecutionStackContainer container) {
        this.c.getManagerThread().schedule(new SuspendContextCommandImpl(this){
            final Set<ThreadReferenceProxyImpl> myAddedThreads;
            private static final long e = lb.a(-523470227576077806L, 3563333852701328976L, MethodHandles.lookup().lookupClass()).a(244348935627502L);
            {
                super(suspendContext);
                this.myAddedThreads = new HashSet<ThreadReferenceProxyImpl>();
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.b(0);
                }
                if (!this.addThreads(Collections.singletonList(SuspendContextImpl.this.j), null, false)) {
                    return;
                }
                List list2 = StreamEx.of(((SuspendManagerImpl)SuspendContextImpl.this.c.getSuspendManager()).getPausedContexts()).map(SuspendContextImpl::getThread).nonNull().toList();
                if (!this.addThreads(list2, l, false)) {
                    return;
                }
                this.addThreads(SuspendContextImpl.this.getDebugProcess().getVirtualMachineProxy().allThreads(), m, true);
            }

            boolean addThreads(Collection<ThreadReferenceProxyImpl> threads2, @Nullable Comparator<JavaExecutionStack> comparator2, boolean last) {
                ArrayList<JavaExecutionStack> arrayList = new ArrayList<JavaExecutionStack>();
                for (ThreadReferenceProxyImpl threadReferenceProxyImpl : threads2) {
                    if (container.isObsolete()) {
                        return false;
                    }
                    if (threadReferenceProxyImpl == null || !this.myAddedThreads.add(threadReferenceProxyImpl)) continue;
                    arrayList.add(new JavaExecutionStack(threadReferenceProxyImpl, SuspendContextImpl.this.c, threadReferenceProxyImpl == SuspendContextImpl.this.j));
                }
                if (arrayList.size() > 1 && comparator2 != null) {
                    arrayList.sort(comparator2);
                }
                container.addExecutionStack(arrayList, last);
                return true;
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x32D83467D60AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/SuspendContextImpl$1", "contextAction"));
            }
        });
    }

    static {
        n = lb.a(4887382363431929935L, -4885549482603665446L, MethodHandles.lookup().lookupClass()).a(108218996614471L);
        long l2 = n ^ 0x632DEEB66B1FL;
        a = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendContextImpl");
        l = Comparator.comparing(XExecutionStack::getDisplayName, String.CASE_INSENSITIVE_ORDER);
        e = Comparator.comparing(ThreadReferenceProxyImpl::isSuspended).reversed();
        m = Comparator.comparing(JavaExecutionStack::getThreadProxy, e).thenComparing(l);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x38B6CF7896A7L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

