/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.Nullable;

public class LambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final int d;
    @Nullable
    private final SourcePosition c;
    private final int a;
    private final Range<Integer> b;

    public LambdaMethodFilter(PsiLambdaExpression lambda2, int expressionOrdinal, Range<Integer> callingExpressionLines) {
        this.d = expressionOrdinal;
        this.b = callingExpressionLines;
        SourcePosition sourcePosition = null;
        SourcePosition sourcePosition2 = null;
        PsiElement psiElement = lambda2.getBody();
        if (psiElement instanceof PsiCodeBlock) {
            PsiStatement[] psiStatementArray = ((PsiCodeBlock)psiElement).getStatements();
            if (psiStatementArray.length > 0 && (sourcePosition = SourcePosition.createFromElement((PsiElement)psiStatementArray[0])) != null) {
                PsiStatement psiStatement = psiStatementArray[psiStatementArray.length - 1];
                sourcePosition2 = SourcePosition.createFromOffset((PsiFile)sourcePosition.getFile(), (int)psiStatement.getTextRange().getEndOffset());
            }
        } else if (psiElement != null) {
            sourcePosition = SourcePosition.createFromElement((PsiElement)psiElement);
        }
        this.c = sourcePosition;
        this.a = sourcePosition2 != null ? sourcePosition2.getLine() : -1;
    }

    public int getLambdaOrdinal() {
        return this.d;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.c;
    }

    @Override
    public int getLastStatementLine() {
        return this.a;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) throws EvaluateException {
        VirtualMachineProxyImpl virtualMachineProxyImpl = process2.getVirtualMachineProxy();
        Method method = location.method();
        return DebuggerUtilsEx.isLambda(method) && (!virtualMachineProxyImpl.canGetSyntheticAttribute() || method.isSynthetic());
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.b;
    }
}

