/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionStack
extends XExecutionStack {
    private static final Logger d;
    private final ThreadReferenceProxyImpl b;
    private final DebugProcessImpl a;
    private volatile XStackFrame c;
    private volatile boolean f;
    private final MethodsTracker e;
    private static final long g;

    public JavaExecutionStack(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess, boolean current) {
        if (threadProxy == null) {
            JavaExecutionStack.a(0);
        }
        if (debugProcess == null) {
            JavaExecutionStack.a(1);
        }
        super(JavaExecutionStack.a(threadProxy), JavaExecutionStack.a(threadProxy, current));
        this.f = false;
        this.e = new MethodsTracker();
        this.b = threadProxy;
        this.a = debugProcess;
    }

    private static Icon a(ThreadReferenceProxyImpl threadReferenceProxyImpl, boolean bl2) {
        if (bl2) {
            return threadReferenceProxyImpl.isSuspended() ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadRunning;
        }
        if (threadReferenceProxyImpl.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (threadReferenceProxyImpl.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }

    @NotNull
    ThreadReferenceProxyImpl getThreadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.b;
        if (threadReferenceProxyImpl == null) {
            JavaExecutionStack.a(2);
        }
        return threadReferenceProxyImpl;
    }

    public final void initTopFrame() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrameProxyImpl stackFrameProxyImpl = this.b.frame(0);
            if (stackFrameProxyImpl != null) {
                this.c = this.createStackFrame(stackFrameProxyImpl);
            }
        }
        catch (EvaluateException evaluateException) {
            d.info((Throwable)evaluateException);
        }
        finally {
            this.f = true;
        }
    }

    @NotNull
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl stackFrameProxy) {
        XStackFrame xStackFrame;
        Object object;
        StackFrameDescriptorImpl stackFrameDescriptorImpl;
        if (stackFrameProxy == null) {
            JavaExecutionStack.a(3);
        }
        if ((stackFrameDescriptorImpl = new StackFrameDescriptorImpl(stackFrameProxy, this.e)).getUiIndex() == 1 && this.c instanceof JavaStackFrame && (object = stackFrameDescriptorImpl.getMethod()) != null) {
            ((JavaStackFrame)this.c).getDescriptor().putUserData(BreakpointIntentionAction.CALLER_KEY, DebuggerUtilsEx.methodKey((Method)object));
        }
        object = (DebugProcessImpl)stackFrameDescriptorImpl.getDebugProcess();
        Location location = stackFrameDescriptorImpl.getLocation();
        if (location != null && (xStackFrame = ((DebugProcessImpl)((Object)object)).getPositionManager().createStackFrame(stackFrameProxy, (DebugProcessImpl)((Object)object), location)) != null) {
            XStackFrame xStackFrame2 = xStackFrame;
            if (xStackFrame2 == null) {
                JavaExecutionStack.a(4);
            }
            return xStackFrame2;
        }
        JavaStackFrame javaStackFrame = new JavaStackFrame(stackFrameDescriptorImpl, true);
        if (javaStackFrame == null) {
            JavaExecutionStack.a(5);
        }
        return javaStackFrame;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        long l2 = g ^ 0x7397A33720B9L;
        assert (this.f) : "Top frame must be already calculated here";
        return this.c;
    }

    public void computeStackFrames(final int firstFrameIndex, final XExecutionStack.XStackFrameContainer container) {
        if (container.isObsolete()) {
            return;
        }
        this.a.getManagerThread().schedule(new SuspendContextCommandImpl(this.a.getDebuggerContext().getSuspendContext()){
            private static final long e = lb.a(-4032690009244497245L, -5519798344905849470L, MethodHandles.lookup().lookupClass()).a(253946908979792L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                long l2 = e ^ 0x2526A85B7273L;
                if (suspendContext == null) {
                    1.b(0);
                }
                if (container.isObsolete()) {
                    return;
                }
                int n2 = JavaExecutionStack.this.b.status();
                if (n2 == 0) {
                    container.errorOccurred(DebuggerBundle.message((String)"frame.panel.thread.finished", (Object[])new Object[0]));
                } else if (!JavaExecutionStack.this.b.isCollected() && JavaExecutionStack.this.a.getSuspendManager().isSuspended(JavaExecutionStack.this.b)) {
                    if (n2 != -1 && n2 != 5) {
                        try {
                            int n3 = 0;
                            Iterator<StackFrameProxyImpl> iterator = JavaExecutionStack.this.b.frames().iterator();
                            if (iterator.hasNext() && firstFrameIndex > 0) {
                                iterator.next();
                                ++n3;
                            }
                            JavaExecutionStack.this.a.getManagerThread().schedule(new AppendFrameCommand(suspendContext, iterator, container, n3, firstFrameIndex, null));
                        }
                        catch (EvaluateException evaluateException) {
                            container.errorOccurred(evaluateException.getMessage());
                        }
                    }
                } else {
                    container.errorOccurred(DebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x48FB97BB074EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaExecutionStack$1", "contextAction"));
            }
        });
    }

    private static boolean a(@NotNull XStackFrame xStackFrame) {
        if (xStackFrame == null) {
            JavaExecutionStack.a(6);
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames() && xStackFrame instanceof JVMStackFrameInfoProvider) {
            JVMStackFrameInfoProvider jVMStackFrameInfoProvider = (JVMStackFrameInfoProvider)xStackFrame;
            return !jVMStackFrameInfoProvider.isSynthetic() && !jVMStackFrameInfoProvider.isInLibraryContent();
        }
        return true;
    }

    private static String a(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        long l2 = g ^ 0x10059520727EL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        String string = threadReferenceProxyImpl.name();
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = threadReferenceProxyImpl.threadGroupProxy();
        String string2 = threadGroupReferenceProxyImpl != null ? threadGroupReferenceProxyImpl.name() : null;
        String string3 = DebuggerUtilsEx.getThreadStatusText(threadReferenceProxyImpl.status());
        if (string2 != null && !"SYSTEM".equalsIgnoreCase(string2)) {
            return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{string, threadReferenceProxyImpl.uniqueID(), string3, string2});
        }
        return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{string, threadReferenceProxyImpl.uniqueID(), string3});
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        JavaExecutionStack javaExecutionStack = (JavaExecutionStack)((Object)o2);
        return this.b.equals(javaExecutionStack.b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        g = lb.a(-3653342685718901295L, 1786731334286837288L, MethodHandles.lookup().lookupClass()).a(271846177784293L);
        d = Logger.getInstance(JavaExecutionStack.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x7C6733878940L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameProxy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadProxy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackFrame";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showFrame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final Iterator<StackFrameProxyImpl> h;
        private final XExecutionStack.XStackFrameContainer f;
        private int e;
        private final int i;
        private final List<StackFrameItem> g;
        private static final long j = lb.a(-6754988730950097052L, 2331875980196229269L, MethodHandles.lookup().lookupClass()).a(224116374340069L);

        AppendFrameCommand(SuspendContextImpl suspendContext, Iterator<StackFrameProxyImpl> stackFramesIterator, XExecutionStack.XStackFrameContainer container, int added, int skip, List<StackFrameItem> asyncStack) {
            super(suspendContext);
            this.h = stackFramesIterator;
            this.f = container;
            this.e = added;
            this.i = skip;
            this.g = asyncStack;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return this.e <= 10 ? PrioritizedTask.Priority.NORMAL : PrioritizedTask.Priority.LOW;
        }

        private void a(XStackFrame xStackFrame, boolean bl2) {
            if (++this.e > this.i) {
                this.f.addStackFrames(Collections.singletonList(xStackFrame), bl2);
            }
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                AppendFrameCommand.b(0);
            }
            if (this.f.isObsolete()) {
                return;
            }
            if (this.h.hasNext()) {
                StackFrameProxyImpl stackFrameProxyImpl;
                XStackFrame xStackFrame;
                boolean bl2;
                boolean bl3 = bl2 = this.e == 0;
                if (bl2 && JavaExecutionStack.this.f) {
                    xStackFrame = JavaExecutionStack.this.c;
                    stackFrameProxyImpl = this.h.next();
                } else {
                    stackFrameProxyImpl = this.h.next();
                    xStackFrame = JavaExecutionStack.this.createStackFrame(stackFrameProxyImpl);
                    if (bl2 && !JavaExecutionStack.this.f) {
                        JavaExecutionStack.this.c = xStackFrame;
                        JavaExecutionStack.this.f = true;
                    }
                }
                if (bl2 || JavaExecutionStack.a(xStackFrame)) {
                    this.a(xStackFrame, false);
                }
                if (this.g != null) {
                    this.appendRelatedStack(this.g);
                    return;
                }
                List<StackFrameItem> list2 = null;
                if (xStackFrame instanceof JavaStackFrame) {
                    for (AsyncStackTraceProvider asyncStackTraceProvider : AsyncStackTraceProvider.EP.getExtensionList()) {
                        list2 = asyncStackTraceProvider.getAsyncStackTrace((JavaStackFrame)xStackFrame, suspendContext);
                        if (list2 == null) continue;
                        this.appendRelatedStack(list2);
                        return;
                    }
                    list2 = AsyncStacksUtils.getAgentRelatedStack((JavaStackFrame)xStackFrame, suspendContext);
                }
                JavaExecutionStack.this.a.getManagerThread().schedule(new AppendFrameCommand(suspendContext, this.h, this.f, this.e, this.i, list2));
            } else {
                this.f.addStackFrames(Collections.emptyList(), true);
            }
        }

        void appendRelatedStack(@NotNull List<StackFrameItem> asyncStack) {
            if (asyncStack == null) {
                AppendFrameCommand.b(1);
            }
            int n2 = 0;
            boolean bl2 = true;
            for (StackFrameItem stackFrameItem : asyncStack) {
                if (n2 > AsyncStacksUtils.getMaxStackLength()) {
                    this.a(new XStackFrame(){
                        private static final long a = lb.a(8961668862933629913L, 4704324190683216108L, MethodHandles.lookup().lookupClass()).a(227953690866569L);

                        public void customizePresentation(@NotNull ColoredTextContainer component) {
                            long l2 = a ^ 0x67A0C33762DAL;
                            if (component == null) {
                                1.a(0);
                            }
                            component.append("Too many frames, the rest is truncated...", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        }

                        private static /* synthetic */ void a(int n2) {
                            long l2 = a ^ 0x50A0BFA9BB15L;
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand$1", "customizePresentation"));
                        }
                    }, true);
                    return;
                }
                ++n2;
                if (stackFrameItem == null) {
                    bl2 = true;
                    continue;
                }
                StackFrameItem.CapturedStackFrame capturedStackFrame = stackFrameItem.createFrame(JavaExecutionStack.this.a);
                if (!JavaExecutionStack.a(capturedStackFrame)) continue;
                capturedStackFrame.setWithSeparator(bl2);
                this.a(capturedStackFrame, false);
                bl2 = false;
            }
            this.f.addStackFrames(Collections.emptyList(), true);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = j ^ 0x1C12D96AFEFDL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "asyncStack";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendRelatedStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

