/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JVMNameUtil {
    private static final Logger a;
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final long b;

    @Nullable
    public static String getPrimitiveSignature(String typeName) {
        if (PsiType.BOOLEAN.getCanonicalText().equals(typeName)) {
            return "Z";
        }
        if (PsiType.BYTE.getCanonicalText().equals(typeName)) {
            return "B";
        }
        if (PsiType.CHAR.getCanonicalText().equals(typeName)) {
            return "C";
        }
        if (PsiType.SHORT.getCanonicalText().equals(typeName)) {
            return "S";
        }
        if (PsiType.INT.getCanonicalText().equals(typeName)) {
            return "I";
        }
        if (PsiType.LONG.getCanonicalText().equals(typeName)) {
            return "J";
        }
        if (PsiType.FLOAT.getCanonicalText().equals(typeName)) {
            return "F";
        }
        if (PsiType.DOUBLE.getCanonicalText().equals(typeName)) {
            return "D";
        }
        if (PsiType.VOID.getCanonicalText().equals(typeName)) {
            return "V";
        }
        return null;
    }

    private static void a(JVMNameBuffer jVMNameBuffer, PsiType psiType) {
        long l2 = b ^ 0x6DFCD9698CF9L;
        if (psiType == null) {
            return;
        }
        PsiType psiType2 = TypeConversionUtil.erasure((PsiType)psiType);
        if (psiType2 instanceof PsiArrayType) {
            jVMNameBuffer.append(new JVMRawText("["));
            JVMNameUtil.a(jVMNameBuffer, ((PsiArrayType)psiType2).getComponentType());
        } else if (psiType2 instanceof PsiClassType) {
            JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiType2);
            JVMNameUtil.a(jVMNameBuffer, jVMName);
        } else if (psiType2 instanceof PsiPrimitiveType) {
            jVMNameBuffer.append(JVMNameUtil.getPrimitiveSignature(psiType2.getCanonicalText()));
        } else {
            a.error("unknown type " + psiType.getCanonicalText());
        }
    }

    private static void a(JVMNameBuffer jVMNameBuffer, final JVMName jVMName) {
        jVMNameBuffer.append("L");
        if (jVMName instanceof JVMRawText) {
            jVMNameBuffer.append(((JVMRawText)jVMName).getName().replace('.', '/'));
        } else {
            jVMNameBuffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    return jVMName.getName(process2).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    return jVMName.getDisplayName(debugProcess);
                }
            });
        }
        jVMNameBuffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String qualifiedName) {
        JVMRawText jVMRawText = new JVMRawText(qualifiedName);
        if (jVMRawText == null) {
            JVMNameUtil.a(0);
        }
        return jVMRawText;
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        long l2 = b ^ 0x1D7C6165EB8BL;
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiArrayType.getComponentType());
            JVMNameBuffer jVMNameBuffer = new JVMNameBuffer();
            jVMNameBuffer.append(jVMName);
            jVMNameBuffer.append("[]");
            return jVMNameBuffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass == null) {
            return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        String string;
        if (psiClass == null) {
            JVMNameUtil.a(1);
        }
        if ((string = JVMNameUtil.getNonAnonymousClassName(psiClass)) != null) {
            JVMName jVMName = JVMNameUtil.getJVMRawText(string);
            if (jVMName == null) {
                JVMNameUtil.a(2);
            }
            return jVMName;
        }
        JVMClassAt jVMClassAt = new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
        if (jVMClassAt == null) {
            JVMNameUtil.a(3);
        }
        return jVMClassAt;
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition pos) {
        PsiClass psiClass = JVMNameUtil.getClassAt(pos);
        if (psiClass == null) {
            return null;
        }
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (string != null) {
            return JVMNameUtil.getJVMRawText(string);
        }
        return new JVMClassAt(pos);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JVMNameUtil.a(4);
        }
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            return null;
        }
        String string = aClass.getName();
        if (string == null) {
            return null;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (psiClass != null) {
            String string2 = JVMNameUtil.getNonAnonymousClassName(psiClass);
            if (string2 == null) {
                return null;
            }
            return string2 + "$" + string;
        }
        return DebuggerManager.getInstance((Project)aClass.getProject()).getVMClassQualifiedName(aClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod method, @Nullable PsiClass declaringClass) {
        JVMName jVMName = JVMNameUtil.a(method, true, declaringClass);
        if (jVMName == null) {
            JVMNameUtil.a(5);
        }
        return jVMName;
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod method) {
        if (method == null) {
            JVMNameUtil.a(6);
        }
        JVMName jVMName = JVMNameUtil.a(method, method.isConstructor(), method.getContainingClass());
        if (jVMName == null) {
            JVMNameUtil.a(7);
        }
        return jVMName;
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod method) {
        long l2 = b ^ 0x6B98E50BF2B5L;
        if (method == null) {
            JVMNameUtil.a(8);
        }
        String string = method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
        if (string == null) {
            JVMNameUtil.a(9);
        }
        return string;
    }

    @NotNull
    private static JVMName a(@Nullable PsiMethod psiMethod, boolean bl2, @Nullable PsiClass psiClass) {
        PsiParameter[] psiParameterArray;
        long l2 = b ^ 0x2A36FD74E5CBL;
        JVMNameBuffer jVMNameBuffer = new JVMNameBuffer();
        jVMNameBuffer.append("(");
        if (bl2 && psiClass != null && (psiParameterArray = psiClass.getContainingClass()) != null && !psiClass.hasModifierProperty("static")) {
            JVMNameUtil.a(jVMNameBuffer, JVMNameUtil.getJVMQualifiedName((PsiClass)psiParameterArray));
        }
        if (psiMethod != null) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                JVMNameUtil.a(jVMNameBuffer, psiParameter.getType());
            }
        }
        jVMNameBuffer.append(")");
        if (!bl2 && psiMethod != null) {
            JVMNameUtil.a(jVMNameBuffer, psiMethod.getReturnType());
        } else {
            jVMNameBuffer.append(new JVMRawText("V"));
        }
        JVMName jVMName = jVMNameBuffer.toName();
        if (jVMName == null) {
            JVMNameUtil.a(10);
        }
        return jVMName;
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        PsiElement psiElement = position.getElementAt();
        return psiElement != null && psiElement.isValid() ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false) : null;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        Object object;
        long l2 = b ^ 0x6D85CAF9D9ECL;
        if (position == null) {
            return null;
        }
        PsiFile psiFile = position.getFile();
        if (psiFile instanceof JspFile) {
            return psiFile.getName();
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (object = psiClass.getQualifiedName()) != null) {
            return object;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(object = debugProcess.getPositionManager().getAllClasses(position)).isEmpty()) {
            return ((ReferenceType)object.get(0)).name();
        }
        if (psiClass == null) {
            if (psiFile instanceof PsiClassOwner) {
                return psiFile.getName();
            }
            return DebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{psiFile.getName(), position.getLine()});
        }
        return JVMNameUtil.calcClassDisplayName(psiClass);
    }

    static String calcClassDisplayName(final PsiClass aClass) {
        String string = aClass.getQualifiedName();
        if (string != null) {
            return string;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (psiClass == null) {
            return null;
        }
        String string2 = aClass.getName();
        if (string2 != null) {
            return JVMNameUtil.calcClassDisplayName(psiClass) + "$" + string2;
        }
        final Ref ref = new Ref((Object)0);
        try {
            psiClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass cls) {
                    ref.set((Object)((Integer)ref.get() + 1));
                    if (aClass.equals(cls)) {
                        throw new ProcessCanceledException();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(psiClass) + "$" + ref.get();
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        int n2;
        String string;
        Object object;
        if (position == null) {
            return null;
        }
        PsiFile psiFile = position.getFile();
        if (psiFile instanceof JspFile) {
            PsiDirectory psiDirectory = psiFile.getContainingDirectory();
            return psiDirectory != null ? psiDirectory.getVirtualFile().getPresentableUrl() : null;
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (object = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (string = object.getQualifiedName()) != null) {
            int n3 = string.lastIndexOf(46);
            return n3 > 0 ? string.substring(0, n3) : "";
        }
        if (psiFile instanceof PsiClassOwner && !StringUtil.isEmpty((String)(object = ((PsiClassOwner)psiFile).getPackageName()))) {
            return object;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(object = debugProcess.getPositionManager().getAllClasses(position)).isEmpty() && (n2 = (string = ((ReferenceType)object.get(0)).name()).lastIndexOf(46)) >= 0) {
            return string.substring(0, n2);
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return null;
        }
        if (containingClass instanceof PsiAnonymousClass) {
            String string = JVMNameUtil.getClassVMName((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class));
            if (string == null) {
                return null;
            }
            return string + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)containingClass));
        }
        return JVMNameUtil.getNonAnonymousClassName(containingClass);
    }

    static {
        b = lb.a(-1879638475386774629L, 2379568909106133927L, MethodHandles.lookup().lookupClass()).a(202488321488209L);
        long l2 = b ^ 0x1C468334DD71L;
        a = Logger.getInstance((String)"#com.intellij.debugger.engine.JVMNameUtil");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x424C57160EF4L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMRawText";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMConstructorSignature";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMMethodName";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJVMQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNonAnonymousClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJVMSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJVMMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition a;
        private static final long b = lb.a(3723387690220526178L, 2410837903639453668L, MethodHandles.lookup().lookupClass()).a(214708361130275L);

        JVMClassAt(SourcePosition sourcePosition) {
            this.a = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            long l2 = b ^ 0x418E40300DAFL;
            List<ReferenceType> list2 = process2.getPositionManager().getAllClasses(this.a);
            if (list2.size() > 1) {
                String string = (String)ReadAction.compute(() -> JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(this.a)));
                for (ReferenceType referenceType : list2) {
                    if (!Comparing.equal((String)referenceType.name(), (String)string)) continue;
                    return string;
                }
            }
            if (!list2.isEmpty()) {
                return list2.get(0).name();
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(process2)}));
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return (String)ReadAction.compute(() -> JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.a));
        }
    }

    private static class JVMRawText
    implements JVMName {
        private String a;

        JVMRawText(String text2) {
            this.a = text2;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            return this.a;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return this.a;
        }

        public String getName() {
            return this.a;
        }

        public void setName(String name2) {
            this.a = name2;
        }

        public String toString() {
            return this.a;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> a = new ArrayList<JVMName>();
        private static final long b = lb.a(5206453867880255694L, 3663014412261397032L, MethodHandles.lookup().lookupClass()).a(118534962820202L);

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName evaluator) {
            if (evaluator == null) {
                JVMNameBuffer.a(0);
            }
            this.a.add(evaluator);
        }

        public void append(char name2) {
            this.append(Character.toString(name2));
        }

        public void append(String text2) {
            this.a.add(JVMNameUtil.getJVMRawText(text2));
        }

        public JVMName toName() {
            final ArrayList<JVMName> arrayList = new ArrayList<JVMName>();
            for (JVMName jVMName : this.a) {
                if (jVMName instanceof JVMRawText && !arrayList.isEmpty() && arrayList.get(arrayList.size() - 1) instanceof JVMRawText) {
                    JVMRawText jVMRawText = (JVMRawText)arrayList.get(arrayList.size() - 1);
                    jVMRawText.setName(jVMRawText.getName() + ((JVMRawText)jVMName).getName());
                    continue;
                }
                arrayList.add(jVMName);
            }
            if (arrayList.size() == 1) {
                return (JVMName)arrayList.get(0);
            }
            if (arrayList.isEmpty()) {
                return new JVMRawText("");
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getName(process2);
                        }
                        this.myName = string;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    if (this.myName == null) {
                        String string = "";
                        for (JVMName jVMName : arrayList) {
                            string = string + jVMName.getDisplayName(debugProcess);
                        }
                        return string;
                    }
                    return this.myName;
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x6DCFAE9655C2L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/JVMNameUtil$JVMNameBuffer", "append"));
        }
    }
}

